/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.event;

import org.springframework.lang.Nullable;
import org.springframework.test.context.event.ApplicationEvents;
import org.springframework.test.context.event.DefaultApplicationEvents;
import org.springframework.util.Assert;

public abstract class ApplicationEventsHolder {
    private static final ThreadLocal<DefaultApplicationEvents> applicationEvents = new ThreadLocal();

    private ApplicationEventsHolder() {
    }

    @Nullable
    public static ApplicationEvents getApplicationEvents() {
        return applicationEvents.get();
    }

    public static ApplicationEvents getRequiredApplicationEvents() {
        ApplicationEvents events = applicationEvents.get();
        Assert.state((events != null ? 1 : 0) != 0, (String)"Failed to retrieve ApplicationEvents for the current thread. Ensure that your test class is annotated with @RecordApplicationEvents and that the ApplicationEventsTestExecutionListener is registered.");
        return events;
    }

    static void registerApplicationEventsIfNecessary() {
        if (ApplicationEventsHolder.getApplicationEvents() == null) {
            ApplicationEventsHolder.registerApplicationEvents();
        }
    }

    static void registerApplicationEvents() {
        applicationEvents.set(new DefaultApplicationEvents());
    }

    static void unregisterApplicationEvents() {
        applicationEvents.remove();
    }
}

