/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.UUID;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRPropertyExpression;
import net.sf.jasperreports.engine.base.JRBasePart;
import net.sf.jasperreports.engine.part.PartComponent;
import net.sf.jasperreports.engine.part.PartEvaluationTime;
import net.sf.jasperreports.engine.util.JRCloneUtils;

public class JRDesignPart
extends JRBasePart {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_PROPERTY_EXPRESSIONS = "propertyExpressions";
    public static final String PROPERTY_PRINT_WHEN_EXPRESSION = "printWhenExpression";
    public static final String PROPERTY_PART_NAME_EXPRESSION = "partNameExpression";
    public static final String PROPERTY_COMPONENT = "component";
    public static final String PROPERTY_EVALUATION_TIME = "evaluationTime";
    private List<JRPropertyExpression> propertyExpressions = new ArrayList<JRPropertyExpression>();

    public void setUUID(UUID uuid) {
        this.uuid = uuid;
    }

    public void addPropertyExpression(JRPropertyExpression propertyExpression) {
        this.propertyExpressions.add(propertyExpression);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_PROPERTY_EXPRESSIONS, propertyExpression, this.propertyExpressions.size() - 1);
    }

    public void removePropertyExpression(JRPropertyExpression propertyExpression) {
        int idx = this.propertyExpressions.indexOf(propertyExpression);
        if (idx >= 0) {
            this.propertyExpressions.remove(idx);
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_PROPERTY_EXPRESSIONS, propertyExpression, idx);
        }
    }

    public JRPropertyExpression removePropertyExpression(String name) {
        JRPropertyExpression removed = null;
        ListIterator<JRPropertyExpression> it = this.propertyExpressions.listIterator();
        while (it.hasNext()) {
            JRPropertyExpression prop = it.next();
            if (!name.equals(prop.getName())) continue;
            removed = prop;
            int idx = it.previousIndex();
            it.remove();
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_PROPERTY_EXPRESSIONS, removed, idx);
            break;
        }
        return removed;
    }

    @JsonIgnore
    public List<JRPropertyExpression> getPropertyExpressionsList() {
        return this.propertyExpressions;
    }

    @JsonSetter
    private void setPropertyExpressions(List<JRPropertyExpression> propertyExpressions) {
        if (propertyExpressions != null) {
            for (JRPropertyExpression propertyExpression : propertyExpressions) {
                this.addPropertyExpression(propertyExpression);
            }
        }
    }

    @Override
    public JRPropertyExpression[] getPropertyExpressions() {
        JRPropertyExpression[] props = this.propertyExpressions.isEmpty() ? null : this.propertyExpressions.toArray(new JRPropertyExpression[this.propertyExpressions.size()]);
        return props;
    }

    public void setPrintWhenExpression(JRExpression expression) {
        JRExpression old = this.printWhenExpression;
        this.printWhenExpression = expression;
        this.getEventSupport().firePropertyChange(PROPERTY_PRINT_WHEN_EXPRESSION, old, this.printWhenExpression);
    }

    public void setPartNameExpression(JRExpression expression) {
        JRExpression old = this.partNameExpression;
        this.partNameExpression = expression;
        this.getEventSupport().firePropertyChange(PROPERTY_PART_NAME_EXPRESSION, old, this.partNameExpression);
    }

    public void setComponent(PartComponent component) {
        PartComponent old = this.component;
        this.component = component;
        this.getEventSupport().firePropertyChange(PROPERTY_COMPONENT, old, this.component);
    }

    public void setEvaluationTime(PartEvaluationTime evaluationTime) {
        PartEvaluationTime old = this.evaluationTime;
        this.evaluationTime = evaluationTime;
        this.getEventSupport().firePropertyChange(PROPERTY_EVALUATION_TIME, old, this.evaluationTime);
    }

    @Override
    public Object clone() {
        JRDesignPart clone = (JRDesignPart)super.clone();
        clone.propertyExpressions = JRCloneUtils.cloneList(this.propertyExpressions);
        return clone;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (this.propertyExpressions == null) {
            this.propertyExpressions = new ArrayList<JRPropertyExpression>();
        }
    }
}

