/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import net.sf.jasperreports.engine.fill.JRAbstractExtendedIncrementerFactory;
import net.sf.jasperreports.engine.fill.JRComparableIncrementerFactory;
import net.sf.jasperreports.engine.fill.JRDefaultIncrementerFactory;
import net.sf.jasperreports.engine.fill.JRExtendedIncrementer;
import net.sf.jasperreports.engine.fill.JRIntegerAverageIncrementer;
import net.sf.jasperreports.engine.fill.JRIntegerCountIncrementer;
import net.sf.jasperreports.engine.fill.JRIntegerDistinctCountIncrementer;
import net.sf.jasperreports.engine.fill.JRIntegerStandardDeviationIncrementer;
import net.sf.jasperreports.engine.fill.JRIntegerSumIncrementer;
import net.sf.jasperreports.engine.fill.JRIntegerVarianceIncrementer;
import net.sf.jasperreports.engine.type.CalculationEnum;

public final class JRIntegerIncrementerFactory
extends JRAbstractExtendedIncrementerFactory {
    protected static final Integer ZERO = 0;
    private static JRIntegerIncrementerFactory mainInstance = new JRIntegerIncrementerFactory();

    private JRIntegerIncrementerFactory() {
    }

    public static JRIntegerIncrementerFactory getInstance() {
        return mainInstance;
    }

    @Override
    public JRExtendedIncrementer getExtendedIncrementer(CalculationEnum calculation) {
        JRExtendedIncrementer incrementer = null;
        switch (calculation) {
            case COUNT: {
                incrementer = JRIntegerCountIncrementer.getInstance();
                break;
            }
            case SUM: {
                incrementer = JRIntegerSumIncrementer.getInstance();
                break;
            }
            case AVERAGE: {
                incrementer = JRIntegerAverageIncrementer.getInstance();
                break;
            }
            case LOWEST: 
            case HIGHEST: {
                incrementer = JRComparableIncrementerFactory.getInstance().getExtendedIncrementer(calculation);
                break;
            }
            case STANDARD_DEVIATION: {
                incrementer = JRIntegerStandardDeviationIncrementer.getInstance();
                break;
            }
            case VARIANCE: {
                incrementer = JRIntegerVarianceIncrementer.getInstance();
                break;
            }
            case DISTINCT_COUNT: {
                incrementer = JRIntegerDistinctCountIncrementer.getInstance();
                break;
            }
            default: {
                incrementer = JRDefaultIncrementerFactory.getInstance().getExtendedIncrementer(calculation);
            }
        }
        return incrementer;
    }
}

