/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.service;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.structure.service.Service;
import org.apache.tinkerpop.gremlin.structure.util.CloseableIterator;
import org.apache.tinkerpop.shaded.jackson.core.JsonProcessingException;
import org.apache.tinkerpop.shaded.jackson.databind.ObjectMapper;

public class ServiceRegistry
implements Service.DirectoryService,
AutoCloseable {
    public static final ServiceRegistry EMPTY = new ServiceRegistry(){

        @Override
        public Service.ServiceFactory registerService(Service.ServiceFactory service) {
            throw new UnsupportedOperationException();
        }
    };
    private final LinkedHashMap<String, Service.ServiceFactory> services = new LinkedHashMap();

    public Service.ServiceFactory registerService(Service.ServiceFactory serviceFactory) {
        Objects.requireNonNull(serviceFactory);
        this.services.put(serviceFactory.getName(), serviceFactory);
        return serviceFactory;
    }

    public void checkRegisteredService(String service) {
        if (service != null && !this.services.containsKey(service)) {
            throw new IllegalArgumentException("Unrecognized service: " + service);
        }
    }

    public Service get(String service, boolean isStart, Map params) {
        if (service == null || service.equals("--list")) {
            return this;
        }
        this.checkRegisteredService(service);
        return this.services.get(service).createService(isStart, params);
    }

    @Override
    public CloseableIterator execute(Service.ServiceCallContext ctx, Map params) {
        boolean verbose = params.getOrDefault("verbose", false);
        String serviceName = (String)params.get("service");
        return CloseableIterator.of(this.services.values().stream().filter(s -> serviceName == null || s.getName().equals(serviceName)).map(s -> verbose ? this.describe((Service.ServiceFactory)s) : s.getName()).iterator());
    }

    protected String describe(Service.ServiceFactory service) {
        LinkedHashMap<String, Object> description = new LinkedHashMap<String, Object>();
        description.put("name", service.getName());
        LinkedHashMap<Service.Type, Set<TraverserRequirement>> types = new LinkedHashMap<Service.Type, Set<TraverserRequirement>>();
        for (Service.Type type : service.getSupportedTypes()) {
            types.put(type, service.getRequirements(type));
        }
        description.put("type:[requirements]:", types);
        description.put("params", service.describeParams());
        ObjectMapper om = new ObjectMapper();
        try {
            return om.writeValueAsString(description);
        }
        catch (JsonProcessingException ex) {
            return ((Object)description).toString();
        }
    }

    @Override
    public void close() {
        this.services.values().forEach(Service.ServiceFactory::close);
    }
}

