/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.intercept;

import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import java.util.HashMap;
import org.apache.webbeans.intercept.NormalScopedBeanInterceptorHandler;

public class SessionScopedBeanInterceptorHandler
extends NormalScopedBeanInterceptorHandler {
    private static final long serialVersionUID = 1L;
    private static ThreadLocal<HashMap<Bean<?>, Object>> cachedInstances = new ThreadLocal();

    public static void removeThreadLocals() {
        cachedInstances.set(null);
        cachedInstances.remove();
    }

    public SessionScopedBeanInterceptorHandler(BeanManager beanManager, Bean<?> bean) {
        super(beanManager, bean);
    }

    @Override
    protected Object getContextualInstance() {
        Object cachedInstance;
        HashMap<Object, Object> beanMap = cachedInstances.get();
        if (beanMap == null) {
            beanMap = new HashMap();
            cachedInstances.set(beanMap);
        }
        if ((cachedInstance = beanMap.get(this.bean)) == null) {
            cachedInstance = super.getContextualInstance();
            beanMap.put(this.bean, cachedInstance);
        }
        return cachedInstance;
    }
}

