/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.security.http.openid;

import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.security.enterprise.authentication.mechanism.http.openid.OpenIdProviderMetadata;
import java.lang.annotation.Annotation;
import java.util.stream.Collectors;

public class CompositeOpenIdProviderMetadata
implements OpenIdProviderMetadata {
    private final JsonObject openidProviderMetadata;
    private final OpenIdProviderMetadata openIdProviderMetadataOverride;

    public CompositeOpenIdProviderMetadata(JsonObject openidProviderMetadata, OpenIdProviderMetadata openIdProviderMetadataOverride) {
        this.openidProviderMetadata = openidProviderMetadata;
        this.openIdProviderMetadataOverride = openIdProviderMetadataOverride;
    }

    public String authorizationEndpoint() {
        if (!this.openIdProviderMetadataOverride.authorizationEndpoint().isEmpty()) {
            return this.openIdProviderMetadataOverride.authorizationEndpoint();
        }
        return this.openidProviderMetadata.getString("authorization_endpoint");
    }

    public String tokenEndpoint() {
        if (!this.openIdProviderMetadataOverride.tokenEndpoint().isEmpty()) {
            return this.openIdProviderMetadataOverride.tokenEndpoint();
        }
        return this.openidProviderMetadata.getString("token_endpoint");
    }

    public String userinfoEndpoint() {
        if (!this.openIdProviderMetadataOverride.userinfoEndpoint().isEmpty()) {
            return this.openIdProviderMetadataOverride.userinfoEndpoint();
        }
        return this.openidProviderMetadata.getString("userinfo_endpoint");
    }

    public String endSessionEndpoint() {
        if (!this.openIdProviderMetadataOverride.endSessionEndpoint().isEmpty()) {
            return this.openIdProviderMetadataOverride.endSessionEndpoint();
        }
        return this.openidProviderMetadata.getString("end_session_endpoint");
    }

    public String jwksURI() {
        if (!this.openIdProviderMetadataOverride.jwksURI().isEmpty()) {
            return this.openIdProviderMetadataOverride.jwksURI();
        }
        return this.openidProviderMetadata.getString("jwks_uri");
    }

    public String issuer() {
        if (!this.openIdProviderMetadataOverride.issuer().isEmpty()) {
            return this.openIdProviderMetadataOverride.issuer();
        }
        return this.openidProviderMetadata.getString("issuer");
    }

    public String subjectTypeSupported() {
        if (this.openidProviderMetadata.containsKey((Object)"subject_types_supported")) {
            return this.openidProviderMetadata.getJsonArray("subject_types_supported").stream().map(JsonString.class::cast).map(JsonString::getString).collect(Collectors.joining(", "));
        }
        return this.openIdProviderMetadataOverride.subjectTypeSupported();
    }

    public String idTokenSigningAlgorithmsSupported() {
        if (this.openidProviderMetadata.containsKey((Object)"id_token_signing_alg_values_supported")) {
            return this.openidProviderMetadata.getJsonArray("id_token_signing_alg_values_supported").stream().map(JsonString.class::cast).map(JsonString::getString).collect(Collectors.joining(", "));
        }
        return this.openIdProviderMetadataOverride.idTokenSigningAlgorithmsSupported();
    }

    public String responseTypeSupported() {
        if (this.openidProviderMetadata.containsKey((Object)"response_types_supported")) {
            return this.openidProviderMetadata.getJsonArray("response_types_supported").stream().map(JsonString.class::cast).map(JsonString::getString).collect(Collectors.joining(", "));
        }
        return this.openIdProviderMetadataOverride.responseTypeSupported();
    }

    public Class<? extends Annotation> annotationType() {
        return OpenIdProviderMetadata.class;
    }
}

