/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import java.util.Collections;
import java.util.List;
import wiremock.com.fasterxml.jackson.annotation.JsonProperty;

public class Errors {
    private final List<Error> errors;

    public Errors(@JsonProperty(value="errors") List<Error> errors) {
        this.errors = errors;
    }

    public static Errors single(Integer code, String sourcePointer, String title) {
        return new Errors(Collections.singletonList(new Error(code, new Error.Source(sourcePointer), title)));
    }

    public static Errors single(Integer code, String title) {
        return new Errors(Collections.singletonList(new Error(code, title)));
    }

    public static Errors notRecording() {
        return Errors.single(30, "Not currently recording.");
    }

    public static Errors validation(String pointer, String message) {
        return Errors.single(10, pointer, message);
    }

    public Error first() {
        if (this.errors.isEmpty()) {
            throw new IllegalStateException("No errors are present");
        }
        return this.errors.get(0);
    }

    public List<Error> getErrors() {
        return this.errors;
    }

    public static class Error {
        private final Integer code;
        private final Source source;
        private final String title;

        public Error(@JsonProperty(value="code") Integer code, @JsonProperty(value="source") Source source, @JsonProperty(value="title") String title) {
            this.code = code;
            this.source = source;
            this.title = title;
        }

        public Error(int code, String title) {
            this(code, null, title);
        }

        public Integer getCode() {
            return this.code;
        }

        public Source getSource() {
            return this.source;
        }

        public String getTitle() {
            return this.title;
        }

        public static class Source {
            private final String pointer;

            public Source(@JsonProperty(value="pointer") String pointer) {
                this.pointer = pointer;
            }

            public String getPointer() {
                return this.pointer;
            }
        }
    }
}

