/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.testing.ui.views;

import java.util.List;
import org.apache.uima.ruta.testing.ui.views.TestViewPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class InfoPanel
extends Composite {
    private final Image fErrorIcon = TestViewPage.createImage("/icons/error_ovr.gif");
    private final Image fFailureIcon = TestViewPage.createImage("/icons/failed_ovr.gif");
    Text fileLabel;
    Text runLabel;
    Text fpLabel;
    Text fnLabel;
    Text fMLabel;
    Combo comboBox;

    public InfoPanel(Composite parent) {
        super(parent, 64);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        this.setLayout((Layout)gridLayout);
        Composite fileInfoComposite = new Composite((Composite)this, 64);
        GridLayout fileInfoLayout = new GridLayout();
        fileInfoLayout.numColumns = 3;
        fileInfoComposite.setLayout((Layout)fileInfoLayout);
        GridData fileInfoData = new GridData(32);
        fileInfoComposite.setLayoutData((Object)fileInfoData);
        this.fileLabel = this.createLabel("Script :", null, "--", fileInfoComposite);
        this.comboBox = new Combo((Composite)this, 4);
        this.comboBox.add("_InitialView");
        this.comboBox.select(0);
        Composite testInfoComposite = new Composite((Composite)this, 64);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        testInfoComposite.setLayoutData((Object)data);
        GridLayout testInfoLayout = new GridLayout();
        testInfoLayout.numColumns = 12;
        GridData testInfoData = new GridData(800);
        testInfoComposite.setLayoutData((Object)testInfoData);
        testInfoComposite.setLayout((Layout)testInfoLayout);
        this.runLabel = this.createLabel("TP :", null, "0", testInfoComposite);
        this.fpLabel = this.createLabel("FP :", this.fErrorIcon, "0", testInfoComposite);
        this.fnLabel = this.createLabel("FN :", this.fFailureIcon, "0", testInfoComposite);
        this.fMLabel = this.createLabel("F1 :", null, "0", testInfoComposite);
    }

    public void dispose() {
        this.fErrorIcon.dispose();
        this.fFailureIcon.dispose();
        super.dispose();
    }

    private Text createLabel(String name, Image image, String init, Composite parent) {
        Label label = new Label(parent, 0);
        if (image != null) {
            image.setBackground(label.getBackground());
            label.setImage(image);
        }
        label.setLayoutData((Object)new GridData(32));
        label = new Label(parent, 0);
        label.setText(name);
        label.setLayoutData((Object)new GridData(32));
        Text value = new Text(parent, 8);
        value.setText(init);
        value.setLayoutData((Object)new GridData(800));
        return value;
    }

    public void setRuns(int x) {
        this.runLabel.setText(String.valueOf(x));
    }

    public void setFP(int x) {
        this.fpLabel.setText(String.valueOf(x));
    }

    public void setFN(int x) {
        this.fnLabel.setText(String.valueOf(x));
    }

    public void setFilename(String filename) {
        this.fileLabel.setText(filename);
    }

    public void setFMeasure(double f) {
        this.fMLabel.setText(String.valueOf(f));
    }

    public Combo getComboBox() {
        return this.comboBox;
    }

    public String getSelectedViewCasName() {
        return this.comboBox.getText();
    }

    public void addCASViewNamesToCombo(List<String> list) {
        for (String s : list) {
            this.comboBox.add(s);
        }
    }
}

