/* PM code in this file was stolen from Illya Vaes's code */

#ifdef __WIN32__
#  include "tkWinInt.h"
/* We keep a char here to emulate ToAscii later. Note that ToAscii
   is used before any WM_CHAR is recieved to init the map. We hope
   for the best here. */
HWND tmpParent;
#else
#  define __PM_WIN__
#  include "tkOS2Int.h"
static int ignoreEvents = 0;
#endif

#include <sys/builtin.h>
#include <sys/fmutex.h>

#define WM_SELECT_FINISHED (WM_USER+2)
#define MASK_SIZE sizeof(fd_set)/sizeof(fd_mask)	/* Hardcoded, do not want to
					   include unix.h */
/* #define DEBUG */

#define LOCK_(mt) if ((rc = _fmutex_request(&(mt),0))) 		     \
		sprintf(buff, "l.%d,_fmutex_request(%#lx,%d): %#x\n",__LINE__,(mt).hev,(int)(mt).fs,rc), \
		putbuff(), exit(1)
#define UNLOCK_(mt)    if ((rc = _fmutex_release(&(mt))))		     \
		sprintf(buff, "l.%d,_fmutex_release(%#lx,%d): %#x\n",__LINE__,(mt).hev,(int)(mt).fs,rc), \
		putbuff(), exit(1)
#define LOCK_FDS	LOCK_(mt_answer)
#define UNLOCK_FDS	UNLOCK_(mt_answer)

#define LOCK_DELIVER	LOCK_(mt_deliver)
#define UNLOCK_DELIVER	UNLOCK_(mt_deliver)

extern char StashedKey;
char StashedKey = 0;	/* fake for PM */

static int pipes[2] = {0, 0};

#if 0
static _fmutex mt;
#endif 

static _fmutex mt_answer = {0};
static _fmutex mt_deliver = {0};

static fd_mask checkMasks[3*MASK_SIZE] = {0};
				/* This array contains masks which
				   initiated the current code to select. */
static fd_mask readyMasks[3*MASK_SIZE] = {0};
				/* This array contains actual masks which
				   select() is using. */
static fd_mask answerMasks[3*MASK_SIZE] = {0};
				/* This array contains the results of last
				   select(). */
static fd_mask questionMasks[3*MASK_SIZE] = {0};
				/* This array contains the querys of last
				   select(). */
static int numFdBits = 0;		/* Number of valid bits in checkMasks
				 * (one more than highest fd for which
				 * Tcl_WatchFile has been called). */
static int selecter_tid = 0;
static int selecter_n = 0;

static char buff[1024];

static void
putbuff(void)
{
    write(2,buff,strlen(buff));
}

static void
selecter(void *arg)
{
    char c;
    int numFound, event;
    unsigned int rc;

    while (1) {
	/* Wait indefinitely: */
	LOCK_FDS;
	memcpy((VOID *) questionMasks, (VOID *) readyMasks,
	       3*MASK_SIZE*sizeof(fd_mask));
	UNLOCK_FDS;

#ifdef DEBUG
	sprintf(buff, "doing select(%d,%#lx,%#lx,%#lx,NULL)...\n",
			numFdBits, questionMasks[0], questionMasks[1], questionMasks[2]),putbuff();
#endif 

	numFound = select(numFdBits, (SELECT_MASK *) &questionMasks[0],
	    (SELECT_MASK *) &questionMasks[MASK_SIZE],
	    (SELECT_MASK *) &questionMasks[2*MASK_SIZE], NULL);
	
#ifdef DEBUG
	sprintf(buff, "select gave (%d,%#lx,%#lx,%#lx)...\n",
			numFound, questionMasks[0], questionMasks[1], questionMasks[2]),putbuff();
#endif 

	if (FD_ISSET(pipes[0], (SELECT_MASK *) &questionMasks[0])) {
#ifdef DEBUG
	    sprintf(buff, "select needs update...\n"),putbuff();
#endif 
	    /* Need to renew the masks */
	    FD_CLR(pipes[0], (SELECT_MASK *) &questionMasks[0]);
	    numFound--;
	    /* Update the position */
	    if (read(pipes[0], &c, 1) != 1)
		perror("selecter,read: "), exit(1);
#if 0
	    if ((rc = _fmutex_release(&mt)))
		sprintf(buff, "selecter,_fmutex_release: %#x\n",rc),putbuff(), exit(1);
#endif 
	    /* The caller does not want us to inform on old fds, let
	       us hope that the next select() will not lose the info: */
	    continue;
	} 
	if (!numFound)
	    continue;		/* Does not worth informing, the
				   default value is good enough.  */
	/* Now inform the message loop that something happened: */
	LOCK_FDS;
	memcpy((VOID *) answerMasks, (VOID *) questionMasks,
	       3*MASK_SIZE*sizeof(fd_mask));
	UNLOCK_FDS;
#ifdef __WIN32__
	????
#else
	if (!WinPostQueueMsg(hmq, WM_SELECT_FINISHED, 0, 0)) {
	    perror("selecter,WinPostQueueMsg: "), exit(1);
	}
#endif 
	LOCK_DELIVER;			/* No sense to repeat select
					   until the result may be used. */
    }    
}

static int
start_selecter(void)
{
    int res;
    unsigned int rc;
    
    if ((rc = _fmutex_create(&mt_answer, 0)))
	sprintf(buff, "selecter_answer,_fmutex_create: %#x\n",rc),putbuff(), exit(1);
#if 0
    if ((rc = _fmutex_create(&mt, 0)))
	sprintf(buff, "selecter,_fmutex_create: %#x\n",rc),putbuff(), exit(1);
    if ((rc = _fmutex_request(&mt,0)))
	sprintf(buff, "selecter,_fmutex_request0: %#x\n",rc),putbuff(), exit(1);
#endif 
    if ((rc = _fmutex_create(&mt_deliver, 0)))
	sprintf(buff, "selecter,_fmutex_create: %#x\n",rc),putbuff(), exit(1);
    LOCK_DELIVER;			/* Nothing delivered so far. */
    if ((res = _beginthread(&selecter, NULL, 32000, NULL)) == -1)
	perror("selecter,_beginthread: "), exit(1);
#ifdef DEBUG
    sprintf(buff, "started thread %d.\n", res),putbuff();
#endif 
    return res;
}

static void
pre_start_selecter(void)
{
    int res;
    unsigned int rc;
    
    if (pipe(pipes))
	perror("selecter,pipe: "), exit(1);
}

static void
inform_selecter(void)
{
    unsigned int rc;
#ifdef DEBUG
    sprintf(buff, "informing... pipe=%d\n",pipes[1]),putbuff();
#endif 
    if (write(pipes[1], ".", 1) != 1)
	perror("selecter,write: "), exit(1);
#if 0
    if ((rc = _fmutex_request(&mt,0)))
	sprintf(buff, "selecter,_fmutex_request: %#x\n",rc),putbuff(), exit(1);
#endif
}

/*
 *----------------------------------------------------------------------
 *
 * OS2Tcl_WaitForEvent --
 *
 *	This procedure does the lowest level wait for events in a
 *	platform-specific manner.  It uses information provided by
 *	previous calls to Tcl_WatchFile, plus the timePtr argument,
 *	to determine what to wait for and how long to wait.
 *
 * Results:
 *	None.
 *
 * Side effects:
 *	May put the process to sleep for a while, depending on timePtr.
 *	When this procedure returns, an event of interest to the application
 *	has probably, but not necessarily, occurred.
 *
 *----------------------------------------------------------------------
 */

int
OS2Tcl_WaitForEvent(n, maskPtr, timePtr)
    int n;
    long *maskPtr;		/* file part, not used so far. */
    Tcl_Time *timePtr;		/* Specifies the maximum amount of time
				 * that this procedure should block before
				 * returning.  The time is given as an
				 * interval, not an absolute wakeup time.
				 * NULL means block forever. */
{
#ifdef __WIN32__
    MSG msg;
#else
    QMSG msg;
#endif
    int foundEvent = 1;
    unsigned int rc;

    /*
     * If we are ignoring events from the system, just return immediately.
     */
#ifndef __WIN32__
    if (ignoreEvents) {
	return 0;
    }
#endif
    /* Update select() masks if required */
    if (n || numFdBits) {
	/* Check whether we need to stop the running select(), or
	   start selecter. */
	if (n != selecter_n 
	    || memcmp((VOID *) checkMasks, (VOID *) maskPtr, 
		      3*MASK_SIZE*sizeof(fd_mask))
	    || !selecter_tid) {

	    memcpy((VOID *) checkMasks, (VOID *) maskPtr,
		   3*MASK_SIZE*sizeof(fd_mask)); /* Not modified */
	    if (!selecter_tid)
		pre_start_selecter();	/* Need to know the pipe number
					   before starting it. */
	    if (selecter_tid) {
		LOCK_FDS;
	    }
	    memcpy((VOID *) readyMasks, (VOID *) maskPtr,
		   3*MASK_SIZE*sizeof(fd_mask));
	    FD_SET(pipes[0], (SELECT_MASK *) &readyMasks[0]);
	    numFdBits = (pipes[0] + 1) > n ? (pipes[0] + 1) : n ;
	    if (selecter_tid) {
		UNLOCK_FDS;
	    }
	    selecter_n = n;
#ifdef DEBUG
	    sprintf(buff, "need  select(%d,%#lx,%#lx,%#lx,NULL) pipe=%d...\n",
		    n, checkMasks[0], checkMasks[1],
		    checkMasks[2], pipes[0]),putbuff();
#endif 
	    /* Start the fileevent thread if needed: */
	    if (!selecter_tid) {
#ifdef DEBUG
		sprintf(buff, "starting...\n"),putbuff();
#endif 
		selecter_tid = start_selecter();
	    } else
		inform_selecter();	/* Now the old select() is stopped. */
	}
    }

    /* Mark as not ready: */
    memset((VOID *) maskPtr, 0, 3*MASK_SIZE*sizeof(fd_mask));

    /*
     * Set up the asynchronous select handlers for any sockets we
     * are watching.
     */

    /* TclWinNotifySocket(); */

    /*
     * Look for an event, setting a timer so we don't block forever.
     */

    if (timePtr != NULL) {
	UINT ms;
	ms = timePtr->sec * 1000;
	ms += timePtr->usec / 1000;

	if (ms > 0) {
#ifdef __WIN32__
	    UINT timerHandle = SetTimer(tmpParent, 0, ms, NULL);
	    GetMessage(&msg, NULL, 0, 0);
	    KillTimer(tmpParent, timerHandle);
#else
	    ULONG timerHandle = WinStartTimer(hab, NULLHANDLE, 1, ms);
	    WinGetMsg(hab, &msg, NULLHANDLE, 0, 0);
	    WinStopTimer(hab, NULLHANDLE, timerHandle);
#endif
	} else {

	    /*
	     * If the timeout is too small, we just poll.
	     */

#ifdef __WIN32__
	    foundEvent = PeekMessage(&msg, NULL, 0, 0, PM_REMOVE);
#else
	    foundEvent = WinPeekMsg(hab, &msg, NULLHANDLE, 0, 0, PM_REMOVE);
#endif
	}
    } else {
#ifdef __WIN32__
	GetMessage(&msg, NULL, 0, 0);
#else
	WinGetMsg(hab, &msg, NULLHANDLE, 0, 0);
#endif
    }

    /*
     * Dispatch the message, if we found one.  If we are exiting, be
     * sure to inform Tcl so we can clean up properly.
     */

    if (foundEvent) {
	int type;
	
#ifdef __WIN32__
	type = msg.message;
#else
	type = msg.msg;
#endif
	if (type == WM_QUIT)
	    Tcl_Exit(0);
	else if (type == WM_SELECT_FINISHED) {
	    /* Now answerMask contains valid values of masks some time
	       ago.  */
#ifdef DEBUG
	    sprintf(buff, "message gave (%#lx,%#lx,%#lx)...\n",
			answerMasks[0], answerMasks[1], answerMasks[2]),putbuff();
#endif 
	    LOCK_FDS;
	    memcpy((VOID *) maskPtr, (VOID *) answerMasks,
		   3*MASK_SIZE*sizeof(fd_mask));
	    UNLOCK_FDS;
	    UNLOCK_DELIVER;		/* Let it select() again. */
	}
#ifdef __WIN32__
	TranslateMessage(&msg);
	DispatchMessage(&msg);
#else
	WinDispatchMsg(hab, &msg);
#endif
    }
    return 1;
}

/* Here we put some stubs for functions called from TKGEN. */

#undef XFlush
#undef XFree
#undef XGrabServer
#undef XNoOp
#undef XUngrabServer
#undef XSynchronize
#undef XSync
#undef XVisualIDFromVisual

#ifndef SvREFCNT

void XFlush(Display *display) {}
void XFree(void *data) {if ((data) != NULL) ckfree((char *) (data));}
void XGrabServer(Display *display) {}
void XNoOp(Display *display) {display->request++;}
void XUngrabServer(Display *display) {}
int (*XSynchronize(Display *display, int i))() {display->request++; return NULL;}
void XSync(Display *display, int i) {display->request++;}
VisualID XVisualIDFromVisual(Visual *visual) {return visual->visualid;}

#endif

#ifdef __WIN32__

#undef ReleaseDC
#undef GetDC

#ifdef 0 /* Paints black on black? */

static HWND hwndDesktop;

int        
MyReleaseDC( HWND h, HDC dc)
{ 
  if (h) return ReleaseDC(h,dc);
  return ReleaseDC(hwndDesktop,dc);
}


HDC        
MyGetDC( HWND h)
{ 
  static HDC dc;

  if (h) return GetDC(h);
  if (!hwndDesktop) hwndDesktop = GetDesktopWindow();
  return GetDC(hwndDesktop);
}

#else /* ! 0 */

int        
MyReleaseDC( HWND h, HDC dc)
{ 
  if (h) return ReleaseDC(h,dc);
  return 0;
}


HDC        
MyGetDC( HWND h)
{ 
  static HDC dc;

  if (h) return GetDC(h);
  if (!dc) dc = GetDC(h);
  return dc;
}


#endif /* !0 */

/* Cursor stuff */

#include <rc/cursors.h>

HCURSOR
os2LoadCursor(module, name)
    HMODULE module;
    char*   name;
{
    myCursor *curPtr = cursors;
    while (curPtr->name) {
	if (strcmp(curPtr->name, name) == 0) {
	    break;
	}
	curPtr++;
    }
    if (curPtr->name) {
	return LoadCursor(module, curPtr->id);
    } else {
	return NULL;
    }
}

HICON
os2LoadIcon(module, name)
    HMODULE module;
    char*   name;
{
    myCursor *curPtr = cursors;
    while (curPtr->name) {
	if (strcmp(curPtr->name, name) == 0) {
	    break;
	}
	curPtr++;
    }
    if (curPtr->name) {
	return LoadIcon(module, curPtr->id);
    } else {
	return NULL;
    }
}

#else /* !__WIN32__ */

/*
 *----------------------------------------------------------------------
 *
 * TclOS2FlushEvents --
 *
 *	This function is a special purpose hack to allow Tk to
 *	process queued Window events during a recursive event loop
 *	without looking for new events on the system event queue.
 *
 * Results:
 *	None.
 *
 * Side effects:
 *	Services any pending Tcl events and calls idle handlers.
 *
 *----------------------------------------------------------------------
 */

void
TclOS2FlushEvents()
{
    ignoreEvents = 1;
    while (Tcl_DoOneEvent(TCL_DONT_WAIT|TCL_WINDOW_EVENTS|TCL_IDLE_EVENTS)) {
    }
    ignoreEvents = 0;
}


HBITMAP
CreateBitmap(int width, int height, int unknown, int depth, void* unknown1)
{
	HPS memPS;
	BITMAPINFOHEADER2 bmpInfo;
	HBITMAP bitmap;

#ifdef DEBUG
printf("XCopyPlane case3\n");
#endif

	if (unknown != 1 || unknown1 != NULL)
	    panic("Unknown parameters to OS2CreateBitmap");

	memPS = WinGetScreenPS(HWND_DESKTOP);
	bmpInfo.cbFix = sizeof(BITMAPINFOHEADER2);
	bmpInfo.cx = width;
	bmpInfo.cy = height;
	bmpInfo.cPlanes = 1;
	bmpInfo.cBitCount = depth;
	bitmap = GpiCreateBitmap(memPS, &bmpInfo, 0L, NULL, NULL);
#ifdef DEBUG
printf("    GpiCreateBitmap (%d,%d) returned %x\n", width, height, bitmap);
#endif
/*
*/
	return bitmap;
}

/* A copy from tixpWinXpm.c */
#include "tix.h"
#include "tixImgXpm.h"

typedef struct PixmapData {
    HDC bitmapDC;               /* Bitmap used on Windows platforms */
    HDC maskDC;                 /* Mask used on Windows platforms */
    HBITMAP bitmap, bitmapOld;
    HBITMAP maskBm, maskBmOld;
} PixmapData;

static void		CopyTransparent _ANSI_ARGS_((Display* display,
			    HDC srcDC, Drawable dest,
			    int src_x, int src_y, int width,
			    int height, int dest_x, int dest_y,
			    HDC maskDC));


/*----------------------------------------------------------------------
 * TixpXpmRealizePixmap --
 *
 *	On Unix: 	Create the pixmap from the buffer.
 *	On Windows:	Free the mask if there are no transparent pixels.
 *----------------------------------------------------------------------
 */
void
TixpXpmRealizePixmap(masterPtr, instancePtr, image, mask, isTransp)
    PixmapMaster * masterPtr;
    PixmapInstance * instancePtr;
    XImage * image;
    XImage * mask;
{
    Display *display = Tk_Display(instancePtr->tkwin);
    PixmapData *dataPtr = (PixmapData*)instancePtr->clientData;
    HPS hps, bitmapPS;
    HDC dc, dc1;
    TkOS2PSState psState;
    HBITMAP bitmap, bitmapOld;
    int w, h;
    BITMAPINFOHEADER2_2colors bmpInfo;
    PBITMAPINFOHEADER2 pbmpInfo = &(bmpInfo.header);
    SIZEL sizl = {0,0}; /* use same page size as device */
    POINTL aPoints[3]; /* Lower-left, upper-right, lower-left source */
    DEVOPENSTRUC dop = {0L, (PSZ)"DISPLAY", NULL, 0L, 0L, 0L, 0L, 0L, 0L};

    w = masterPtr->size[0];
    h = masterPtr->size[1];

    hps = TkOS2GetDrawablePS(display, instancePtr->pixmap, &psState);
    dc = DevOpenDC(hab, OD_MEMORY, (PSZ)"*", 5L, (PDEVOPENDATA)&dop,
		   ((TkOS2Drawable *)instancePtr->pixmap)->bitmap.dc);
    if (dc == DEV_ERROR) {
	printf("DevOpenDC ERROR\n");
    } else {
	printf("DevOpenDC(?) = %x\n", (unsigned int)dc);
    }
    bitmapPS = GpiCreatePS(hab, dc, &sizl, PU_PELS | GPIT_NORMAL | GPIA_ASSOC);
    if (bitmapPS == GPI_ERROR) {
	printf("GpiCreatePS(%x, %x, {0,0}, ?) GPI_ERROR: %x\n",
	       (unsigned int)hab, (unsigned int)dc, (unsigned int)WinGetLastError(hab));
    } else {
	printf("GpiCreatePS(?) = %x\n", (unsigned int)bitmapPS);	    
    }

    pbmpInfo->cbFix = 16L;
    pbmpInfo->cx = w;
    pbmpInfo->cy = h;
    pbmpInfo->cPlanes = 1;
    pbmpInfo->cBitCount = 1;
    bitmap = GpiCreateBitmap(bitmapPS, pbmpInfo, 0L, NULL, NULL);
    if (bitmap == GPI_ERROR) {
	printf("GpiCreateBitmap(%x, %x, {?,?}, 0,0,0) GPI_ERROR: %x\n",
	       (unsigned int)hab, (unsigned int)bitmapPS, (unsigned int)WinGetLastError(hab));
    }
    bitmapOld = GpiSetBitmap(bitmapPS, bitmap);
    
    aPoints[0].x = 0; /* dest_ll = 0 */
    aPoints[0].y = 0;
    aPoints[1].x = w; /* other corner: ur */
    aPoints[1].y = h;
    aPoints[2].x = 0; /* source ll */
    aPoints[2].y = 0;
    GpiBitBlt(bitmapPS, hps, 3, aPoints, ROP_SRCCOPY, BBO_IGNORE);

    if (isTransp) {
	HPS maskPS;
	HBITMAP maskBm, maskBmOld;
	BITMAPINFOHEADER2 bmpInfo2;	/* Description of mask->data. */

	/*
	 * There are transparent pixels. We need a mask.
	 */
	dc1 = DevOpenDC(hab, OD_MEMORY, (PSZ)"*", 5L, (PDEVOPENDATA)&dop,
		       ((TkOS2Drawable *)instancePtr->pixmap)->bitmap.dc);
	if (dc1 == DEV_ERROR) {
	    printf("DevOpenDC ERROR\n");
	    return;
	} else {
	    printf("DevOpenDC(?) = %x\n", (unsigned int)dc1);	    
	}
	maskPS = GpiCreatePS(hab, dc1, &sizl, PU_PELS | GPIT_NORMAL | GPIA_ASSOC);
	if (maskPS == GPI_ERROR) {
	    printf("GpiCreatePS(%x, %x, {0,0}, ?) GPI_ERROR: %x\n",
		   (unsigned int)hab, (unsigned int)dc1, (unsigned int)WinGetLastError(hab));
	} else {
	    printf("GpiCreatePS(?) = %x\n", (unsigned int)maskPS);	    
	}
	bmpInfo.colors[0].bBlue = bmpInfo.colors[0].bGreen =
	    bmpInfo.colors[0].bRed = 0;
	bmpInfo.colors[1].bBlue = bmpInfo.colors[1].bGreen =
	    bmpInfo.colors[1].bRed = 255;
	
	maskBm = GpiCreateBitmap(bitmapPS, pbmpInfo, CBM_INIT, mask->data, (PBITMAPINFO2)pbmpInfo);
	if (maskBm == GPI_ERROR) {
	    printf("GpiCreateBitmap(%x, %x, {?,?}, CBM_INIT,?,?) GPI_ERROR: %x\n",
		   (unsigned int)hab, (unsigned int)bitmapPS, (unsigned int)WinGetLastError(hab));
	}
	maskBmOld = GpiSetBitmap(maskPS, maskBm);

	GpiBitBlt(bitmapPS, maskPS, 3, aPoints, ROP_SRCCOPY, BBO_IGNORE);
	GpiBitBlt(maskPS, maskPS, 3, aPoints, ROP_NOTSRCCOPY, BBO_IGNORE);

	TkOS2ReleaseDrawablePS(instancePtr->pixmap, hps, &psState);
	dataPtr->maskDC = maskPS;
	dataPtr->maskBm = maskBm;
	dataPtr->maskBmOld = maskBmOld;
    } else {
	dataPtr->maskDC = 0;
    }
    dataPtr->bitmapDC = bitmapPS;
    dataPtr->bitmap = bitmap;
    dataPtr->bitmapOld = bitmapOld;
}

void
TixpXpmFreeInstanceData(instancePtr, delete, display)
    PixmapInstance *instancePtr;	/* Pixmap instance. */
    int delete;				/* Should the instance data structure
					 * be deleted as well? */
    Display *display;
{
    PixmapData *dataPtr = (PixmapData*)instancePtr->clientData;    
    HDC dc, dc1;

    if (dataPtr->maskDC != 0) {
	GpiDeleteBitmap(GpiSetBitmap(dataPtr->maskDC,
				     dataPtr->maskBmOld));
	dc = GpiQueryDevice(dataPtr->maskDC);
	if (dc == HDC_ERROR) {
	    printf("GpiQueryDevice(%x) ERROR = %x\n", (unsigned int)dataPtr->maskDC,
		   (unsigned int)WinGetLastError(hab));
	} else {
	    printf("GpiQueryDevice(%x) = %x\n", (unsigned int)dataPtr->maskDC, (unsigned int)dc);
	}
	if (!GpiSetBitmap(dataPtr->maskDC, 0)) {
	    printf("GpiSetBitmap(%x,0) ERROR = %x\n", (unsigned int)dataPtr->maskDC, (unsigned int)WinGetLastError(hab));	    
	}
	WinReleasePS(dataPtr->maskDC);
	if (!WinReleasePS(dataPtr->maskDC)) {
	    printf("WinReleasePS(%x) ERROR = %x\n", (unsigned int)dataPtr->maskDC, (unsigned int)WinGetLastError(hab));
	}
	dc1 = DevCloseDC(dc);
	if (dc1 == DEV_ERROR) {
	    printf("DevCloseDC(%x) ERROR = %x\n", (unsigned int)dc, (unsigned int)WinGetLastError(hab));
	}
	dataPtr->maskDC = 0;
    }
    if (dataPtr->bitmapDC != 0) {
	GpiDeleteBitmap(GpiSetBitmap(dataPtr->bitmapDC,
				     dataPtr->bitmapOld));
	dc = GpiQueryDevice(dataPtr->bitmapDC);
	if (dc == HDC_ERROR) {
	    printf("GpiQueryDevice(%x) ERROR = %x\n", (unsigned int)dataPtr->bitmapDC, (unsigned int)WinGetLastError(hab));
	} else {
	    printf("GpiQueryDevice(%x) = %x\n", (unsigned int)dataPtr->bitmapDC, (unsigned int)dc);	    
	}
	if (!GpiSetBitmap(dataPtr->bitmapDC, 0)) {
	    printf("GpiSetBitmap(%x,0) ERROR = %x\n", (unsigned int)dataPtr->bitmapDC, (unsigned int)WinGetLastError(hab));	    
	}
	if (!WinReleasePS(dataPtr->bitmapDC)) {
	    printf("WinReleasePS(%x) ERROR = %x\n", (unsigned int)dataPtr->bitmapDC, (unsigned int)WinGetLastError(hab));
	}
	dc1 = DevCloseDC(dc);
	if (dc1 == DEV_ERROR) {
	    printf("DevCloseDC(%x) ERROR = %x\n", (unsigned int)dc, (unsigned int)WinGetLastError(hab));
	}
	dataPtr->bitmapDC = 0;
    }
    if (delete) {
	ckfree((char*)dataPtr);
	instancePtr->clientData = NULL;
    }
}

void
TixpXpmDisplay(clientData, display, drawable, imageX, imageY, width,
	height, drawableX, drawableY)
    ClientData clientData;	/* Pointer to PixmapInstance structure for
				 * for instance to be displayed. */
    Display *display;		/* Display on which to draw image. */
    Drawable drawable;		/* Pixmap or window in which to draw image. */
    int imageX, imageY;		/* Upper-left corner of region within image
				 * to draw. */
    int width, height;		/* Dimensions of region within image to draw.*/
    int drawableX, drawableY;	/* Coordinates within drawable that
				 * correspond to imageX and imageY. */
{
    PixmapInstance *instancePtr = (PixmapInstance *) clientData;
    PixmapData *dataPtr = (PixmapData*)instancePtr->clientData;

    CopyTransparent(display, dataPtr->bitmapDC, drawable,
	imageX, imageY, width, height,
	drawableX, drawableY, dataPtr->maskDC);
}

/*----------------------------------------------------------------------
 * TixpDrawAnchorLines --
 *
 *	See comments near Tix_DrawAnchorLines.
 *----------------------------------------------------------------------
 */
					/* Stolen from tixUnix */
void TixpDrawAnchorLines(display, drawable, gc, x, y, w, h)
    Display *display;
    Drawable drawable;
    GC gc;
    int x;
    int y;
    int w;
    int h;
{
    XPoint points[4];

    if (w < 1) {
	w = 1;
    }
    if (h < 1) {
	h = 1;
    }

    XDrawRectangle(display, drawable, gc, x, y, w-1, h-1);
#if 0
    /*
     * Draw these points so that the corners will not be rounded
     */
    points[0].x = x;
    points[0].y = y;
    points[1].x = x + w - 1;
    points[1].y = y;
    points[2].x = x;
    points[2].y = y + h - 1;
    points[3].x = x + w - 1;
    points[3].y = y + h - 1;

    XDrawPoints(display, drawable, gc, points, 4, CoordModeOrigin);
#endif 
}

static void
CopyTransparent(display, srcDC, dest, src_x, src_y, width, height, dest_x,
        dest_y,	maskDC)
    Display* display;
    HPS srcDC;
    Drawable dest;
    int src_x;
    int src_y;
    int width;
    int height;
    int dest_x;
    int dest_y;
    HPS maskDC;
{
    HPS destPS;
    TkOS2PSState destState;
    POINTL aPoints[4]; /* Lower-left, upper-right, lower-left source */

    destPS = TkOS2GetDrawablePS(display, dest, &destState);
    /* Make this upside-down: */
    aPoints[0].x = 0;			/* dest_ll = 0 */
    aPoints[0].y = height - 1;
    aPoints[1].x = width;		/* other corner: ur */
    aPoints[1].y = -1;
    aPoints[2].x = 0;			/* source ll */
    aPoints[2].y = 0;
    aPoints[3].x = width;		/* source ll */
    aPoints[3].y = height;
    if (maskDC) {
	GpiBitBlt(destPS, maskDC, 4, aPoints, ROP_SRCAND, BBO_IGNORE);
	GpiBitBlt(destPS, srcDC, 4, aPoints, ROP_SRCPAINT, BBO_IGNORE);
    } else {
	GpiBitBlt(destPS, srcDC, 4, aPoints, ROP_SRCCOPY, BBO_IGNORE);
    }
    TkOS2ReleaseDrawablePS(dest, destPS, &destState);
}


#endif /* ! __Win32__ */
