// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"go.opentelemetry.io/collector/pdata/internal/json"
)

type Int32Slice struct {
	orig  *[]int32
	state *State
}

func GetOrigInt32Slice(ms Int32Slice) *[]int32 {
	return ms.orig
}

func GetInt32SliceState(ms Int32Slice) *State {
	return ms.state
}

func NewInt32Slice(orig *[]int32, state *State) Int32Slice {
	return Int32Slice{orig: orig, state: state}
}

func CopyOrigInt32Slice(dst, src []int32) []int32 {
	dst = dst[:0]
	return append(dst, src...)
}

func FillTestInt32Slice(ms Int32Slice) {
	*ms.orig = []int32{1, 2, 3}
}

func GenerateTestInt32Slice() Int32Slice {
	orig := []int32(nil)
	state := StateMutable
	ms := NewInt32Slice(&orig, &state)
	FillTestInt32Slice(ms)
	return ms
}

// MarshalJSONStreamInt32Slice marshals all properties from the current struct to the destination stream.
func MarshalJSONStreamInt32Slice(ms Int32Slice, dest *json.Stream) {
	dest.WriteArrayStart()
	if len(*ms.orig) > 0 {
		dest.WriteInt32((*ms.orig)[0])
	}
	for i := 1; i < len((*ms.orig)); i++ {
		dest.WriteMore()
		dest.WriteInt32((*ms.orig)[i])
	}
	dest.WriteArrayEnd()
}

// UnmarshalJSONIterInt32Slice unmarshals all properties from the current struct from the source iterator.
func UnmarshalJSONIterInt32Slice(ms Int32Slice, iter *json.Iterator) {
	iter.ReadArrayCB(func(iter *json.Iterator) bool {
		*ms.orig = append(*ms.orig, iter.ReadInt32())
		return true
	})
}
