// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"encoding/base64"

	"go.opentelemetry.io/collector/pdata/internal/json"
)

type ByteSlice struct {
	orig  *[]byte
	state *State
}

func GetOrigByteSlice(ms ByteSlice) *[]byte {
	return ms.orig
}

func GetByteSliceState(ms ByteSlice) *State {
	return ms.state
}

func NewByteSlice(orig *[]byte, state *State) ByteSlice {
	return ByteSlice{orig: orig, state: state}
}

func GenerateTestByteSlice() ByteSlice {
	orig := GenerateOrigTestByteSlice()
	state := StateMutable
	return NewByteSlice(&orig, &state)
}

func CopyOrigByteSlice(dst, src []byte) []byte {
	return append(dst[:0], src...)
}

func GenerateOrigTestByteSlice() []byte {
	return []byte{1, 2, 3}
}

// UnmarshalJSONOrigByteSlice unmarshals all properties from the current struct from the source iterator.
func UnmarshalJSONOrigByteSlice(iter *json.Iterator) []byte {
	buf := iter.ReadStringAsSlice()
	orig := make([]byte, base64.StdEncoding.DecodedLen(len(buf)))
	n, err := base64.StdEncoding.Decode(orig, buf)
	if err != nil {
		iter.ReportError("base64.Decode", err.Error())
	}
	orig = orig[:n]
	return orig
}
