// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	otlpmetrics "go.opentelemetry.io/collector/pdata/internal/data/protogen/metrics/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

func CopyOrigExponentialHistogram(dest, src *otlpmetrics.ExponentialHistogram) {
	dest.DataPoints = CopyOrigExponentialHistogramDataPointSlice(dest.DataPoints, src.DataPoints)
	dest.AggregationTemporality = src.AggregationTemporality
}

func FillOrigTestExponentialHistogram(orig *otlpmetrics.ExponentialHistogram) {
	orig.DataPoints = GenerateOrigTestExponentialHistogramDataPointSlice()
	orig.AggregationTemporality = otlpmetrics.AggregationTemporality(1)
}

// MarshalJSONOrig marshals all properties from the current struct to the destination stream.
func MarshalJSONOrigExponentialHistogram(orig *otlpmetrics.ExponentialHistogram, dest *json.Stream) {
	dest.WriteObjectStart()
	if len(orig.DataPoints) > 0 {
		dest.WriteObjectField("dataPoints")
		dest.WriteArrayStart()
		MarshalJSONOrigExponentialHistogramDataPoint(orig.DataPoints[0], dest)
		for i := 1; i < len(orig.DataPoints); i++ {
			dest.WriteMore()
			MarshalJSONOrigExponentialHistogramDataPoint(orig.DataPoints[i], dest)
		}
		dest.WriteArrayEnd()
	}

	if int32(orig.AggregationTemporality) != 0 {
		dest.WriteObjectField("aggregationTemporality")
		dest.WriteInt32(int32(orig.AggregationTemporality))
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSONOrigExponentialHistogram unmarshals all properties from the current struct from the source iterator.
func UnmarshalJSONOrigExponentialHistogram(orig *otlpmetrics.ExponentialHistogram, iter *json.Iterator) {
	iter.ReadObjectCB(func(iter *json.Iterator, f string) bool {
		switch f {
		case "dataPoints", "data_points":
			orig.DataPoints = UnmarshalJSONOrigExponentialHistogramDataPointSlice(iter)
		case "aggregationTemporality", "aggregation_temporality":
			orig.AggregationTemporality = otlpmetrics.AggregationTemporality(iter.ReadEnumValue(otlpmetrics.AggregationTemporality_value))
		default:
			iter.Skip()
		}
		return true
	})
}

func SizeProtoOrigExponentialHistogram(orig *otlpmetrics.ExponentialHistogram) int {
	var n int
	var l int
	_ = l
	for i := range orig.DataPoints {
		l = SizeProtoOrigExponentialHistogramDataPoint(orig.DataPoints[i])
		n += 1 + proto.Sov(uint64(l)) + l
	}
	if orig.AggregationTemporality != 0 {
		n += 1 + proto.Sov(uint64(orig.AggregationTemporality))
	}
	return n
}

func MarshalProtoOrigExponentialHistogram(orig *otlpmetrics.ExponentialHistogram, buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	for i := range orig.DataPoints {
		l = MarshalProtoOrigExponentialHistogramDataPoint(orig.DataPoints[i], buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0xa
	}
	if orig.AggregationTemporality != 0 {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.AggregationTemporality))
		pos--
		buf[pos] = 0x10
	}
	return len(buf) - pos
}

func UnmarshalProtoOrigExponentialHistogram(orig *otlpmetrics.ExponentialHistogram, buf []byte) error {
	return orig.Unmarshal(buf)
}
