// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"

	otlpprofiles "go.opentelemetry.io/collector/pdata/internal/data/protogen/profiles/v1development"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyOrigFunction(t *testing.T) {
	src := &otlpprofiles.Function{}
	dest := &otlpprofiles.Function{}
	CopyOrigFunction(dest, src)
	assert.Equal(t, &otlpprofiles.Function{}, dest)
	FillOrigTestFunction(src)
	CopyOrigFunction(dest, src)
	assert.Equal(t, src, dest)
}

func TestMarshalAndUnmarshalJSONOrigFunctionUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := &otlpprofiles.Function{}
	UnmarshalJSONOrigFunction(dest, iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, &otlpprofiles.Function{}, dest)
}

func TestMarshalAndUnmarshalJSONOrigFunction(t *testing.T) {
	for name, src := range getEncodingTestValuesFunction() {
		t.Run(name, func(t *testing.T) {
			stream := json.BorrowStream(nil)
			defer json.ReturnStream(stream)
			MarshalJSONOrigFunction(src, stream)
			require.NoError(t, stream.Error())

			iter := json.BorrowIterator(stream.Buffer())
			defer json.ReturnIterator(iter)
			dest := &otlpprofiles.Function{}
			UnmarshalJSONOrigFunction(dest, iter)
			require.NoError(t, iter.Error())

			assert.Equal(t, src, dest)
		})
	}
}

func TestMarshalAndUnmarshalProtoOrigFunction(t *testing.T) {
	for name, src := range getEncodingTestValuesFunction() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, SizeProtoOrigFunction(src))
			gotSize := MarshalProtoOrigFunction(src, buf)
			assert.Equal(t, len(buf), gotSize)

			dest := &otlpprofiles.Function{}
			require.NoError(t, UnmarshalProtoOrigFunction(dest, buf))
			assert.Equal(t, src, dest)
		})
	}
}

func getEncodingTestValuesFunction() map[string]*otlpprofiles.Function {
	return map[string]*otlpprofiles.Function{
		"empty": {},
		"fill_test": func() *otlpprofiles.Function {
			src := &otlpprofiles.Function{}
			FillOrigTestFunction(src)
			return src
		}(),
	}
}
