// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"encoding/binary"

	"go.opentelemetry.io/collector/pdata/internal/data"
	otlplogs "go.opentelemetry.io/collector/pdata/internal/data/protogen/logs/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

func CopyOrigLogRecord(dest, src *otlplogs.LogRecord) {
	dest.TimeUnixNano = src.TimeUnixNano
	dest.ObservedTimeUnixNano = src.ObservedTimeUnixNano
	dest.SeverityNumber = src.SeverityNumber
	dest.SeverityText = src.SeverityText
	CopyOrigAnyValue(&dest.Body, &src.Body)
	dest.Attributes = CopyOrigKeyValueSlice(dest.Attributes, src.Attributes)
	dest.DroppedAttributesCount = src.DroppedAttributesCount
	dest.Flags = src.Flags
	dest.TraceId = src.TraceId
	dest.SpanId = src.SpanId
	dest.EventName = src.EventName
}

func FillOrigTestLogRecord(orig *otlplogs.LogRecord) {
	orig.TimeUnixNano = 1234567890
	orig.ObservedTimeUnixNano = 1234567890
	orig.SeverityNumber = otlplogs.SeverityNumber(5)
	orig.SeverityText = "test_severitytext"
	FillOrigTestAnyValue(&orig.Body)
	orig.Attributes = GenerateOrigTestKeyValueSlice()
	orig.DroppedAttributesCount = uint32(13)
	orig.Flags = 1
	orig.TraceId = data.TraceID([16]byte{1, 2, 3, 4, 5, 6, 7, 8, 8, 7, 6, 5, 4, 3, 2, 1})
	orig.SpanId = data.SpanID([8]byte{8, 7, 6, 5, 4, 3, 2, 1})
	orig.EventName = "test_eventname"
}

// MarshalJSONOrig marshals all properties from the current struct to the destination stream.
func MarshalJSONOrigLogRecord(orig *otlplogs.LogRecord, dest *json.Stream) {
	dest.WriteObjectStart()
	if orig.TimeUnixNano != uint64(0) {
		dest.WriteObjectField("timeUnixNano")
		dest.WriteUint64(orig.TimeUnixNano)
	}
	if orig.ObservedTimeUnixNano != uint64(0) {
		dest.WriteObjectField("observedTimeUnixNano")
		dest.WriteUint64(orig.ObservedTimeUnixNano)
	}

	if int32(orig.SeverityNumber) != 0 {
		dest.WriteObjectField("severityNumber")
		dest.WriteInt32(int32(orig.SeverityNumber))
	}
	if orig.SeverityText != "" {
		dest.WriteObjectField("severityText")
		dest.WriteString(orig.SeverityText)
	}
	dest.WriteObjectField("body")
	MarshalJSONOrigAnyValue(&orig.Body, dest)
	if len(orig.Attributes) > 0 {
		dest.WriteObjectField("attributes")
		dest.WriteArrayStart()
		MarshalJSONOrigKeyValue(&orig.Attributes[0], dest)
		for i := 1; i < len(orig.Attributes); i++ {
			dest.WriteMore()
			MarshalJSONOrigKeyValue(&orig.Attributes[i], dest)
		}
		dest.WriteArrayEnd()
	}
	if orig.DroppedAttributesCount != uint32(0) {
		dest.WriteObjectField("droppedAttributesCount")
		dest.WriteUint32(orig.DroppedAttributesCount)
	}
	if orig.Flags != uint32(0) {
		dest.WriteObjectField("flags")
		dest.WriteUint32(orig.Flags)
	}
	if orig.TraceId != data.TraceID([16]byte{}) {
		dest.WriteObjectField("traceId")
		MarshalJSONOrigTraceID(&orig.TraceId, dest)
	}
	if orig.SpanId != data.SpanID([8]byte{}) {
		dest.WriteObjectField("spanId")
		MarshalJSONOrigSpanID(&orig.SpanId, dest)
	}
	if orig.EventName != "" {
		dest.WriteObjectField("eventName")
		dest.WriteString(orig.EventName)
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSONOrigLogRecord unmarshals all properties from the current struct from the source iterator.
func UnmarshalJSONOrigLogRecord(orig *otlplogs.LogRecord, iter *json.Iterator) {
	iter.ReadObjectCB(func(iter *json.Iterator, f string) bool {
		switch f {
		case "timeUnixNano", "time_unix_nano":
			orig.TimeUnixNano = iter.ReadUint64()
		case "observedTimeUnixNano", "observed_time_unix_nano":
			orig.ObservedTimeUnixNano = iter.ReadUint64()
		case "severityNumber", "severity_number":
			orig.SeverityNumber = otlplogs.SeverityNumber(iter.ReadEnumValue(otlplogs.SeverityNumber_value))
		case "severityText", "severity_text":
			orig.SeverityText = iter.ReadString()
		case "body":
			UnmarshalJSONOrigAnyValue(&orig.Body, iter)
		case "attributes":
			orig.Attributes = UnmarshalJSONOrigKeyValueSlice(iter)
		case "droppedAttributesCount", "dropped_attributes_count":
			orig.DroppedAttributesCount = iter.ReadUint32()
		case "flags":
			orig.Flags = iter.ReadUint32()
		case "traceId", "trace_id":
			orig.TraceId.UnmarshalJSONIter(iter)
		case "spanId", "span_id":
			orig.SpanId.UnmarshalJSONIter(iter)
		case "eventName", "event_name":
			orig.EventName = iter.ReadString()
		default:
			iter.Skip()
		}
		return true
	})
}

func SizeProtoOrigLogRecord(orig *otlplogs.LogRecord) int {
	var n int
	var l int
	_ = l
	if orig.TimeUnixNano != 0 {
		n += 9
	}
	if orig.ObservedTimeUnixNano != 0 {
		n += 9
	}
	if orig.SeverityNumber != 0 {
		n += 1 + proto.Sov(uint64(orig.SeverityNumber))
	}
	l = len(orig.SeverityText)
	if l > 0 {
		n += 1 + proto.Sov(uint64(l)) + l
	}
	l = SizeProtoOrigAnyValue(&orig.Body)
	n += 1 + proto.Sov(uint64(l)) + l
	for i := range orig.Attributes {
		l = SizeProtoOrigKeyValue(&orig.Attributes[i])
		n += 1 + proto.Sov(uint64(l)) + l
	}
	if orig.DroppedAttributesCount != 0 {
		n += 1 + proto.Sov(uint64(orig.DroppedAttributesCount))
	}
	if orig.Flags != 0 {
		n += 5
	}
	l = SizeProtoOrigTraceID(&orig.TraceId)
	n += 1 + proto.Sov(uint64(l)) + l
	l = SizeProtoOrigSpanID(&orig.SpanId)
	n += 1 + proto.Sov(uint64(l)) + l
	l = len(orig.EventName)
	if l > 0 {
		n += 1 + proto.Sov(uint64(l)) + l
	}
	return n
}

func MarshalProtoOrigLogRecord(orig *otlplogs.LogRecord, buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	if orig.TimeUnixNano != 0 {
		pos -= 8
		binary.LittleEndian.PutUint64(buf[pos:], uint64(orig.TimeUnixNano))
		pos--
		buf[pos] = 0x9
	}
	if orig.ObservedTimeUnixNano != 0 {
		pos -= 8
		binary.LittleEndian.PutUint64(buf[pos:], uint64(orig.ObservedTimeUnixNano))
		pos--
		buf[pos] = 0x59
	}
	if orig.SeverityNumber != 0 {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.SeverityNumber))
		pos--
		buf[pos] = 0x10
	}
	l = len(orig.SeverityText)
	if l > 0 {
		pos -= l
		copy(buf[pos:], orig.SeverityText)
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x1a
	}

	l = MarshalProtoOrigAnyValue(&orig.Body, buf[:pos])
	pos -= l
	pos = proto.EncodeVarint(buf, pos, uint64(l))
	pos--
	buf[pos] = 0x2a

	for i := range orig.Attributes {
		l = MarshalProtoOrigKeyValue(&orig.Attributes[i], buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x32
	}
	if orig.DroppedAttributesCount != 0 {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.DroppedAttributesCount))
		pos--
		buf[pos] = 0x38
	}
	if orig.Flags != 0 {
		pos -= 4
		binary.LittleEndian.PutUint32(buf[pos:], uint32(orig.Flags))
		pos--
		buf[pos] = 0x45
	}

	l = MarshalProtoOrigTraceID(&orig.TraceId, buf[:pos])
	pos -= l
	pos = proto.EncodeVarint(buf, pos, uint64(l))
	pos--
	buf[pos] = 0x4a

	l = MarshalProtoOrigSpanID(&orig.SpanId, buf[:pos])
	pos -= l
	pos = proto.EncodeVarint(buf, pos, uint64(l))
	pos--
	buf[pos] = 0x52

	l = len(orig.EventName)
	if l > 0 {
		pos -= l
		copy(buf[pos:], orig.EventName)
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x62
	}
	return len(buf) - pos
}

func UnmarshalProtoOrigLogRecord(orig *otlplogs.LogRecord, buf []byte) error {
	return orig.Unmarshal(buf)
}
