// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"

	otlpprofiles "go.opentelemetry.io/collector/pdata/internal/data/protogen/profiles/v1development"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyOrigMapping(t *testing.T) {
	src := &otlpprofiles.Mapping{}
	dest := &otlpprofiles.Mapping{}
	CopyOrigMapping(dest, src)
	assert.Equal(t, &otlpprofiles.Mapping{}, dest)
	FillOrigTestMapping(src)
	CopyOrigMapping(dest, src)
	assert.Equal(t, src, dest)
}

func TestMarshalAndUnmarshalJSONOrigMappingUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := &otlpprofiles.Mapping{}
	UnmarshalJSONOrigMapping(dest, iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, &otlpprofiles.Mapping{}, dest)
}

func TestMarshalAndUnmarshalJSONOrigMapping(t *testing.T) {
	for name, src := range getEncodingTestValuesMapping() {
		t.Run(name, func(t *testing.T) {
			stream := json.BorrowStream(nil)
			defer json.ReturnStream(stream)
			MarshalJSONOrigMapping(src, stream)
			require.NoError(t, stream.Error())

			iter := json.BorrowIterator(stream.Buffer())
			defer json.ReturnIterator(iter)
			dest := &otlpprofiles.Mapping{}
			UnmarshalJSONOrigMapping(dest, iter)
			require.NoError(t, iter.Error())

			assert.Equal(t, src, dest)
		})
	}
}

func TestMarshalAndUnmarshalProtoOrigMapping(t *testing.T) {
	for name, src := range getEncodingTestValuesMapping() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, SizeProtoOrigMapping(src))
			gotSize := MarshalProtoOrigMapping(src, buf)
			assert.Equal(t, len(buf), gotSize)

			dest := &otlpprofiles.Mapping{}
			require.NoError(t, UnmarshalProtoOrigMapping(dest, buf))
			assert.Equal(t, src, dest)
		})
	}
}

func getEncodingTestValuesMapping() map[string]*otlpprofiles.Mapping {
	return map[string]*otlpprofiles.Mapping{
		"empty": {},
		"fill_test": func() *otlpprofiles.Mapping {
			src := &otlpprofiles.Mapping{}
			FillOrigTestMapping(src)
			return src
		}(),
	}
}
