// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	otlpprofiles "go.opentelemetry.io/collector/pdata/internal/data/protogen/profiles/v1development"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func CopyOrigMappingSlice(dest, src []*otlpprofiles.Mapping) []*otlpprofiles.Mapping {
	var newDest []*otlpprofiles.Mapping
	if cap(dest) < len(src) {
		newDest = make([]*otlpprofiles.Mapping, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = &otlpprofiles.Mapping{}
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = &otlpprofiles.Mapping{}
		}
	}
	for i := range src {
		CopyOrigMapping(newDest[i], src[i])
	}
	return newDest
}

func GenerateOrigTestMappingSlice() []*otlpprofiles.Mapping {
	orig := make([]*otlpprofiles.Mapping, 7)
	for i := 0; i < 7; i++ {
		orig[i] = &otlpprofiles.Mapping{}
		FillOrigTestMapping(orig[i])
	}
	return orig
}

// UnmarshalJSONOrigMappingSlice unmarshals all properties from the current struct from the source iterator.
func UnmarshalJSONOrigMappingSlice(iter *json.Iterator) []*otlpprofiles.Mapping {
	var orig []*otlpprofiles.Mapping
	iter.ReadArrayCB(func(iter *json.Iterator) bool {
		orig = append(orig, &otlpprofiles.Mapping{})
		UnmarshalJSONOrigMapping(orig[len(orig)-1], iter)
		return true
	})
	return orig
}
