// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	otlpprofiles "go.opentelemetry.io/collector/pdata/internal/data/protogen/profiles/v1development"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func CopyOrigProfileSlice(dest, src []*otlpprofiles.Profile) []*otlpprofiles.Profile {
	var newDest []*otlpprofiles.Profile
	if cap(dest) < len(src) {
		newDest = make([]*otlpprofiles.Profile, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = &otlpprofiles.Profile{}
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = &otlpprofiles.Profile{}
		}
	}
	for i := range src {
		CopyOrigProfile(newDest[i], src[i])
	}
	return newDest
}

func GenerateOrigTestProfileSlice() []*otlpprofiles.Profile {
	orig := make([]*otlpprofiles.Profile, 7)
	for i := 0; i < 7; i++ {
		orig[i] = &otlpprofiles.Profile{}
		FillOrigTestProfile(orig[i])
	}
	return orig
}

// UnmarshalJSONOrigProfileSlice unmarshals all properties from the current struct from the source iterator.
func UnmarshalJSONOrigProfileSlice(iter *json.Iterator) []*otlpprofiles.Profile {
	var orig []*otlpprofiles.Profile
	iter.ReadArrayCB(func(iter *json.Iterator) bool {
		orig = append(orig, &otlpprofiles.Profile{})
		UnmarshalJSONOrigProfile(orig[len(orig)-1], iter)
		return true
	})
	return orig
}
