// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"

	otlpmetrics "go.opentelemetry.io/collector/pdata/internal/data/protogen/metrics/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyOrigResourceMetrics(t *testing.T) {
	src := &otlpmetrics.ResourceMetrics{}
	dest := &otlpmetrics.ResourceMetrics{}
	CopyOrigResourceMetrics(dest, src)
	assert.Equal(t, &otlpmetrics.ResourceMetrics{}, dest)
	FillOrigTestResourceMetrics(src)
	CopyOrigResourceMetrics(dest, src)
	assert.Equal(t, src, dest)
}

func TestMarshalAndUnmarshalJSONOrigResourceMetricsUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := &otlpmetrics.ResourceMetrics{}
	UnmarshalJSONOrigResourceMetrics(dest, iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, &otlpmetrics.ResourceMetrics{}, dest)
}

func TestMarshalAndUnmarshalJSONOrigResourceMetrics(t *testing.T) {
	for name, src := range getEncodingTestValuesResourceMetrics() {
		t.Run(name, func(t *testing.T) {
			stream := json.BorrowStream(nil)
			defer json.ReturnStream(stream)
			MarshalJSONOrigResourceMetrics(src, stream)
			require.NoError(t, stream.Error())

			iter := json.BorrowIterator(stream.Buffer())
			defer json.ReturnIterator(iter)
			dest := &otlpmetrics.ResourceMetrics{}
			UnmarshalJSONOrigResourceMetrics(dest, iter)
			require.NoError(t, iter.Error())

			assert.Equal(t, src, dest)
		})
	}
}

func TestMarshalAndUnmarshalProtoOrigResourceMetrics(t *testing.T) {
	for name, src := range getEncodingTestValuesResourceMetrics() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, SizeProtoOrigResourceMetrics(src))
			gotSize := MarshalProtoOrigResourceMetrics(src, buf)
			assert.Equal(t, len(buf), gotSize)

			dest := &otlpmetrics.ResourceMetrics{}
			require.NoError(t, UnmarshalProtoOrigResourceMetrics(dest, buf))
			assert.Equal(t, src, dest)
		})
	}
}

func getEncodingTestValuesResourceMetrics() map[string]*otlpmetrics.ResourceMetrics {
	return map[string]*otlpmetrics.ResourceMetrics{
		"empty": {},
		"fill_test": func() *otlpmetrics.ResourceMetrics {
			src := &otlpmetrics.ResourceMetrics{}
			FillOrigTestResourceMetrics(src)
			return src
		}(),
	}
}
