// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	otlptrace "go.opentelemetry.io/collector/pdata/internal/data/protogen/trace/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

func CopyOrigResourceSpans(dest, src *otlptrace.ResourceSpans) {
	CopyOrigResource(&dest.Resource, &src.Resource)
	dest.ScopeSpans = CopyOrigScopeSpansSlice(dest.ScopeSpans, src.ScopeSpans)
	dest.SchemaUrl = src.SchemaUrl
}

func FillOrigTestResourceSpans(orig *otlptrace.ResourceSpans) {
	FillOrigTestResource(&orig.Resource)
	orig.ScopeSpans = GenerateOrigTestScopeSpansSlice()
	orig.SchemaUrl = "test_schemaurl"
}

// MarshalJSONOrig marshals all properties from the current struct to the destination stream.
func MarshalJSONOrigResourceSpans(orig *otlptrace.ResourceSpans, dest *json.Stream) {
	dest.WriteObjectStart()
	dest.WriteObjectField("resource")
	MarshalJSONOrigResource(&orig.Resource, dest)
	if len(orig.ScopeSpans) > 0 {
		dest.WriteObjectField("scopeSpans")
		dest.WriteArrayStart()
		MarshalJSONOrigScopeSpans(orig.ScopeSpans[0], dest)
		for i := 1; i < len(orig.ScopeSpans); i++ {
			dest.WriteMore()
			MarshalJSONOrigScopeSpans(orig.ScopeSpans[i], dest)
		}
		dest.WriteArrayEnd()
	}
	if orig.SchemaUrl != "" {
		dest.WriteObjectField("schemaUrl")
		dest.WriteString(orig.SchemaUrl)
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSONOrigResourceSpans unmarshals all properties from the current struct from the source iterator.
func UnmarshalJSONOrigResourceSpans(orig *otlptrace.ResourceSpans, iter *json.Iterator) {
	iter.ReadObjectCB(func(iter *json.Iterator, f string) bool {
		switch f {
		case "resource":
			UnmarshalJSONOrigResource(&orig.Resource, iter)
		case "scopeSpans", "scope_spans":
			orig.ScopeSpans = UnmarshalJSONOrigScopeSpansSlice(iter)
		case "schemaUrl", "schema_url":
			orig.SchemaUrl = iter.ReadString()
		default:
			iter.Skip()
		}
		return true
	})
}

func SizeProtoOrigResourceSpans(orig *otlptrace.ResourceSpans) int {
	var n int
	var l int
	_ = l
	l = SizeProtoOrigResource(&orig.Resource)
	n += 1 + proto.Sov(uint64(l)) + l
	for i := range orig.ScopeSpans {
		l = SizeProtoOrigScopeSpans(orig.ScopeSpans[i])
		n += 1 + proto.Sov(uint64(l)) + l
	}
	l = len(orig.SchemaUrl)
	if l > 0 {
		n += 1 + proto.Sov(uint64(l)) + l
	}
	return n
}

func MarshalProtoOrigResourceSpans(orig *otlptrace.ResourceSpans, buf []byte) int {
	pos := len(buf)
	var l int
	_ = l

	l = MarshalProtoOrigResource(&orig.Resource, buf[:pos])
	pos -= l
	pos = proto.EncodeVarint(buf, pos, uint64(l))
	pos--
	buf[pos] = 0xa

	for i := range orig.ScopeSpans {
		l = MarshalProtoOrigScopeSpans(orig.ScopeSpans[i], buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x12
	}
	l = len(orig.SchemaUrl)
	if l > 0 {
		pos -= l
		copy(buf[pos:], orig.SchemaUrl)
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x1a
	}
	return len(buf) - pos
}

func UnmarshalProtoOrigResourceSpans(orig *otlptrace.ResourceSpans, buf []byte) error {
	return orig.Unmarshal(buf)
}
