// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	otlplogs "go.opentelemetry.io/collector/pdata/internal/data/protogen/logs/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

func CopyOrigScopeLogs(dest, src *otlplogs.ScopeLogs) {
	CopyOrigInstrumentationScope(&dest.Scope, &src.Scope)
	dest.LogRecords = CopyOrigLogRecordSlice(dest.LogRecords, src.LogRecords)
	dest.SchemaUrl = src.SchemaUrl
}

func FillOrigTestScopeLogs(orig *otlplogs.ScopeLogs) {
	FillOrigTestInstrumentationScope(&orig.Scope)
	orig.LogRecords = GenerateOrigTestLogRecordSlice()
	orig.SchemaUrl = "test_schemaurl"
}

// MarshalJSONOrig marshals all properties from the current struct to the destination stream.
func MarshalJSONOrigScopeLogs(orig *otlplogs.ScopeLogs, dest *json.Stream) {
	dest.WriteObjectStart()
	dest.WriteObjectField("scope")
	MarshalJSONOrigInstrumentationScope(&orig.Scope, dest)
	if len(orig.LogRecords) > 0 {
		dest.WriteObjectField("logRecords")
		dest.WriteArrayStart()
		MarshalJSONOrigLogRecord(orig.LogRecords[0], dest)
		for i := 1; i < len(orig.LogRecords); i++ {
			dest.WriteMore()
			MarshalJSONOrigLogRecord(orig.LogRecords[i], dest)
		}
		dest.WriteArrayEnd()
	}
	if orig.SchemaUrl != "" {
		dest.WriteObjectField("schemaUrl")
		dest.WriteString(orig.SchemaUrl)
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSONOrigScopeLogs unmarshals all properties from the current struct from the source iterator.
func UnmarshalJSONOrigScopeLogs(orig *otlplogs.ScopeLogs, iter *json.Iterator) {
	iter.ReadObjectCB(func(iter *json.Iterator, f string) bool {
		switch f {
		case "scope":
			UnmarshalJSONOrigInstrumentationScope(&orig.Scope, iter)
		case "logRecords", "log_records":
			orig.LogRecords = UnmarshalJSONOrigLogRecordSlice(iter)
		case "schemaUrl", "schema_url":
			orig.SchemaUrl = iter.ReadString()
		default:
			iter.Skip()
		}
		return true
	})
}

func SizeProtoOrigScopeLogs(orig *otlplogs.ScopeLogs) int {
	var n int
	var l int
	_ = l
	l = SizeProtoOrigInstrumentationScope(&orig.Scope)
	n += 1 + proto.Sov(uint64(l)) + l
	for i := range orig.LogRecords {
		l = SizeProtoOrigLogRecord(orig.LogRecords[i])
		n += 1 + proto.Sov(uint64(l)) + l
	}
	l = len(orig.SchemaUrl)
	if l > 0 {
		n += 1 + proto.Sov(uint64(l)) + l
	}
	return n
}

func MarshalProtoOrigScopeLogs(orig *otlplogs.ScopeLogs, buf []byte) int {
	pos := len(buf)
	var l int
	_ = l

	l = MarshalProtoOrigInstrumentationScope(&orig.Scope, buf[:pos])
	pos -= l
	pos = proto.EncodeVarint(buf, pos, uint64(l))
	pos--
	buf[pos] = 0xa

	for i := range orig.LogRecords {
		l = MarshalProtoOrigLogRecord(orig.LogRecords[i], buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x12
	}
	l = len(orig.SchemaUrl)
	if l > 0 {
		pos -= l
		copy(buf[pos:], orig.SchemaUrl)
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x1a
	}
	return len(buf) - pos
}

func UnmarshalProtoOrigScopeLogs(orig *otlplogs.ScopeLogs, buf []byte) error {
	return orig.Unmarshal(buf)
}
