// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"

	otlplogs "go.opentelemetry.io/collector/pdata/internal/data/protogen/logs/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyOrigScopeLogs(t *testing.T) {
	src := &otlplogs.ScopeLogs{}
	dest := &otlplogs.ScopeLogs{}
	CopyOrigScopeLogs(dest, src)
	assert.Equal(t, &otlplogs.ScopeLogs{}, dest)
	FillOrigTestScopeLogs(src)
	CopyOrigScopeLogs(dest, src)
	assert.Equal(t, src, dest)
}

func TestMarshalAndUnmarshalJSONOrigScopeLogsUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := &otlplogs.ScopeLogs{}
	UnmarshalJSONOrigScopeLogs(dest, iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, &otlplogs.ScopeLogs{}, dest)
}

func TestMarshalAndUnmarshalJSONOrigScopeLogs(t *testing.T) {
	for name, src := range getEncodingTestValuesScopeLogs() {
		t.Run(name, func(t *testing.T) {
			stream := json.BorrowStream(nil)
			defer json.ReturnStream(stream)
			MarshalJSONOrigScopeLogs(src, stream)
			require.NoError(t, stream.Error())

			iter := json.BorrowIterator(stream.Buffer())
			defer json.ReturnIterator(iter)
			dest := &otlplogs.ScopeLogs{}
			UnmarshalJSONOrigScopeLogs(dest, iter)
			require.NoError(t, iter.Error())

			assert.Equal(t, src, dest)
		})
	}
}

func TestMarshalAndUnmarshalProtoOrigScopeLogs(t *testing.T) {
	for name, src := range getEncodingTestValuesScopeLogs() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, SizeProtoOrigScopeLogs(src))
			gotSize := MarshalProtoOrigScopeLogs(src, buf)
			assert.Equal(t, len(buf), gotSize)

			dest := &otlplogs.ScopeLogs{}
			require.NoError(t, UnmarshalProtoOrigScopeLogs(dest, buf))
			assert.Equal(t, src, dest)
		})
	}
}

func getEncodingTestValuesScopeLogs() map[string]*otlplogs.ScopeLogs {
	return map[string]*otlplogs.ScopeLogs{
		"empty": {},
		"fill_test": func() *otlplogs.ScopeLogs {
			src := &otlplogs.ScopeLogs{}
			FillOrigTestScopeLogs(src)
			return src
		}(),
	}
}
