// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	otlptrace "go.opentelemetry.io/collector/pdata/internal/data/protogen/trace/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func CopyOrigScopeSpansSlice(dest, src []*otlptrace.ScopeSpans) []*otlptrace.ScopeSpans {
	var newDest []*otlptrace.ScopeSpans
	if cap(dest) < len(src) {
		newDest = make([]*otlptrace.ScopeSpans, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = &otlptrace.ScopeSpans{}
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = &otlptrace.ScopeSpans{}
		}
	}
	for i := range src {
		CopyOrigScopeSpans(newDest[i], src[i])
	}
	return newDest
}

func GenerateOrigTestScopeSpansSlice() []*otlptrace.ScopeSpans {
	orig := make([]*otlptrace.ScopeSpans, 7)
	for i := 0; i < 7; i++ {
		orig[i] = &otlptrace.ScopeSpans{}
		FillOrigTestScopeSpans(orig[i])
	}
	return orig
}

// UnmarshalJSONOrigScopeSpansSlice unmarshals all properties from the current struct from the source iterator.
func UnmarshalJSONOrigScopeSpansSlice(iter *json.Iterator) []*otlptrace.ScopeSpans {
	var orig []*otlptrace.ScopeSpans
	iter.ReadArrayCB(func(iter *json.Iterator) bool {
		orig = append(orig, &otlptrace.ScopeSpans{})
		UnmarshalJSONOrigScopeSpans(orig[len(orig)-1], iter)
		return true
	})
	return orig
}
