// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package ptrace

import (
	"testing"

	"github.com/stretchr/testify/assert"

	"go.opentelemetry.io/collector/pdata/internal"
	"go.opentelemetry.io/collector/pdata/internal/data"
	otlptrace "go.opentelemetry.io/collector/pdata/internal/data/protogen/trace/v1"
	"go.opentelemetry.io/collector/pdata/pcommon"
)

func TestSpanLink_MoveTo(t *testing.T) {
	ms := generateTestSpanLink()
	dest := NewSpanLink()
	ms.MoveTo(dest)
	assert.Equal(t, NewSpanLink(), ms)
	assert.Equal(t, generateTestSpanLink(), dest)
	dest.MoveTo(dest)
	assert.Equal(t, generateTestSpanLink(), dest)
	sharedState := internal.StateReadOnly
	assert.Panics(t, func() { ms.MoveTo(newSpanLink(&otlptrace.Span_Link{}, &sharedState)) })
	assert.Panics(t, func() { newSpanLink(&otlptrace.Span_Link{}, &sharedState).MoveTo(dest) })
}

func TestSpanLink_CopyTo(t *testing.T) {
	ms := NewSpanLink()
	orig := NewSpanLink()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	orig = generateTestSpanLink()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	sharedState := internal.StateReadOnly
	assert.Panics(t, func() { ms.CopyTo(newSpanLink(&otlptrace.Span_Link{}, &sharedState)) })
}

func TestSpanLink_TraceID(t *testing.T) {
	ms := NewSpanLink()
	assert.Equal(t, pcommon.TraceID(data.TraceID([16]byte{})), ms.TraceID())
	testValTraceID := pcommon.TraceID(data.TraceID([16]byte{1, 2, 3, 4, 5, 6, 7, 8, 8, 7, 6, 5, 4, 3, 2, 1}))
	ms.SetTraceID(testValTraceID)
	assert.Equal(t, testValTraceID, ms.TraceID())
}

func TestSpanLink_SpanID(t *testing.T) {
	ms := NewSpanLink()
	assert.Equal(t, pcommon.SpanID(data.SpanID([8]byte{})), ms.SpanID())
	testValSpanID := pcommon.SpanID(data.SpanID([8]byte{8, 7, 6, 5, 4, 3, 2, 1}))
	ms.SetSpanID(testValSpanID)
	assert.Equal(t, testValSpanID, ms.SpanID())
}

func TestSpanLink_TraceState(t *testing.T) {
	ms := NewSpanLink()
	assert.Equal(t, pcommon.NewTraceState(), ms.TraceState())
	internal.FillOrigTestTraceState(&ms.orig.TraceState)
	assert.Equal(t, pcommon.TraceState(internal.GenerateTestTraceState()), ms.TraceState())
}

func TestSpanLink_Attributes(t *testing.T) {
	ms := NewSpanLink()
	assert.Equal(t, pcommon.NewMap(), ms.Attributes())
	ms.orig.Attributes = internal.GenerateOrigTestKeyValueSlice()
	assert.Equal(t, pcommon.Map(internal.GenerateTestMap()), ms.Attributes())
}

func TestSpanLink_DroppedAttributesCount(t *testing.T) {
	ms := NewSpanLink()
	assert.Equal(t, uint32(0), ms.DroppedAttributesCount())
	ms.SetDroppedAttributesCount(uint32(13))
	assert.Equal(t, uint32(13), ms.DroppedAttributesCount())
	sharedState := internal.StateReadOnly
	assert.Panics(t, func() { newSpanLink(&otlptrace.Span_Link{}, &sharedState).SetDroppedAttributesCount(uint32(13)) })
}

func TestSpanLink_Flags(t *testing.T) {
	ms := NewSpanLink()
	assert.Equal(t, uint32(0), ms.Flags())
	ms.SetFlags(uint32(13))
	assert.Equal(t, uint32(13), ms.Flags())
	sharedState := internal.StateReadOnly
	assert.Panics(t, func() { newSpanLink(&otlptrace.Span_Link{}, &sharedState).SetFlags(uint32(13)) })
}

func generateTestSpanLink() SpanLink {
	ms := NewSpanLink()
	internal.FillOrigTestSpan_Link(ms.orig)
	return ms
}
