// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	otlpprofiles "go.opentelemetry.io/collector/pdata/internal/data/protogen/profiles/v1development"
)

func CopyOrigResourceProfilesSlice(dest, src []*otlpprofiles.ResourceProfiles) []*otlpprofiles.ResourceProfiles {
	var newDest []*otlpprofiles.ResourceProfiles
	if cap(dest) < len(src) {
		newDest = make([]*otlpprofiles.ResourceProfiles, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewOrigResourceProfiles()
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteOrigResourceProfiles(dest[i], true)
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewOrigResourceProfiles()
		}
	}
	for i := range src {
		CopyOrigResourceProfiles(newDest[i], src[i])
	}
	return newDest
}

func GenerateOrigTestResourceProfilesSlice() []*otlpprofiles.ResourceProfiles {
	orig := make([]*otlpprofiles.ResourceProfiles, 5)
	orig[0] = NewOrigResourceProfiles()
	orig[1] = GenTestOrigResourceProfiles()
	orig[2] = NewOrigResourceProfiles()
	orig[3] = GenTestOrigResourceProfiles()
	orig[4] = NewOrigResourceProfiles()
	return orig
}
