20 May 2025

> [!WARNING]
>
> #### Tiered Policy naming changes
>
> The addition of tiered policies in v3.29.0 changed the naming of policies in the default tier, which caused confusion with tooling that didn't expect it. In v3.29.4, we've made the following updates to how policies in the default tier are handled:
>
> * Policies in the default Tier can be created with the default prefix or without it. The policy can only be managed with the same name that was used during the create and it’s not possible to interchange the prefixed and not prefixed name
> * Calico will always return the same policy name that you have used to create the policy
>
> #### Upgrade considerations
>
> * If upgrading from Calico v3.28 or earlier to 3.29.4, no changes will be necessary. Calico will continue to return already created policies in the same format that they were created with, without the default prefix.
> * If upgrading from Calico v3.29.[0-3] to 3.29.4, already created policies in the default tier will no longer be returned with the default prefix. You can recreate your policy to include the default prefix again


#### Bug fixes

* Change OpenShift manifests order to fix an error when creating HCP clusters. [calico 10255](https://github.com/projectcalico/calico/pull/10255) (@coutinhop)
* Fix missing RBAC permissions for kube-controller-manager to access tiers in manifest installs, which was preventing proper resource garbage collection. [calico 10230](https://github.com/projectcalico/calico/pull/10230) (@caseydavenport)
* ebpf - Fix dropping packets from workloads to host interfaces not managed by calico. [calico 10226](https://github.com/projectcalico/calico/pull/10226) (@sridhartigera)
* ebpf - Fix configuring arp entries for bpf NAT devices for systemd >= 242 [calico 10217](https://github.com/projectcalico/calico/pull/10217) (@sridhartigera)
* ebpf - Fixed a bug where BPF programs were being re-attached to network interfaces unnecessarily, even when the host IP address had not changed. [calico 10164](https://github.com/projectcalico/calico/pull/10164) (@sridhartigera)

#### Changes to tier naming

* Policies created prior to v3.28.0 have their name retained across upgrade. Policies created in the default tier with version v3.29.[0-3] will have their names changed from `default.name` to `name`. [calico 10417](https://github.com/projectcalico/calico/pull/10417) (@MichalFupso)
* Policies part of the default tier can be managed only with the original name they were created with. Policies are no longer able to be managed interchangeably with or without the default. tier prefix [calico 10391](https://github.com/projectcalico/calico/pull/10391) (@MichalFupso)

#### Other changes

* Update Operator Helm values to support custom DNS settings [calico 10407](https://github.com/projectcalico/calico/pull/10407) (@caseydavenport)
