/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.hierarchy;

import com.sun.electric.database.change.Undo;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.PrimitivePort;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.Iterator;

public class Export
extends PortProto {
    public static final Variable.Key EXPORT_REFERENCE_NAME = ElectricObject.newKey("EXPORT_reference_name");
    private PortInst originalPort;
    private Undo.Change change;

    protected Export() {
    }

    public static Export newInstance(Cell parent, PortInst portInst, String protoName) {
        if (parent.findExport(protoName) != null) {
            System.out.println("Cell " + parent.describe() + " already has an export called " + protoName);
            return null;
        }
        Export pp = Export.lowLevelAllocate();
        if (pp.lowLevelName(parent, protoName)) {
            return null;
        }
        if (pp.lowLevelPopulate(portInst)) {
            return null;
        }
        if (pp.lowLevelLink(null)) {
            return null;
        }
        pp.getTextDescriptor().setSmartPlacement();
        Undo.newObject(pp);
        return pp;
    }

    public void kill() {
        Collection oldPortInsts = this.lowLevelUnlink();
        Undo.killExport(this, oldPortInsts);
    }

    public void rename(String newName) {
        this.checkChanging();
        Name oldName = this.getNameKey();
        this.lowLevelRename(newName);
        Undo.renameObject(this, oldName);
    }

    public boolean move(PortInst newPi) {
        NodeInst newno = newPi.getNodeInst();
        PortProto newsubpt = newPi.getPortProto();
        Cell cell = (Cell)this.getParent();
        if (newno.getParent() != cell) {
            return true;
        }
        if (newsubpt.getParent() != newno.getProto()) {
            return true;
        }
        if (this.doesntConnect(newsubpt.getBasePort())) {
            return true;
        }
        PortInst oldPi = this.getOriginalPort();
        this.lowLevelModify(newPi);
        Undo.modifyExport(this, oldPi);
        return false;
    }

    public static Export lowLevelAllocate() {
        Export pp = new Export();
        return pp;
    }

    public boolean lowLevelName(Cell parent, String protoName) {
        this.parent = parent;
        this.setProtoName(protoName);
        this.setParent(parent);
        return false;
    }

    public void lowLevelRename(String newName) {
        this.setProtoName(newName);
    }

    public boolean lowLevelPopulate(PortInst originalPort) {
        if (originalPort == null) {
            System.out.println("Null port on Export " + this.getName() + " in cell " + this.parent.describe());
            return true;
        }
        this.originalPort = originalPort;
        this.userBits = originalPort.getPortProto().lowLevelGetUserbits();
        return false;
    }

    public boolean lowLevelLink(Collection oldPortInsts) {
        NodeInst originalNode = this.originalPort.getNodeInst();
        originalNode.addExport(this);
        this.getParent().addPort(this, oldPortInsts);
        return false;
    }

    public Collection lowLevelUnlink() {
        NodeInst originalNode = this.originalPort.getNodeInst();
        originalNode.removeExport(this);
        return this.getParent().removePort(this);
    }

    public void lowLevelModify(PortInst newPi) {
        NodeInst origNode = this.getOriginalPort().getNodeInst();
        origNode.removeExport(this);
        NodeInst newNodeInst = newPi.getNodeInst();
        PortProto newPortProto = newPi.getPortProto();
        newNodeInst.addExport(this);
        this.originalPort = newNodeInst.findPortInstFromProto(newPortProto);
        this.changeallports();
    }

    public Poly getNamePoly() {
        Poly poly = this.getOriginalPort().getPoly();
        double cX = poly.getCenterX();
        double cY = poly.getCenterY();
        TextDescriptor td = this.getTextDescriptor();
        double offX = td.getXOff();
        double offY = td.getYOff();
        TextDescriptor.Position pos = td.getPos();
        Poly.Type style = pos.getPolyType();
        Point2D[] pointList = new Point2D.Double[]{new Point2D.Double(cX + offX, cY + offY)};
        poly = new Poly(pointList);
        poly.setStyle(style);
        poly.setPort(this);
        poly.setString(this.getName());
        poly.setTextDescriptor(td);
        return poly;
    }

    public void checkChanging() {
        Cell parent = (Cell)this.getParent();
        if (parent != null) {
            parent.checkChanging();
        }
    }

    public Cell whichCell() {
        return (Cell)this.getParent();
    }

    public String toString() {
        return "Export " + this.getName();
    }

    public PortInst getOriginalPort() {
        return this.originalPort;
    }

    public PrimitivePort getBasePort() {
        PortProto pp = this.originalPort.getPortProto();
        return pp.getBasePort();
    }

    public void setChange(Undo.Change change) {
        this.change = change;
    }

    public Undo.Change getChange() {
        return this.change;
    }

    public PortProto getEquivalent() {
        Cell equiv = ((Cell)this.parent).getEquivalent();
        if (equiv == this.parent) {
            return this;
        }
        if (equiv == null) {
            return null;
        }
        return equiv.findPortProto(this.getNameKey());
    }

    public Export getEquivalentPort(Cell otherCell) {
        Cell thisCell = (Cell)this.getParent();
        if (thisCell == otherCell) {
            return this;
        }
        return otherCell.findExport(this.getName());
    }

    public boolean doesntConnect(PrimitivePort newPP) {
        Cell cell = (Cell)this.getParent();
        Iterator it = cell.getInstancesOf();
        while (it.hasNext()) {
            NodeInst ni = (NodeInst)it.next();
            Iterator cIt = ni.getConnections();
            while (cIt.hasNext()) {
                Connection con = (Connection)cIt.next();
                if (con.getPortInst().getPortProto() != this || newPP.connectsTo(con.getArc().getProto())) continue;
                System.out.println(con.getArc().describe() + " arc in cell " + ni.getParent().describe() + " cannot connect to port " + this.getName());
                return true;
            }
            Iterator eIt = ni.getExports();
            while (eIt.hasNext()) {
                Export oPP = (Export)eIt.next();
                if (oPP.getOriginalPort().getPortProto() != this || !oPP.doesntConnect(newPP)) continue;
                return true;
            }
        }
        return false;
    }

    private void changeallports() {
        Export opp;
        this.recursivelyChangeAllPorts();
        Cell np = (Cell)this.getParent();
        if (np.getView() == View.ICON) {
            Export opp2;
            Cell onp = np.contentsView();
            if (onp != null && (opp2 = this.getEquivalentPort(onp)) != null) {
                opp2.setCharacteristic(this.getCharacteristic());
                opp2.recursivelyChangeAllPorts();
            }
            return;
        }
        Cell onp = np.iconView();
        if (onp != null && (opp = this.getEquivalentPort(onp)) != null) {
            opp.setCharacteristic(this.getCharacteristic());
            opp.recursivelyChangeAllPorts();
        }
    }

    private void recursivelyChangeAllPorts() {
        Cell cell = (Cell)this.getParent();
        Iterator it = cell.getInstancesOf();
        while (it.hasNext()) {
            NodeInst ni = (NodeInst)it.next();
            Iterator pIt = ni.getExports();
            while (pIt.hasNext()) {
                Export upPP = (Export)pIt.next();
                if (upPP.getOriginalPort().getPortProto() != this) continue;
                if (upPP.lowLevelGetUserbits() != this.lowLevelGetUserbits()) {
                    upPP.lowLevelSetUserbits(this.lowLevelGetUserbits());
                }
                upPP.recursivelyChangeAllPorts();
            }
        }
    }
}

