/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.variable;

import com.sun.electric.database.change.Undo;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.ImmutableTextDescriptor;
import com.sun.electric.database.variable.MutableTextDescriptor;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.user.ui.EditWindow;

public class Variable {
    private final ElectricObject owner;
    private final Key key;
    private Object addr;
    private ImmutableTextDescriptor descriptor;
    private boolean linked;

    Variable(ElectricObject owner, Object addr, TextDescriptor descriptor, Key key) {
        this.owner = owner;
        this.addr = addr;
        this.descriptor = ImmutableTextDescriptor.newImmutableTextDescriptor(descriptor);
        if (!(owner instanceof Cell)) {
            this.descriptor = this.descriptor.withoutParam();
        }
        this.key = key;
    }

    public boolean compare(Object obj, StringBuffer buffer) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Variable var = (Variable)obj;
        boolean check = var.getTextDescriptor().equals(this.getTextDescriptor());
        if (!check && buffer != null) {
            buffer.append("No same variables detected in " + var + " and " + this + "\n");
        }
        return check;
    }

    public synchronized int getLength() {
        if (this.addr instanceof Object[]) {
            return ((Object[])this.addr).length;
        }
        return 1;
    }

    public Object getObject() {
        return this.addr;
    }

    public synchronized Object getObject(int index) {
        if (!(this.addr instanceof Object[])) {
            return null;
        }
        return ((Object[])this.addr)[index];
    }

    public synchronized void lowLevelInsert(int index, Object value) {
        int i;
        Object[] oldArr = (Object[])this.addr;
        Object[] newArr = new Object[oldArr.length + 1];
        for (i = 0; i < index; ++i) {
            newArr[i] = oldArr[i];
        }
        newArr[index] = value;
        for (i = index; i < oldArr.length; ++i) {
            newArr[i + 1] = oldArr[i];
        }
        this.addr = newArr;
    }

    public synchronized void lowLevelDelete(int index) {
        int i;
        Object[] oldArr = (Object[])this.addr;
        Object[] newArr = new Object[oldArr.length - 1];
        for (i = 0; i < index; ++i) {
            newArr[i] = oldArr[i];
        }
        for (i = index; i < newArr.length; ++i) {
            newArr[i] = oldArr[i + 1];
        }
        this.addr = newArr;
    }

    public Key getKey() {
        return this.key;
    }

    void setLinked(boolean linked) {
        this.linked = linked;
    }

    public boolean isLinked() {
        return this.linked && this.owner.isLinked();
    }

    public ElectricObject getOwner() {
        return this.owner;
    }

    public boolean isActuallyLinked() {
        ElectricObject owner = this.getOwner();
        return owner != null && owner.isLinked() && owner.getVar(this.key) == this;
    }

    public String getReadableName() {
        String betterName;
        String trueName = "";
        String name = this.key.getName();
        trueName = name.startsWith("ATTR_") ? (this.isParam() ? trueName + "Parameter '" + name.substring(5) + "'" : trueName + "Attribute '" + name.substring(5) + "'") : ((betterName = Variable.betterVariableName(name)) != null ? trueName + betterName : trueName + "Variable '" + name + "'");
        return trueName;
    }

    public String getFullDescription(ElectricObject eobj) {
        String trueName = this.getReadableName();
        String description = null;
        if (eobj instanceof Export) {
            description = trueName + " on " + eobj;
        } else if (eobj instanceof PortInst) {
            PortInst pi = (PortInst)eobj;
            description = trueName + " on " + pi.getPortProto() + " of " + pi.getNodeInst().describe(true);
        } else if (eobj instanceof ArcInst) {
            description = trueName + " on " + eobj;
        } else if (eobj instanceof NodeInst) {
            String varName;
            String betterName;
            NodeInst ni = (NodeInst)eobj;
            description = trueName + " on " + ni;
            if (ni.getProto() == Generic.tech.invisiblePinNode && (betterName = Variable.betterVariableName(varName = this.getKey().getName())) != null) {
                description = betterName;
            }
        } else if (eobj instanceof Cell) {
            description = trueName + " of " + eobj;
        }
        return description;
    }

    public static String betterVariableName(String name) {
        if (name.equals("ARC_name")) {
            return "Arc Name";
        }
        if (name.equals("ARC_radius")) {
            return "Arc Radius";
        }
        if (name.equals("ART_color")) {
            return "Color";
        }
        if (name.equals("ART_degrees")) {
            return "Number of Degrees";
        }
        if (name.equals("ART_message")) {
            return "Annotation text";
        }
        if (name.equals("NET_ncc_match")) {
            return "NCC equivalence";
        }
        if (name.equals("NET_ncc_forcedassociation")) {
            return "NCC association";
        }
        if (name.equals("NODE_name")) {
            return "Node Name";
        }
        if (name.equals("SCHEM_capacitance")) {
            return "Capacitance";
        }
        if (name.equals("SCHEM_diode")) {
            return "Diode Size";
        }
        if (name.equals("SCHEM_global_name")) {
            return "Global Signal Name";
        }
        if (name.equals("SCHEM_inductance")) {
            return "Inductance";
        }
        if (name.equals("SCHEM_resistance")) {
            return "Resistance";
        }
        if (name.equals("SIM_fall_delay")) {
            return "Fall Delay";
        }
        if (name.equals("SIM_fasthenry_group_name")) {
            return "FastHenry Group";
        }
        if (name.equals("SIM_rise_delay")) {
            return "Rise Delay";
        }
        if (name.equals("SIM_spice_card")) {
            return "SPICE code";
        }
        if (name.equals("SIM_spice_model")) {
            return "SPICE model";
        }
        if (name.equals("SIM_verilog_wire_type")) {
            return "Verilog Wire type";
        }
        if (name.equals("SIM_weak_node")) {
            return "Transistor Strength";
        }
        if (name.equals("transistor_width")) {
            return "Transistor Width";
        }
        if (name.equals("VERILOG_code")) {
            return "Verilog code";
        }
        if (name.equals("VERILOG_declaration")) {
            return "Verilog declaration";
        }
        return null;
    }

    public String getTrueName() {
        String name = this.key.getName();
        if (name.startsWith("ATTR_")) {
            return name.substring(5);
        }
        if (name.startsWith("ATTRP_")) {
            int i = name.lastIndexOf(95);
            return name.substring(i);
        }
        return name;
    }

    public String describe(VarContext context, Object eobj) {
        return this.describe(-1, context, eobj);
    }

    public String describe(int aindex) {
        return this.describe(aindex, VarContext.globalContext, null);
    }

    public String describe(int aindex, VarContext context, Object eobj) {
        TextDescriptor.Unit units = this.descriptor.getUnit();
        StringBuffer returnVal = new StringBuffer();
        TextDescriptor.DispPos dispPos = this.descriptor.getDispPart();
        if (this.isCode()) {
            if (context == null) {
                context = VarContext.globalContext;
            }
            Object val = null;
            try {
                val = context.evalVarRecurse(this, eobj);
            }
            catch (VarContext.EvalException e) {
                val = e.getMessage();
            }
            if (val == null) {
                val = "?";
            }
            returnVal.append(this.makeStringVar(val, units));
        } else {
            returnVal.append(this.getPureValue(aindex));
        }
        if (dispPos == TextDescriptor.DispPos.NAMEVALUE && (aindex < 0 || this.getLength() == 1)) {
            return this.getTrueName() + "=" + returnVal.toString();
        }
        return returnVal.toString();
    }

    public String getPureValue(int aindex) {
        TextDescriptor.Unit units = this.descriptor.getUnit();
        StringBuffer returnVal = new StringBuffer();
        Object thisAddr = this.getObject();
        if (thisAddr instanceof Object[]) {
            Object[] addrArray = (Object[])thisAddr;
            int len = addrArray.length;
            if (aindex >= 0) {
                if (aindex < len) {
                    returnVal.append(this.makeStringVar(addrArray[aindex], units));
                }
            } else {
                if (len > 1) {
                    returnVal.append("[");
                }
                for (int i = 0; i < len; ++i) {
                    if (i != 0) {
                        returnVal.append(",");
                    }
                    returnVal.append(this.makeStringVar(addrArray[i], units));
                }
                if (len > 1) {
                    returnVal.append("]");
                }
            }
        } else {
            returnVal.append(this.makeStringVar(thisAddr, units));
        }
        return returnVal.toString();
    }

    private String makeStringVar(Object addr, TextDescriptor.Unit units) {
        if (addr instanceof Integer) {
            return ((Integer)addr).toString();
        }
        if (addr instanceof Float) {
            return TextUtils.makeUnits(((Float)addr).floatValue(), units);
        }
        if (addr instanceof Double) {
            return TextUtils.makeUnits((Double)addr, units);
        }
        if (addr instanceof Short) {
            return ((Short)addr).toString();
        }
        if (addr instanceof Byte) {
            return ((Byte)addr).toString();
        }
        if (addr instanceof String) {
            return (String)addr;
        }
        if (addr instanceof NodeInst) {
            return ((NodeInst)addr).describe(false);
        }
        if (addr instanceof ArcInst) {
            return ((ArcInst)addr).describe(false);
        }
        if (addr instanceof Object[]) {
            StringBuffer buf = new StringBuffer();
            buf.append("[");
            Object[] objects = (Object[])addr;
            for (int i = 0; i < objects.length; ++i) {
                buf.append(this.makeStringVar(objects[i], units));
                buf.append(", ");
            }
            buf.replace(buf.length() - 2, buf.length(), "]");
            return buf.toString();
        }
        return "?";
    }

    public ImmutableTextDescriptor getTextDescriptor() {
        return this.descriptor;
    }

    public void setTextDescriptor(TextDescriptor descriptor) {
        this.owner.checkChanging();
        ImmutableTextDescriptor oldDescriptor = this.lowLevelSetTextDescriptor(ImmutableTextDescriptor.newImmutableTextDescriptor(descriptor));
        Undo.modifyTextDescript(this.owner, this.key.getName(), oldDescriptor);
    }

    ImmutableTextDescriptor lowLevelSetTextDescriptor(ImmutableTextDescriptor descriptor) {
        ImmutableTextDescriptor oldDescriptor = this.descriptor;
        if (!(this.owner instanceof Cell)) {
            descriptor = descriptor.withoutParam();
        }
        this.descriptor = descriptor;
        return oldDescriptor;
    }

    public synchronized void setDisplay(boolean state) {
        MutableTextDescriptor td = new MutableTextDescriptor(this.descriptor);
        td.setDisplay(state);
        this.setTextDescriptor(td);
    }

    public boolean isDisplay() {
        return this.descriptor.isDisplay();
    }

    public TextDescriptor.Code getCode() {
        return this.descriptor.getCode();
    }

    public void setCode(TextDescriptor.Code code) {
        MutableTextDescriptor td = new MutableTextDescriptor(this.descriptor);
        td.setCode(code);
        this.setTextDescriptor(td);
    }

    public boolean isJava() {
        return this.descriptor.isJava();
    }

    public boolean isCode() {
        return this.descriptor.isCode();
    }

    public boolean isAttribute() {
        return this.getKey().getName().startsWith("ATTR_");
    }

    public String toString() {
        return this.key.getName();
    }

    public int getColorIndex() {
        return this.descriptor.getColorIndex();
    }

    public void setColorIndex(int colorIndex) {
        MutableTextDescriptor td = new MutableTextDescriptor(this.descriptor);
        td.setColorIndex(colorIndex);
        this.setTextDescriptor(td);
    }

    public TextDescriptor.Position getPos() {
        return this.descriptor.getPos();
    }

    public synchronized void setPos(TextDescriptor.Position p) {
        MutableTextDescriptor td = new MutableTextDescriptor(this.descriptor);
        td.setPos(p);
        this.setTextDescriptor(td);
    }

    public synchronized TextDescriptor.Size getSize() {
        return this.descriptor.getSize();
    }

    public double getTrueSize(EditWindow wnd) {
        return this.descriptor.getTrueSize(wnd);
    }

    public synchronized void setAbsSize(int s) {
        MutableTextDescriptor td = new MutableTextDescriptor(this.descriptor);
        td.setAbsSize(s);
        this.setTextDescriptor(td);
    }

    public synchronized void setRelSize(double s) {
        MutableTextDescriptor td = new MutableTextDescriptor(this.descriptor);
        td.setRelSize(s);
        this.setTextDescriptor(td);
    }

    public int getFace() {
        return this.descriptor.getFace();
    }

    public synchronized void setFace(int f) {
        MutableTextDescriptor td = new MutableTextDescriptor(this.descriptor);
        td.setFace(f);
        this.setTextDescriptor(td);
    }

    public TextDescriptor.Rotation getRotation() {
        return this.descriptor.getRotation();
    }

    public synchronized void setRotation(TextDescriptor.Rotation r) {
        MutableTextDescriptor td = new MutableTextDescriptor(this.descriptor);
        td.setRotation(r);
        this.setTextDescriptor(td);
    }

    public TextDescriptor.DispPos getDispPart() {
        return this.descriptor.getDispPart();
    }

    public synchronized void setDispPart(TextDescriptor.DispPos d) {
        MutableTextDescriptor td = new MutableTextDescriptor(this.descriptor);
        td.setDispPart(d);
        this.setTextDescriptor(td);
    }

    public boolean isItalic() {
        return this.descriptor.isItalic();
    }

    public synchronized void setItalic(boolean state) {
        MutableTextDescriptor td = new MutableTextDescriptor(this.descriptor);
        td.setItalic(state);
        this.setTextDescriptor(td);
    }

    public boolean isBold() {
        return this.descriptor.isBold();
    }

    public synchronized void setBold(boolean state) {
        MutableTextDescriptor td = new MutableTextDescriptor(this.descriptor);
        td.setBold(state);
        this.setTextDescriptor(td);
    }

    public boolean isUnderline() {
        return this.descriptor.isUnderline();
    }

    public synchronized void setUnderline(boolean state) {
        MutableTextDescriptor td = new MutableTextDescriptor(this.descriptor);
        td.setUnderline(state);
        this.setTextDescriptor(td);
    }

    public boolean isInterior() {
        return this.descriptor.isInterior();
    }

    public synchronized void setInterior(boolean state) {
        MutableTextDescriptor td = new MutableTextDescriptor(this.descriptor);
        td.setInterior(state);
        this.setTextDescriptor(td);
    }

    public boolean isInherit() {
        return this.descriptor.isInherit();
    }

    public synchronized void setInherit(boolean state) {
        MutableTextDescriptor td = new MutableTextDescriptor(this.descriptor);
        td.setInherit(state);
        this.setTextDescriptor(td);
    }

    public boolean isParam() {
        NodeInst ni;
        if (this.descriptor.isParam()) {
            return true;
        }
        if (this.getOwner() instanceof NodeInst && (ni = (NodeInst)this.getOwner()).getProto() instanceof Cell) {
            Variable var;
            Cell icon = (Cell)ni.getProto();
            Cell sch = icon.contentsView();
            if (sch == null) {
                sch = icon;
            }
            if ((var = sch.getVar(this.key)) != null && var.descriptor.isParam()) {
                return true;
            }
        }
        return false;
    }

    public synchronized void setParam(boolean state) {
        MutableTextDescriptor td = new MutableTextDescriptor(this.descriptor);
        td.setParam(state);
        this.setTextDescriptor(td);
    }

    public synchronized double getXOff() {
        return this.descriptor.getXOff();
    }

    public synchronized double getYOff() {
        return this.descriptor.getYOff();
    }

    public synchronized void setOff(double xd, double yd) {
        MutableTextDescriptor td = new MutableTextDescriptor(this.descriptor);
        td.setOff(xd, yd);
        this.setTextDescriptor(td);
    }

    public TextDescriptor.Unit getUnit() {
        return this.descriptor.getUnit();
    }

    public synchronized void setUnit(TextDescriptor.Unit u) {
        MutableTextDescriptor td = new MutableTextDescriptor(this.descriptor);
        td.setUnit(u);
        this.setTextDescriptor(td);
    }

    public static class Key
    implements Comparable {
        private final String name;

        Key(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Key k) {
            return this.name.equals(k.getName());
        }

        public int compareTo(Object obj) {
            Key that = (Key)obj;
            return TextUtils.nameSameNumeric(this.name, that.name);
        }
    }
}

