/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.netlist;

import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.ncc.basic.NccUtils;
import com.sun.electric.tool.ncc.basic.Primes;
import com.sun.electric.tool.ncc.netlist.NccNameProxy;
import com.sun.electric.tool.ncc.netlist.Part;
import com.sun.electric.tool.ncc.netlist.PartType;
import com.sun.electric.tool.ncc.netlist.PartTypeTable;
import com.sun.electric.tool.ncc.netlist.PinType;
import com.sun.electric.tool.ncc.netlist.Wire;
import com.sun.electric.tool.ncc.trees.Circuit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class Mos
extends Part {
    public static final PartTypeTable TYPES = new PartTypeTable(new String[][]{{"NMOS", "N-Transistor"}, {"NMOS-VTH", "VTH-N-Transistor"}, {"NMOS-VTL", "VTL-N-Transistor"}, {"NMOS-OD18", "OD18-N-Transistor"}, {"NMOS-OD25", "OD25-N-Transistor"}, {"NMOS-OD33", "OD33-N-Transistor"}, {"NMOS-NT", "NT-N-Transistor"}, {"NMOS-NT-OD18", "NT-OD18-N-Transistor"}, {"NMOS-NT-OD25", "NT-OD25-N-Transistor"}, {"NMOS-NT-OD33", "NT-OD33-N-Transistor"}, {"PMOS", "P-Transistor"}, {"PMOS-VTH", "VTH-P-Transistor"}, {"PMOS-VTL", "VTL-P-Transistor"}, {"PMOS-OD18", "OD18-P-Transistor"}, {"PMOS-OD25", "OD25-P-Transistor"}, {"PMOS-OD33", "OD33-P-Transistor"}});
    private static final Map PIN_TYPE_SETS = new HashMap();
    private static final Map TYPE_TO_PINTYPE_ARRAY = new HashMap();
    private final int[] pin_coeffs;
    private double width;
    private final double length;
    private final PartType type;

    public synchronized Set getPinTypes() {
        PinTypeSetKey key = new PinTypeSetKey(this.type, this.isCapacitor(), this.numSeries());
        HashSet<PinType> pinTypes = (HashSet<PinType>)PIN_TYPE_SETS.get(key);
        if (pinTypes == null) {
            pinTypes = new HashSet<PinType>();
            pinTypes.add(new DiffType(this.type, this.numSeries(), this.isCapacitor()));
            int maxHeight = (this.numSeries() + 1) / 2;
            for (int gateHeight = 1; gateHeight <= maxHeight; ++gateHeight) {
                pinTypes.add(new GateType(this.type, this.numSeries(), gateHeight, this.isCapacitor()));
            }
            PIN_TYPE_SETS.put(key, pinTypes);
        }
        return pinTypes;
    }

    public synchronized PinType[] getPinTypeArray() {
        PinTypeSetKey key = new PinTypeSetKey(this.type, this.isCapacitor(), this.numSeries());
        PinType[] pinTypeArray = (PinType[])TYPE_TO_PINTYPE_ARRAY.get(key);
        if (pinTypeArray == null) {
            pinTypeArray = new PinType[this.pins.length];
            TYPE_TO_PINTYPE_ARRAY.put(key, pinTypeArray);
            DiffType diffType = new DiffType(this.type, this.numSeries(), this.isCapacitor());
            pinTypeArray[pinTypeArray.length - 1] = diffType;
            pinTypeArray[0] = diffType;
            int maxHeight = (this.numSeries() + 1) / 2;
            for (int gateHeight = 1; gateHeight <= maxHeight; ++gateHeight) {
                GateType gateType = new GateType(this.type, this.numSeries(), gateHeight, this.isCapacitor());
                pinTypeArray[pinTypeArray.length - 1 - gateHeight] = gateType;
                pinTypeArray[gateHeight] = gateType;
            }
        }
        return pinTypeArray;
    }

    public synchronized PinType getPinTypeOfNthPin(int n) {
        return this.getPinTypeArray()[n];
    }

    private Mos(PartType np, NccNameProxy.PartNameProxy name, double width, double length, Wire[] pins) {
        super(name, pins);
        this.type = np;
        this.width = width;
        this.length = length;
        LayoutLib.error(this.type == null, "null type?");
        this.pin_coeffs = CoeffGen.getCoeffArray(pins.length);
    }

    private boolean matchForward(Mos t) {
        for (int i = 0; i < this.pins.length; ++i) {
            if (this.pins[i] == t.pins[i]) continue;
            return false;
        }
        return true;
    }

    private boolean matchReverse(Mos t) {
        for (int i = 0; i < this.pins.length; ++i) {
            int j = this.pins.length - 1 - i;
            if (this.pins[i] == t.pins[j]) continue;
            return false;
        }
        return true;
    }

    private boolean samePinsAs(Mos t) {
        if (this.pins.length != t.pins.length) {
            return false;
        }
        return this.matchForward(t) || this.matchReverse(t);
    }

    private void flip() {
        for (int i = 0; i < this.pins.length / 2; ++i) {
            int j = this.pins.length - 1 - i;
            Wire w = this.pins[i];
            this.pins[i] = this.pins[j];
            this.pins[j] = w;
        }
    }

    private Wire hiDiff() {
        return this.pins[this.pins.length - 1];
    }

    private Wire loDiff() {
        return this.pins[0];
    }

    public Mos(PartType np, NccNameProxy.PartNameProxy name, double width, double length, Wire src, Wire gate, Wire drn) {
        this(np, name, width, length, new Wire[]{src, gate, drn});
    }

    public PartType getType() {
        return this.type;
    }

    public double getLength() {
        return this.length;
    }

    public double getWidth() {
        return this.width;
    }

    public int numSeries() {
        return this.pins.length - 2;
    }

    public int[] getPinCoeffs() {
        return this.pin_coeffs;
    }

    private boolean touchesSomeGate(Wire w) {
        for (int i = 1; i < this.pins.length - 1; ++i) {
            if (w != this.pins[i]) continue;
            return true;
        }
        return false;
    }

    public boolean touchesOneDiffPinAndNoOtherPins(Wire w) {
        return w == this.pins[0] ^ w == this.pins[this.pins.length - 1] && !this.touchesSomeGate(w);
    }

    public boolean isCapacitor() {
        return this.pins[0] == this.pins[this.pins.length - 1];
    }

    public Integer hashCodeForParallelMerge() {
        int hc = this.pins.length;
        for (int i = 0; i < this.pins.length; ++i) {
            hc += this.pins[i].hashCode() * this.pin_coeffs[i];
        }
        hc += this.getClass().hashCode();
        return new Integer(hc += this.type.hashCode());
    }

    public boolean parallelMerge(Part p) {
        if (!(p instanceof Mos)) {
            return false;
        }
        Mos t = (Mos)p;
        if (this == t) {
            return false;
        }
        if (!this.isLike(t)) {
            return false;
        }
        if (!this.samePinsAs(t)) {
            return false;
        }
        this.width += t.width;
        t.setDeleted();
        return true;
    }

    public int typeCode() {
        int tw = 4;
        return 1 + ((this.isCapacitor() ? 1 : 0) << 4) + (this.type.getOrdinal() << 5) + (this.numSeries() << 5 + TYPES.log2NumTypes());
    }

    public String typeString() {
        String t = this.type.getName();
        String c = this.isCapacitor() ? "_CAP" : "";
        String h = this.pins.length == 3 ? "" : "_" + (this.pins.length - 2) + "stack";
        return t + c + h;
    }

    public String valueDescription() {
        return "W=" + NccUtils.round(this.width, 2) + " L=" + NccUtils.round(this.length, 2);
    }

    public String connectionDescription(int n) {
        String msg = "";
        for (int i = 0; i < this.pins.length; ++i) {
            msg = i == 0 ? msg + "S=" : (i == this.pins.length - 1 ? msg + " D=" : (this.pins.length == 3 ? msg + " G=" : msg + " G" + i + "="));
            msg = msg + this.pins[i].getName();
        }
        return msg;
    }

    public String connectionDescription(Wire w) {
        String s = "";
        for (int i = 0; i < this.pins.length; ++i) {
            if (this.pins[i] != w) continue;
            if (s.length() != 0) {
                s = s + ",";
            }
            s = i == 0 ? s + "S" : (i == this.pins.length - 1 ? s + "D" : (this.pins.length == 3 ? s + "G" : s + "G" + i));
        }
        return s;
    }

    public boolean isLike(Mos t) {
        return this.type == t.type && this.length == t.length;
    }

    public static boolean joinOnWire(Wire w) {
        if (w.isDeleted()) {
            return false;
        }
        if (w.getPort() != null) {
            return false;
        }
        HashSet<Mos> trans = new HashSet<Mos>();
        Iterator it = w.getParts();
        while (it.hasNext()) {
            Part p = (Part)it.next();
            if (p.isDeleted()) continue;
            if (!(p instanceof Mos)) {
                return false;
            }
            Mos t = (Mos)p;
            if (!t.touchesOneDiffPinAndNoOtherPins(w)) {
                return false;
            }
            trans.add(t);
            if (trans.size() <= 2) continue;
            return false;
        }
        if (trans.size() != 2) {
            return false;
        }
        it = trans.iterator();
        Mos ta = (Mos)it.next();
        Mos tb = (Mos)it.next();
        Mos.error(ta.getParent() != tb.getParent(), "mismatched parents?");
        if (!ta.isLike(tb)) {
            return false;
        }
        if (ta.width != tb.width) {
            return false;
        }
        if (ta.hiDiff() != w) {
            ta.flip();
        }
        if (tb.loDiff() != w) {
            tb.flip();
        }
        Mos.error(ta.hiDiff() != w || tb.loDiff() != w, "joinOnWire: diffusion connections corrupted");
        Wire[] mergedPins = new Wire[ta.pins.length + tb.pins.length - 2];
        for (int aNdx = 0; aNdx < ta.pins.length - 1; ++aNdx) {
            mergedPins[aNdx] = ta.pins[aNdx];
        }
        for (int bNdx = 1; bNdx < tb.pins.length; ++bNdx) {
            mergedPins[aNdx++] = tb.pins[bNdx];
        }
        Mos stack = new Mos(ta.getType(), ta.getNameProxy(), ta.getWidth(), ta.getLength(), mergedPins);
        Circuit parent = tb.getParent();
        parent.adopt(stack);
        ta.setDeleted();
        tb.setDeleted();
        w.setDeleted();
        return true;
    }

    public Integer computeHashCode() {
        int sumLo = 0;
        int sumHi = 0;
        for (int i = 0; i < (this.pins.length + 1) / 2; ++i) {
            sumLo += this.pins[i].getCode() * this.pin_coeffs[i];
            int j = this.pins.length - 1 - i;
            sumHi += this.pins[j].getCode() * this.pin_coeffs[j];
        }
        return new Integer(sumLo * sumHi);
    }

    private static class CoeffGen {
        private static ArrayList coeffArrays = new ArrayList();

        private CoeffGen() {
        }

        private static void ensureListEntry(int numPins) {
            while (coeffArrays.size() - 1 < numPins) {
                coeffArrays.add(null);
            }
        }

        public static int[] getCoeffArray(int numPins) {
            CoeffGen.ensureListEntry(numPins);
            int[] coeffArray = (int[])coeffArrays.get(numPins);
            if (coeffArray == null) {
                coeffArray = new int[numPins];
                for (int i = 0; i < (numPins + 1) / 2; ++i) {
                    int j = numPins - 1 - i;
                    int nthPrime = 30 + i + numPins;
                    coeffArray[i] = coeffArray[j] = Primes.get(nthPrime);
                }
                coeffArrays.set(numPins, coeffArray);
            }
            return coeffArray;
        }
    }

    private static class PinTypeSetKey {
        private PartType type;
        private boolean isCapacitor;
        private int numSeries;

        public PinTypeSetKey(PartType type, boolean isCapacitor, int numSeries) {
            this.type = type;
            this.isCapacitor = isCapacitor;
            this.numSeries = numSeries;
        }

        public boolean equals(Object o) {
            if (!(o instanceof PinTypeSetKey)) {
                return false;
            }
            PinTypeSetKey p = (PinTypeSetKey)o;
            return this.type == p.type && this.isCapacitor == p.isCapacitor && this.numSeries == p.numSeries;
        }

        public int hashCode() {
            return this.type.hashCode() + (this.isCapacitor ? 1 : 0) + (this.numSeries << 1);
        }
    }

    private static class DiffType
    implements PinType {
        private final int numSeries;
        private final PartType np;
        private final boolean cap;

        public int numConnectionsToPinOfThisType(Part p, Wire w) {
            if (!(p instanceof Mos)) {
                return 0;
            }
            Mos t = (Mos)p;
            if (t.getType() != this.np) {
                return 0;
            }
            if (t.numSeries() != this.numSeries) {
                return 0;
            }
            if (this.cap != t.isCapacitor()) {
                return 0;
            }
            int count = 0;
            if (t.pins[0] == w) {
                ++count;
            }
            if (t.pins[this.numSeries + 1] == w) {
                ++count;
            }
            return count;
        }

        public String description() {
            String t = this.np.getName();
            String c = this.cap ? "_CAP" : "";
            String h = this.numSeries == 1 ? "" : "_" + this.numSeries + "stack";
            return t + c + h + " diffusion";
        }

        public DiffType(PartType np, int numSeries, boolean cap) {
            LayoutLib.error(np == null, "null type?");
            LayoutLib.error(numSeries < 1, "bad numSeries");
            int highestGateInLowerHalfOfStack = (numSeries + 1) / 2;
            this.np = np;
            this.numSeries = numSeries;
            this.cap = cap;
        }
    }

    private static class GateType
    implements PinType {
        private final int numSeries;
        private final PartType np;
        private final int gateHeight;
        private final boolean cap;

        public int numConnectionsToPinOfThisType(Part p, Wire w) {
            if (!(p instanceof Mos)) {
                return 0;
            }
            Mos t = (Mos)p;
            if (t.getType() != this.np) {
                return 0;
            }
            if (t.numSeries() != this.numSeries) {
                return 0;
            }
            if (this.cap != t.isCapacitor()) {
                return 0;
            }
            int loGate = this.gateHeight;
            int hiGate = this.numSeries + 1 - this.gateHeight;
            int numPins = this.numSeries + 2;
            int count = 0;
            if (t.pins[loGate] == w) {
                ++count;
            }
            if (loGate != hiGate && t.pins[hiGate] == w) {
                ++count;
            }
            return count;
        }

        public String description() {
            String t = this.np.getName();
            String c = this.cap ? "_CAP" : "";
            String h = this.numSeries == 1 ? "" : "_" + this.numSeries + "stack";
            int hiGate = this.numSeries + 1 - this.gateHeight;
            String g = "";
            if (this.numSeries > 2) {
                g = this.gateHeight + (this.gateHeight == hiGate ? "" : "/" + hiGate);
            }
            return t + c + h + " gate" + g;
        }

        public GateType(PartType np, int numSeries, int gateHeight, boolean cap) {
            LayoutLib.error(np == null, "null type?");
            LayoutLib.error(numSeries < 1, "bad numSeries");
            int highestGateInLowerHalfOfStack = (numSeries + 1) / 2;
            LayoutLib.error(gateHeight > highestGateInLowerHalfOfStack, "bad gate Height");
            this.np = np;
            this.numSeries = numSeries;
            this.gateHeight = gateHeight;
            this.cap = cap;
        }
    }
}

