/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ui;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.cvspm.AddRemove;
import com.sun.electric.tool.cvspm.CVS;
import com.sun.electric.tool.cvspm.CVSLibrary;
import com.sun.electric.tool.cvspm.Commit;
import com.sun.electric.tool.cvspm.Edit;
import com.sun.electric.tool.cvspm.Log;
import com.sun.electric.tool.cvspm.State;
import com.sun.electric.tool.cvspm.Update;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.io.input.EpicAnalysis;
import com.sun.electric.tool.project.AddCellJob;
import com.sun.electric.tool.project.AddLibraryJob;
import com.sun.electric.tool.project.CancelCheckOutJob;
import com.sun.electric.tool.project.CheckInJob;
import com.sun.electric.tool.project.CheckOutJob;
import com.sun.electric.tool.project.DeleteCellJob;
import com.sun.electric.tool.project.HistoryDialog;
import com.sun.electric.tool.project.Project;
import com.sun.electric.tool.project.UpdateJob;
import com.sun.electric.tool.simulation.AnalogSignal;
import com.sun.electric.tool.simulation.Analysis;
import com.sun.electric.tool.simulation.Signal;
import com.sun.electric.tool.user.CellChangeJobs;
import com.sun.electric.tool.user.CircuitChangeJobs;
import com.sun.electric.tool.user.CircuitChanges;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.tool.user.Resources;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.ViewChanges;
import com.sun.electric.tool.user.dialogs.ChangeCellGroup;
import com.sun.electric.tool.user.dialogs.ChangeCurrentLib;
import com.sun.electric.tool.user.dialogs.NewCell;
import com.sun.electric.tool.user.menus.CellMenu;
import com.sun.electric.tool.user.menus.FileMenu;
import com.sun.electric.tool.user.tecEdit.Manipulate;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.ErrorLoggerTree;
import com.sun.electric.tool.user.ui.ExplorerTreeModel;
import com.sun.electric.tool.user.ui.JobTree;
import com.sun.electric.tool.user.ui.PaletteFrame;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowFrame;
import com.sun.electric.tool.user.waveform.Panel;
import com.sun.electric.tool.user.waveform.SweepSignal;
import com.sun.electric.tool.user.waveform.WaveformWindow;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.TransferHandler;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.TreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class ExplorerTree
extends JTree
implements DragSourceListener {
    private static final TreePath[] NULL_TREE_PATH_ARRAY = new TreePath[0];
    private TreeHandler handler = null;
    private final String rootNode;
    private TreePath[] currentSelectedPaths = new TreePath[0];
    private static ImageIcon iconLibrary = null;
    private static ImageIcon iconLibraryNormal = null;
    private static ImageIcon iconLibraryChecked = null;
    private static ImageIcon iconGroup = null;
    private static ImageIcon iconJobs = null;
    private static ImageIcon iconLibraries = null;
    private static ImageIcon iconErrors = null;
    private static ImageIcon iconErrorMsg = null;
    private static ImageIcon iconWarnMsg = null;
    private static ImageIcon iconSignals = null;
    private static ImageIcon iconSweeps = null;
    private static ImageIcon iconMeasurements = null;
    private static ImageIcon iconViewMultiPageSchematics = null;
    private static ImageIcon iconSpiderWeb = null;
    private static ImageIcon iconLocked = null;
    private static ImageIcon iconUnlocked = null;
    private static ImageIcon iconAvailable = null;
    private ExplorerTreeDropTarget dropTarget;
    private Point dragOffset;
    private BufferedImage dragImage;
    private boolean subCells;

    ExplorerTree(List<MutableTreeNode> contentNodes) {
        super((TreeModel)null);
        this.setModel(new ExplorerTreeModel());
        this.rootNode = "Explorer";
        this.redoContentTrees(contentNodes);
        this.initDND();
        this.expandPath(new TreePath(this.model().jobPath));
        this.getSelectionModel().setSelectionMode(4);
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.setToggleClickCount(3);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setCellRenderer(new MyRenderer());
        this.handler = new TreeHandler();
        this.addMouseListener(this.handler);
        this.addTreeSelectionListener(this.handler);
    }

    public Object[] getCurrentlySelectedObject() {
        Object[] selectedObjects = new Object[this.numCurrentlySelectedObjects()];
        for (int i = 0; i < selectedObjects.length; ++i) {
            selectedObjects[i] = this.getCurrentlySelectedObject(i);
        }
        return selectedObjects;
    }

    public int numCurrentlySelectedObjects() {
        return this.currentSelectedPaths.length;
    }

    public Object getCurrentlySelectedObject(int i) {
        EpicAnalysis.EpicSignal sig;
        if (i >= this.currentSelectedPaths.length) {
            return null;
        }
        TreePath treePath = this.currentSelectedPaths[i];
        if (treePath == null) {
            return null;
        }
        Object obj = treePath.getLastPathComponent();
        if (obj instanceof DefaultMutableTreeNode) {
            return ((DefaultMutableTreeNode)obj).getUserObject();
        }
        if (obj instanceof EpicAnalysis.EpicTreeNode && (sig = EpicAnalysis.getSignal(treePath)) != null) {
            return sig;
        }
        return obj;
    }

    public List<Library> getCurrentlySelectedLibraries() {
        ArrayList<Library> libs = new ArrayList<Library>();
        for (int i = 0; i < this.numCurrentlySelectedObjects(); ++i) {
            Object obj = this.getCurrentlySelectedObject(i);
            if (!(obj instanceof Library)) continue;
            libs.add((Library)obj);
        }
        return libs;
    }

    public List<Cell> getCurrentlySelectedCells() {
        ArrayList<Cell> cells = new ArrayList<Cell>();
        for (int i = 0; i < this.numCurrentlySelectedObjects(); ++i) {
            Object obj = this.getCurrentlySelectedObject(i);
            if (obj instanceof Cell) {
                cells.add((Cell)obj);
            }
            if (!(obj instanceof Cell.CellGroup)) continue;
            Cell.CellGroup group = (Cell.CellGroup)obj;
            Iterator<Cell> it = group.getCells();
            while (it.hasNext()) {
                cells.add(it.next());
            }
        }
        return cells;
    }

    public void clearCurrentlySelectedObjects() {
        this.currentSelectedPaths = NULL_TREE_PATH_ARRAY;
    }

    public ExplorerTreeModel model() {
        return (ExplorerTreeModel)this.treeModel;
    }

    void openLibraryInExplorerTree(Library lib, Cell cell, boolean openLib) {
        int count = -1;
        this.openLibraryInExplorerTree(lib, cell, new TreePath(this.rootNode), openLib, count);
    }

    private int countChildrenAndExpandInPath(Cell cell, TreeModel treeModel, TreePath path, Object node, int count) {
        int numChildren = treeModel.getChildCount(node);
        for (int i = 0; i < numChildren; ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)treeModel.getChild(node, i);
            ++count;
            Object obj = child.getUserObject();
            if (obj == cell) {
                return count;
            }
            if (treeModel.getChildCount(child) > 0 && obj instanceof Cell && ((Cell)obj).getCellGroup() == cell.getCellGroup()) {
                TreePath descentPath = path.pathByAddingChild(child);
                this.expandPath(descentPath);
                return this.countChildrenAndExpandInPath(cell, treeModel, descentPath, child, count);
            }
            if (obj != cell.getCellGroup()) continue;
            TreePath descentPath = path.pathByAddingChild(child);
            this.expandPath(descentPath);
            return this.countChildrenAndExpandInPath(cell, treeModel, descentPath, child, count);
        }
        return count;
    }

    private boolean openLibraryInExplorerTree(Library library, Cell cell, TreePath path, boolean openLib, int count) {
        String msg;
        int numChildren;
        ExplorerTreeModel treeModel = this.model();
        Object node = path.getLastPathComponent();
        Object obj = node;
        if (obj instanceof DefaultMutableTreeNode) {
            obj = ((DefaultMutableTreeNode)obj).getUserObject();
        }
        if ((numChildren = treeModel.getChildCount(node)) == 0) {
            return false;
        }
        if (openLib && obj instanceof Library) {
            Library lib = (Library)obj;
            if (lib == library) {
                this.expandPath(path);
                if (cell != null) {
                    count = this.countChildrenAndExpandInPath(cell, treeModel, path, node, count);
                }
                this.setSelectionRow(count);
                return true;
            }
        } else if (obj instanceof String && ((msg = (String)obj).equalsIgnoreCase("libraries") && openLib || msg.equalsIgnoreCase("signals") && !openLib)) {
            this.expandPath(path);
        }
        for (int i = 0; i < numChildren; ++i) {
            TreePath descentPath;
            Object child = treeModel.getChild(node, i);
            if (!(child instanceof DefaultMutableTreeNode) || (descentPath = path.pathByAddingChild(child)) == null || !this.openLibraryInExplorerTree(library, cell, descentPath, openLib, ++count)) continue;
            return true;
        }
        return false;
    }

    void redoContentTrees(List<MutableTreeNode> contentNodes) {
        assert (SwingUtilities.isEventDispatchThread());
        ArrayList<TreePath> expanded = new ArrayList<TreePath>();
        this.recursivelyCacheExpandedPaths(expanded, new TreePath(this.rootNode));
        this.model().updateContentExplorerNodes(contentNodes);
        this.expandCachedPaths(expanded);
    }

    private void recursivelyCacheExpandedPaths(ArrayList<TreePath> expanded, TreePath path) {
        Object node = path.getLastPathComponent();
        if (!this.isExpanded(path)) {
            return;
        }
        expanded.add(path);
        for (int i = 0; i < this.treeModel.getChildCount(node); ++i) {
            TreePath descentPath;
            Object child = this.treeModel.getChild(node, i);
            if (this.treeModel.isLeaf(child) || (descentPath = path.pathByAddingChild(child)) == null) continue;
            this.recursivelyCacheExpandedPaths(expanded, descentPath);
        }
    }

    private void expandCachedPaths(ArrayList<TreePath> expanded) {
        for (TreePath path : expanded) {
            this.expandCachedPath(path);
        }
    }

    private void expandCachedPath(TreePath oldPath) {
        Object[] path = oldPath.getPath();
        TreePath newPath = new TreePath(this.rootNode);
        String topNode = this.rootNode;
        for (int i = 1; i < path.length; ++i) {
            int k;
            Object oldChild = path[i];
            Object newChild = null;
            if (oldChild instanceof DefaultMutableTreeNode) {
                newChild = this.findChildByUserObject(topNode, ((DefaultMutableTreeNode)oldChild).getUserObject());
            }
            if (newChild == null && (k = this.treeModel.getIndexOfChild(topNode, oldChild)) >= 0) {
                newChild = this.treeModel.getChild(topNode, k);
            }
            if (newChild == null) {
                return;
            }
            topNode = newChild;
            newPath = newPath.pathByAddingChild(topNode);
            this.expandPath(newPath);
        }
    }

    private Object findChildByUserObject(Object parent, Object userObject) {
        int childCount = this.treeModel.getChildCount(parent);
        for (int i = 0; i < childCount; ++i) {
            Object newChild = this.treeModel.getChild(parent, i);
            if (!(newChild instanceof DefaultMutableTreeNode) || !((DefaultMutableTreeNode)newChild).getUserObject().equals(userObject)) continue;
            return newChild;
        }
        return null;
    }

    @Override
    public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (!(value instanceof DefaultMutableTreeNode)) {
            return value.toString();
        }
        Object nodeInfo = ((DefaultMutableTreeNode)value).getUserObject();
        if (nodeInfo instanceof Cell) {
            Cell cell = (Cell)nodeInfo;
            if (cell.isLinked() && cell.isSchematic()) {
                Cell.CellGroup group = cell.getCellGroup();
                Cell mainSchematic = group.getMainSchematics();
                int numSchematics = 0;
                Iterator<Cell> gIt = group.getCells();
                while (gIt.hasNext()) {
                    Cell cellInGroup = gIt.next();
                    if (!cellInGroup.isSchematic()) continue;
                    ++numSchematics;
                }
                if (numSchematics > 1 && cell == mainSchematic) {
                    return cell.noLibDescribe() + " **";
                }
            }
            return cell.noLibDescribe();
        }
        if (nodeInfo instanceof Library) {
            Library lib = (Library)nodeInfo;
            String nodeName = lib.getName();
            if (lib == Library.getCurrent() && Library.getNumLibraries() > 1) {
                nodeName = nodeName + " [Current]";
                if (iconLibraryChecked == null) {
                    iconLibraryChecked = Resources.getResource(this.getClass(), "IconLibraryCheck.gif");
                }
                iconLibrary = iconLibraryChecked;
            } else {
                if (iconLibraryNormal == null) {
                    iconLibraryNormal = Resources.getResource(this.getClass(), "IconLibrary.gif");
                }
                iconLibrary = iconLibraryNormal;
            }
            return nodeName;
        }
        if (nodeInfo instanceof Cell.CellGroup) {
            Cell.CellGroup group = (Cell.CellGroup)nodeInfo;
            return group.getName();
        }
        if (nodeInfo instanceof ErrorLoggerTree.ErrorLoggerTreeNode) {
            ErrorLoggerTree.ErrorLoggerTreeNode node = (ErrorLoggerTree.ErrorLoggerTreeNode)nodeInfo;
            ErrorLogger el = node.getLogger();
            String s = el.getSystem();
            if (ErrorLoggerTree.currentLogger != null && node == ErrorLoggerTree.currentLogger.getUserObject()) {
                s = s + " [Current]";
            }
            return s;
        }
        if (nodeInfo instanceof ErrorLogger.MessageLog) {
            ErrorLogger.MessageLog el = (ErrorLogger.MessageLog)nodeInfo;
            return el.getMessage();
        }
        if (nodeInfo instanceof Signal) {
            Signal sig = (Signal)nodeInfo;
            return sig.getSignalName();
        }
        if (nodeInfo == null) {
            return "";
        }
        return nodeInfo.toString();
    }

    private void initDND() {
        this.setTransferHandler(new MyTransferHandler(this.getTransferHandler(), this));
        this.setDragEnabled(true);
        this.dropTarget = new ExplorerTreeDropTarget();
        new DropTarget(this, 0x40000000, this.dropTarget, true);
    }

    @Override
    public void setUI(TreeUI ui) {
        super.setUI(ui);
        try {
            Class<?> clazz = Class.forName("javax.swing.plaf.basic.BasicDragGestureRecognizer");
            MouseListener[] mouseListeners = this.getMouseListeners();
            MouseListener dragListener = null;
            for (int i = 0; i < mouseListeners.length; ++i) {
                if (!clazz.isAssignableFrom(mouseListeners[i].getClass())) continue;
                dragListener = mouseListeners[i];
                break;
            }
            if (dragListener != null) {
                this.removeMouseListener(dragListener);
                this.removeMouseMotionListener((MouseMotionListener)((Object)dragListener));
                this.addMouseListener(dragListener);
                this.addMouseMotionListener((MouseMotionListener)((Object)dragListener));
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    @Override
    public void dragEnter(DragSourceDragEvent e) {
    }

    @Override
    public void dragOver(DragSourceDragEvent e) {
    }

    @Override
    public void dragExit(DragSourceEvent e) {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent e) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent e) {
    }

    static /* synthetic */ TreePath[] access$202(ExplorerTree x0, TreePath[] x1) {
        x0.currentSelectedPaths = x1;
        return x1;
    }

    private class TreeHandler
    implements MouseListener,
    MouseMotionListener,
    TreeSelectionListener {
        private boolean draggingCell;
        private MouseEvent currentMouseEvent;
        private TreePath[] currentPaths;
        private TreePath[] originalPaths;

        private TreeHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.draggingCell = false;
            if (e.isPopupTrigger()) {
                this.selectTreeElement(e.getX(), e.getY());
                this.cacheEvent(e);
                this.doContextMenu();
                return;
            }
            this.cacheEvent(e);
            WindowFrame wf = WindowFrame.getCurrentWindowFrame();
            if (e.getClickCount() == 2) {
                Cell cell;
                boolean didSomething = false;
                for (int i = 0; i < ExplorerTree.this.numCurrentlySelectedObjects(); ++i) {
                    if (ExplorerTree.this.getCurrentlySelectedObject(i) instanceof Signal) {
                        Signal sig = (Signal)ExplorerTree.this.getCurrentlySelectedObject(i);
                        if (wf.getContent() instanceof WaveformWindow) {
                            WaveformWindow ww = (WaveformWindow)wf.getContent();
                            ww.addSignal(sig);
                        }
                        didSomething = true;
                    }
                    if (!(ExplorerTree.this.getCurrentlySelectedObject(i) instanceof SweepSignal)) continue;
                    SweepSignal ss = (SweepSignal)ExplorerTree.this.getCurrentlySelectedObject(i);
                    if (ss == null) {
                        return;
                    }
                    ss.setIncluded(!ss.isIncluded(), true);
                    ExplorerTree.this.updateUI();
                    didSomething = true;
                }
                if (didSomething) {
                    return;
                }
                if (ExplorerTree.this.numCurrentlySelectedObjects() == 0) {
                    return;
                }
                if (ExplorerTree.this.numCurrentlySelectedObjects() != 1) {
                    Job.getUserInterface().showErrorMessage("Must select just one entry in the explorer tree", "Too Much Selected");
                    return;
                }
                Object nodeObj = ExplorerTree.this.getCurrentlySelectedObject(0);
                if (nodeObj instanceof ExplorerTreeModel.CellAndCount) {
                    ExplorerTreeModel.CellAndCount cc = (ExplorerTreeModel.CellAndCount)nodeObj;
                    wf.setCellWindow(cc.getCell(), null);
                    return;
                }
                if (nodeObj instanceof Cell) {
                    cell = (Cell)nodeObj;
                    wf.setCellWindow(cell, null);
                    return;
                }
                if (nodeObj instanceof ExplorerTreeModel.MultiPageCell) {
                    ExplorerTreeModel.MultiPageCell mpc = (ExplorerTreeModel.MultiPageCell)nodeObj;
                    Cell cell2 = mpc.getCell();
                    wf.setCellWindow(cell2, null);
                    if (wf.getContent() instanceof EditWindow) {
                        EditWindow wnd = (EditWindow)wf.getContent();
                        wnd.setMultiPageNumber(mpc.getPageNo());
                    }
                    return;
                }
                if (nodeObj instanceof Library || nodeObj instanceof Cell.CellGroup || nodeObj instanceof String || nodeObj instanceof ErrorLoggerTree.ErrorLoggerTreeNode) {
                    for (int i = 0; i < this.currentPaths.length; ++i) {
                        if (ExplorerTree.this.isExpanded(this.currentPaths[i])) {
                            ExplorerTree.this.collapsePath(this.currentPaths[i]);
                            continue;
                        }
                        ExplorerTree.this.expandPath(this.currentPaths[i]);
                    }
                    return;
                }
                if (nodeObj instanceof JobTree.JobTreeNode) {
                    System.out.println(((JobTree.JobTreeNode)nodeObj).getInfo());
                    return;
                }
                if (nodeObj instanceof ErrorLogger.MessageLog) {
                    ErrorLogger.MessageLog el = (ErrorLogger.MessageLog)nodeObj;
                    String msg = Job.getUserInterface().reportLog(el, true, null);
                    System.out.println(msg);
                    return;
                }
                if (nodeObj instanceof Cell && (cell = (Cell)nodeObj).getNewestVersion() == cell) {
                    this.originalPaths = new TreePath[this.currentPaths.length];
                    for (int i = 0; i < this.currentPaths.length; ++i) {
                        this.originalPaths[i] = new TreePath(this.currentPaths[i].getPath());
                    }
                    this.draggingCell = true;
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.selectTreeElement(e.getX(), e.getY());
                this.cacheEvent(e);
                this.doContextMenu();
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            int i;
            if (!this.draggingCell) {
                return;
            }
            this.cacheEvent(e);
            ExplorerTree.this.clearSelection();
            for (i = 0; i < this.originalPaths.length; ++i) {
                ExplorerTree.this.addSelectionPath(this.originalPaths[i]);
            }
            for (i = 0; i < this.currentPaths.length; ++i) {
                ExplorerTree.this.addSelectionPath(this.currentPaths[i]);
            }
            ExplorerTree.this.updateUI();
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            this.currentPaths = ExplorerTree.this.getSelectionPaths();
            if (this.currentPaths == null) {
                this.currentPaths = new TreePath[0];
            }
            ExplorerTree.access$202(ExplorerTree.this, new TreePath[this.currentPaths.length]);
            for (int i = 0; i < this.currentPaths.length; ++i) {
                ((ExplorerTree)ExplorerTree.this).currentSelectedPaths[i] = this.currentPaths[i];
            }
            Iterator<WindowFrame> it = WindowFrame.getWindows();
            while (it.hasNext()) {
                WindowFrame wf = it.next();
                if (wf.getExplorerTab() != ExplorerTree.this || !(wf.getContent() instanceof WaveformWindow)) continue;
                WaveformWindow ww = (WaveformWindow)wf.getContent();
                ww.crossProbeWaveformToEditWindow();
            }
        }

        private void selectTreeElement(int x, int y) {
            TreePath cp = ExplorerTree.this.getPathForLocation(x, y);
            if (cp != null) {
                Object obj = cp.getLastPathComponent();
                if (obj instanceof DefaultMutableTreeNode) {
                    obj = ((DefaultMutableTreeNode)obj).getUserObject();
                }
                boolean selected = false;
                for (int i = 0; i < ExplorerTree.this.numCurrentlySelectedObjects(); ++i) {
                    if (ExplorerTree.this.getCurrentlySelectedObject(i) != obj) continue;
                    selected = true;
                    break;
                }
                if (!selected) {
                    ExplorerTree.access$202(ExplorerTree.this, new TreePath[1]);
                    ((ExplorerTree)ExplorerTree.this).currentSelectedPaths[0] = cp;
                    ExplorerTree.this.clearSelection();
                    ExplorerTree.this.addSelectionPath(cp);
                    ExplorerTree.this.updateUI();
                }
            }
        }

        private void cacheEvent(MouseEvent e) {
            this.currentMouseEvent = e;
        }

        private void doContextMenu() {
            JMenuItem menuItem;
            JPopupMenu menu;
            JMenuItem menuItem2;
            Object selectedObject = null;
            boolean allSame = true;
            for (int i = 0; i < ExplorerTree.this.numCurrentlySelectedObjects(); ++i) {
                Object obj = ExplorerTree.this.getCurrentlySelectedObject(i);
                if (obj == null) continue;
                if (selectedObject == null) {
                    selectedObject = obj;
                    continue;
                }
                Class<?> clz = selectedObject.getClass();
                if (clz.isInstance(obj)) continue;
                allSame = false;
            }
            if (allSame && selectedObject instanceof SweepSignal) {
                JPopupMenu menu2 = new JPopupMenu("Sweep Signal");
                menuItem2 = new JMenuItem("Include");
                menu2.add(menuItem2);
                menuItem2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TreeHandler.this.setSweepAction(true);
                    }
                });
                menuItem2 = new JMenuItem("Exclude");
                menu2.add(menuItem2);
                menuItem2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TreeHandler.this.setSweepAction(false);
                    }
                });
                menuItem2 = new JMenuItem("Highlight");
                menu2.add(menuItem2);
                menuItem2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TreeHandler.this.highlightSweepAction();
                    }
                });
                menu2.show((Component)this.currentMouseEvent.getSource(), this.currentMouseEvent.getX(), this.currentMouseEvent.getY());
                return;
            }
            if (allSame && selectedObject instanceof Signal) {
                JPopupMenu menu3 = new JPopupMenu("Signals");
                menuItem2 = new JMenuItem("Add to current panel");
                menu3.add(menuItem2);
                menuItem2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TreeHandler.this.addToWaveform(false);
                    }
                });
                menuItem2 = new JMenuItem("Add in new panel");
                menu3.add(menuItem2);
                menuItem2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TreeHandler.this.addToWaveform(true);
                    }
                });
                menu3.show((Component)this.currentMouseEvent.getSource(), this.currentMouseEvent.getX(), this.currentMouseEvent.getY());
                return;
            }
            if (allSame && ExplorerTree.this.numCurrentlySelectedObjects() > 1) {
                if (selectedObject instanceof ExplorerTreeModel.CellAndCount) {
                    ExplorerTreeModel.CellAndCount cc = (ExplorerTreeModel.CellAndCount)selectedObject;
                    selectedObject = cc.getCell();
                }
                if (selectedObject instanceof Cell) {
                    Cell cell = (Cell)selectedObject;
                    menu = new JPopupMenu("Cell");
                    menuItem = new JMenuItem("Delete Cell");
                    menu.add(menuItem);
                    menuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            TreeHandler.this.deleteCellAction();
                        }
                    });
                    JMenu subMenu = new JMenu("Change View");
                    menu.add(subMenu);
                    for (View view : View.getOrderedViews()) {
                        if (cell.getView() == view) continue;
                        JMenuItem subMenuItem = new JMenuItem(view.getFullName());
                        subMenu.add(subMenuItem);
                        subMenuItem.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                TreeHandler.this.reViewCellAction(e);
                            }
                        });
                    }
                    menuItem = new JMenuItem("Change Cell Group...");
                    menu.add(menuItem);
                    menuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            TreeHandler.this.changeCellGroupAction();
                        }
                    });
                    if (CVS.isEnabled()) {
                        JMenu cvsMenu = new JMenu("CVS");
                        menu.add(cvsMenu);
                        this.addCVSMenu(cvsMenu);
                    }
                    menu.show((Component)this.currentMouseEvent.getSource(), this.currentMouseEvent.getX(), this.currentMouseEvent.getY());
                    return;
                }
            }
            if (ExplorerTree.this.numCurrentlySelectedObjects() > 1 && CVS.isEnabled() && (ExplorerTree.this.getCurrentlySelectedLibraries().size() > 0 || ExplorerTree.this.getCurrentlySelectedCells().size() > 0)) {
                JPopupMenu menu4 = new JPopupMenu("CVS");
                JMenu cvsMenu = new JMenu("CVS");
                menu4.add(cvsMenu);
                this.addCVSMenu(cvsMenu);
                menu4.show((Component)this.currentMouseEvent.getSource(), this.currentMouseEvent.getX(), this.currentMouseEvent.getY());
                return;
            }
            if (selectedObject instanceof JobTree.JobTreeNode) {
                JobTree.JobTreeNode job = (JobTree.JobTreeNode)selectedObject;
                JPopupMenu popup = JobTree.getPopupStatus(job);
                popup.show((Component)this.currentMouseEvent.getSource(), this.currentMouseEvent.getX(), this.currentMouseEvent.getY());
                return;
            }
            if (selectedObject instanceof ExplorerTreeModel.CellAndCount) {
                ExplorerTreeModel.CellAndCount cc = (ExplorerTreeModel.CellAndCount)selectedObject;
                selectedObject = cc.getCell();
            }
            if (selectedObject instanceof Cell) {
                Cell cell = (Cell)selectedObject;
                menu = new JPopupMenu("Cell");
                menuItem = new JMenuItem("Edit");
                menu.add(menuItem);
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TreeHandler.this.editCellAction(false);
                    }
                });
                menuItem = new JMenuItem("Edit in New Window");
                menu.add(menuItem);
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TreeHandler.this.editCellAction(true);
                    }
                });
                int projStatus = Project.getCellStatus(cell);
                if (projStatus != 4 && (projStatus != 0 || Project.isLibraryManaged(cell.getLibrary()))) {
                    menu.addSeparator();
                    if (projStatus == 1) {
                        menuItem = new JMenuItem("Check Out");
                        menu.add(menuItem);
                        menuItem.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                CheckOutJob.checkOut((Cell)ExplorerTree.this.getCurrentlySelectedObject(0));
                            }
                        });
                    }
                    if (projStatus == 2) {
                        menuItem = new JMenuItem("Check In...");
                        menu.add(menuItem);
                        menuItem.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                CheckInJob.checkIn((Cell)ExplorerTree.this.getCurrentlySelectedObject(0));
                            }
                        });
                        menuItem = new JMenuItem("Rollback and Release Check-Out");
                        menu.add(menuItem);
                        menuItem.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                CancelCheckOutJob.cancelCheckOut((Cell)ExplorerTree.this.getCurrentlySelectedObject(0));
                            }
                        });
                    }
                    if (projStatus == 0) {
                        menuItem = new JMenuItem("Add To Repository");
                        menu.add(menuItem);
                        menuItem.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                AddCellJob.addCell((Cell)ExplorerTree.this.getCurrentlySelectedObject(0));
                            }
                        });
                    } else {
                        menuItem = new JMenuItem("Show History of This Cell...");
                        menu.add(menuItem);
                        menuItem.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                HistoryDialog.examineHistory((Cell)ExplorerTree.this.getCurrentlySelectedObject(0));
                            }
                        });
                    }
                    if (projStatus == 1 || projStatus == 2) {
                        menuItem = new JMenuItem("Remove From Repository");
                        menu.add(menuItem);
                        menuItem.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                DeleteCellJob.removeCell((Cell)ExplorerTree.this.getCurrentlySelectedObject(0));
                            }
                        });
                    }
                }
                menu.addSeparator();
                menuItem = new JMenuItem("Place Instance of Cell");
                menu.add(menuItem);
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TreeHandler.this.newCellInstanceAction();
                    }
                });
                menuItem = new JMenuItem("Create New Cell");
                menu.add(menuItem);
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TreeHandler.this.newCellAction();
                    }
                });
                menu.addSeparator();
                menuItem = new JMenuItem("Create New Version of Cell");
                menu.add(menuItem);
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TreeHandler.this.newCellVersionAction();
                    }
                });
                menuItem = new JMenuItem("Duplicate Cell");
                menu.add(menuItem);
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TreeHandler.this.duplicateCellAction();
                    }
                });
                menuItem = new JMenuItem("Delete Cell");
                menu.add(menuItem);
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TreeHandler.this.deleteCellAction();
                    }
                });
                menu.addSeparator();
                menuItem = new JMenuItem("Rename Cell");
                menu.add(menuItem);
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TreeHandler.this.renameCellAction();
                    }
                });
                JMenu subMenu = new JMenu("Change View");
                menu.add(subMenu);
                for (View view : View.getOrderedViews()) {
                    if (cell.getView() == view) continue;
                    JMenuItem subMenuItem = new JMenuItem(view.getFullName());
                    subMenu.add(subMenuItem);
                    subMenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            TreeHandler.this.reViewCellAction(e);
                        }
                    });
                }
                if (CVS.isEnabled()) {
                    menu.addSeparator();
                    JMenu cvsMenu = new JMenu("CVS");
                    menu.add(cvsMenu);
                    this.addCVSMenu(cvsMenu);
                }
                menu.addSeparator();
                menuItem = new JMenuItem("Change Cell Group...");
                menu.add(menuItem);
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TreeHandler.this.changeCellGroupAction();
                    }
                });
                menu.show((Component)this.currentMouseEvent.getSource(), this.currentMouseEvent.getX(), this.currentMouseEvent.getY());
                return;
            }
            if (selectedObject instanceof ExplorerTreeModel.MultiPageCell) {
                JPopupMenu menu5 = new JPopupMenu("Cell");
                menuItem2 = new JMenuItem("Edit");
                menu5.add(menuItem2);
                menuItem2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TreeHandler.this.editCellAction(false);
                    }
                });
                menuItem2 = new JMenuItem("Edit in New Window");
                menu5.add(menuItem2);
                menuItem2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TreeHandler.this.editCellAction(true);
                    }
                });
                menu5.addSeparator();
                menuItem2 = new JMenuItem("Make New Page");
                menu5.add(menuItem2);
                menuItem2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TreeHandler.this.makeNewSchematicPage();
                    }
                });
                menuItem2 = new JMenuItem("Delete This Page");
                menu5.add(menuItem2);
                menuItem2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TreeHandler.this.deleteSchematicPage();
                    }
                });
                menu5.show((Component)this.currentMouseEvent.getSource(), this.currentMouseEvent.getX(), this.currentMouseEvent.getY());
                return;
            }
            if (selectedObject instanceof Library) {
                Library lib = (Library)selectedObject;
                menu = new JPopupMenu("Library");
                menuItem = new JMenuItem("Open");
                menu.add(menuItem);
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TreeHandler.this.openAction();
                    }
                });
                menuItem = new JMenuItem("Open all below here");
                menu.add(menuItem);
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TreeHandler.this.recursiveOpenAction();
                    }
                });
                menuItem = new JMenuItem("Close all below here");
                menu.add(menuItem);
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TreeHandler.this.recursiveCloseAction();
                    }
                });
                if (lib != Library.getCurrent()) {
                    menu.addSeparator();
                    menuItem = new JMenuItem("Make This the Current Library");
                    menu.add(menuItem);
                    menuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            TreeHandler.this.setCurLibAction();
                        }
                    });
                }
                menu.addSeparator();
                if (Project.isLibraryManaged(lib)) {
                    menuItem = new JMenuItem("Update from Repository");
                    menu.add(menuItem);
                    menuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            UpdateJob.updateProject();
                        }
                    });
                } else {
                    menuItem = new JMenuItem("Add to Project Management Repository");
                    menu.add(menuItem);
                    menuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            AddLibraryJob.addLibrary((Library)ExplorerTree.this.getCurrentlySelectedObject(0));
                        }
                    });
                }
                menu.addSeparator();
                menuItem = new JMenuItem("Create New Cell");
                menu.add(menuItem);
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TreeHandler.this.newCellAction();
                    }
                });
                menu.addSeparator();
                menuItem = new JMenuItem("Rename Library");
                menu.add(menuItem);
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TreeHandler.this.renameLibraryAction();
                    }
                });
                menuItem = new JMenuItem("Save Library");
                menu.add(menuItem);
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TreeHandler.this.saveLibraryAction();
                    }
                });
                menuItem = new JMenuItem("Close Library");
                menu.add(menuItem);
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TreeHandler.this.closeLibraryAction();
                    }
                });
                menuItem = new JMenuItem("Reload Library");
                menu.add(menuItem);
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TreeHandler.this.reloadLibraryAction();
                    }
                });
                if (CVS.isEnabled()) {
                    menu.addSeparator();
                    JMenu cvsMenu = new JMenu("CVS");
                    menu.add(cvsMenu);
                    this.addCVSMenu(cvsMenu);
                }
                menu.show((Component)this.currentMouseEvent.getSource(), this.currentMouseEvent.getX(), this.currentMouseEvent.getY());
                return;
            }
            if (selectedObject instanceof Cell.CellGroup) {
                JPopupMenu menu6 = new JPopupMenu("CellGroup");
                menuItem2 = new JMenuItem("Open");
                menu6.add(menuItem2);
                menuItem2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TreeHandler.this.openAction();
                    }
                });
                menuItem2 = new JMenuItem("Open all below here");
                menu6.add(menuItem2);
                menuItem2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TreeHandler.this.recursiveOpenAction();
                    }
                });
                menuItem2 = new JMenuItem("Close all below here");
                menu6.add(menuItem2);
                menuItem2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TreeHandler.this.recursiveCloseAction();
                    }
                });
                menu6.addSeparator();
                menuItem2 = new JMenuItem("Create New Cell");
                menu6.add(menuItem2);
                menuItem2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TreeHandler.this.newCellAction();
                    }
                });
                menu6.addSeparator();
                menuItem2 = new JMenuItem("Rename Cells in Group");
                menu6.add(menuItem2);
                menuItem2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TreeHandler.this.renameGroupAction();
                    }
                });
                menuItem2 = new JMenuItem("Duplicate Cells in Group");
                menu6.add(menuItem2);
                menuItem2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TreeHandler.this.duplicateGroupAction();
                    }
                });
                if (CVS.isEnabled()) {
                    menu6.addSeparator();
                    JMenu cvsMenu = new JMenu("CVS");
                    menu6.add(cvsMenu);
                    this.addCVSMenu(cvsMenu);
                }
                menu6.show((Component)this.currentMouseEvent.getSource(), this.currentMouseEvent.getX(), this.currentMouseEvent.getY());
                return;
            }
            if (selectedObject instanceof String) {
                String msg = (String)selectedObject;
                if (msg.toLowerCase().endsWith("sweeps")) {
                    menu = new JPopupMenu("All Sweeps");
                    menuItem = new JMenuItem("Include All");
                    menu.add(menuItem);
                    menuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            TreeHandler.this.setAllSweepsAction(true);
                        }
                    });
                    menuItem = new JMenuItem("Exclude All");
                    menu.add(menuItem);
                    menuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            TreeHandler.this.setAllSweepsAction(false);
                        }
                    });
                    menuItem = new JMenuItem("Remove Highlighting");
                    menu.add(menuItem);
                    menuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            TreeHandler.this.removeSweepHighlighting();
                        }
                    });
                    menu.show((Component)this.currentMouseEvent.getSource(), this.currentMouseEvent.getX(), this.currentMouseEvent.getY());
                    return;
                }
                if (msg.equalsIgnoreCase("errors")) {
                    menu = new JPopupMenu("Errors");
                    menuItem = new JMenuItem("Delete All");
                    menu.add(menuItem);
                    menuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            ErrorLoggerTree.deleteAllLoggers();
                        }
                    });
                    menuItem = new JMenuItem("Load Logger");
                    menu.add(menuItem);
                    menuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            ErrorLoggerTree.load();
                        }
                    });
                    menu.show((Component)this.currentMouseEvent.getSource(), this.currentMouseEvent.getX(), this.currentMouseEvent.getY());
                    return;
                }
                if (msg.equalsIgnoreCase("libraries")) {
                    menu = new JPopupMenu("Libraries");
                    menuItem = new JMenuItem("Open");
                    menu.add(menuItem);
                    menuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            TreeHandler.this.openAction();
                        }
                    });
                    menuItem = new JMenuItem("Open all below here");
                    menu.add(menuItem);
                    menuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            TreeHandler.this.recursiveOpenAction();
                        }
                    });
                    menuItem = new JMenuItem("Close all below here");
                    menu.add(menuItem);
                    menuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            TreeHandler.this.recursiveCloseAction();
                        }
                    });
                    menu.addSeparator();
                    menuItem = new JMenuItem("Create New Cell");
                    menu.add(menuItem);
                    menuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            TreeHandler.this.newCellAction();
                        }
                    });
                    menu.addSeparator();
                    menuItem = new JMenuItem("Show Cells Alphabetically");
                    menu.add(menuItem);
                    menuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            ExplorerTreeModel.showAlphabeticallyAction();
                        }
                    });
                    menuItem = new JMenuItem("Show Cells by Group");
                    menu.add(menuItem);
                    menuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            ExplorerTreeModel.showByGroupAction();
                        }
                    });
                    menuItem = new JMenuItem("Show Cells by Hierarchy");
                    menu.add(menuItem);
                    menuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            ExplorerTreeModel.showByHierarchyAction();
                        }
                    });
                    menu.addSeparator();
                    menuItem = new JMenuItem("Search");
                    menu.add(menuItem);
                    menuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            TreeHandler.this.searchAction();
                        }
                    });
                    menu.show((Component)this.currentMouseEvent.getSource(), this.currentMouseEvent.getX(), this.currentMouseEvent.getY());
                    return;
                }
                if (msg.equalsIgnoreCase("TECHNOLOGY LAYERS")) {
                    menu = new JPopupMenu("Technology Layers");
                    menuItem = new JMenuItem("Add New Layer");
                    menu.add(menuItem);
                    menuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            Manipulate.makeCell(1);
                        }
                    });
                    menuItem = new JMenuItem("Reorder Layers");
                    menu.add(menuItem);
                    menuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            Manipulate.reorderPrimitives(1);
                        }
                    });
                    menu.show((Component)this.currentMouseEvent.getSource(), this.currentMouseEvent.getX(), this.currentMouseEvent.getY());
                    return;
                }
                if (msg.equalsIgnoreCase("TECHNOLOGY ARCS")) {
                    menu = new JPopupMenu("Technology Arcs");
                    menuItem = new JMenuItem("Add New Arc");
                    menu.add(menuItem);
                    menuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            Manipulate.makeCell(2);
                        }
                    });
                    menuItem = new JMenuItem("Reorder Arcs");
                    menu.add(menuItem);
                    menuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            Manipulate.reorderPrimitives(2);
                        }
                    });
                    menu.show((Component)this.currentMouseEvent.getSource(), this.currentMouseEvent.getX(), this.currentMouseEvent.getY());
                    return;
                }
                if (msg.equalsIgnoreCase("TECHNOLOGY NODES")) {
                    menu = new JPopupMenu("Technology Nodes");
                    menuItem = new JMenuItem("Add New Node");
                    menu.add(menuItem);
                    menuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            Manipulate.makeCell(3);
                        }
                    });
                    menuItem = new JMenuItem("Reorder Nodes");
                    menu.add(menuItem);
                    menuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            Manipulate.reorderPrimitives(3);
                        }
                    });
                    menu.show((Component)this.currentMouseEvent.getSource(), this.currentMouseEvent.getX(), this.currentMouseEvent.getY());
                    return;
                }
            }
            if (selectedObject instanceof ErrorLoggerTree.ErrorLoggerTreeNode) {
                ErrorLoggerTree.ErrorLoggerTreeNode logger = (ErrorLoggerTree.ErrorLoggerTreeNode)selectedObject;
                JPopupMenu p = ErrorLoggerTree.getPopupMenu(logger);
                if (p != null) {
                    p.show((Component)this.currentMouseEvent.getSource(), this.currentMouseEvent.getX(), this.currentMouseEvent.getY());
                }
                return;
            }
        }

        private void openAction() {
            for (int i = 0; i < this.currentPaths.length; ++i) {
                ExplorerTree.this.expandPath(this.currentPaths[i]);
            }
        }

        private void recursiveOpenAction() {
            for (int i = 0; i < this.currentPaths.length; ++i) {
                this.recursivelyOpen(this.currentPaths[i]);
            }
        }

        private void recursivelyOpen(TreePath path) {
            ExplorerTree.this.expandPath(path);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            int numChildren = node.getChildCount();
            for (int i = 0; i < numChildren; ++i) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
                TreePath descentPath = path.pathByAddingChild(child);
                this.recursivelyOpen(descentPath);
            }
        }

        private void recursiveCloseAction() {
            for (int i = 0; i < this.currentPaths.length; ++i) {
                this.recursivelyClose(this.currentPaths[i]);
            }
        }

        private void recursivelyClose(TreePath path) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            int numChildren = node.getChildCount();
            for (int i = 0; i < numChildren; ++i) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
                TreePath descentPath = path.pathByAddingChild(child);
                this.recursivelyClose(descentPath);
            }
            ExplorerTree.this.collapsePath(path);
        }

        private void setCurLibAction() {
            Library lib = (Library)ExplorerTree.this.getCurrentlySelectedObject(0);
            lib.setCurrent();
            ChangeCurrentLib.repaintAllAfterCurLibAction();
        }

        private void renameLibraryAction() {
            Library lib = (Library)ExplorerTree.this.getCurrentlySelectedObject(0);
            CircuitChanges.renameLibrary(lib);
        }

        private void saveLibraryAction() {
            Library lib = (Library)ExplorerTree.this.getCurrentlySelectedObject(0);
            FileMenu.saveLibraryCommand(lib, FileType.DEFAULTLIB, false, true, false);
        }

        private void closeLibraryAction() {
            Library lib = (Library)ExplorerTree.this.getCurrentlySelectedObject(0);
            FileMenu.closeLibraryCommand(lib);
        }

        private void reloadLibraryAction() {
            Library lib = (Library)ExplorerTree.this.getCurrentlySelectedObject(0);
            new CircuitChangeJobs.ReloadLibraryJob(lib);
        }

        private void renameGroupAction() {
            String response;
            Cell.CellGroup cellGroup = (Cell.CellGroup)ExplorerTree.this.getCurrentlySelectedObject(0);
            String defaultName = "";
            if (cellGroup.getNumCells() > 0) {
                defaultName = cellGroup.getCells().next().getName();
            }
            if ((response = JOptionPane.showInputDialog(ExplorerTree.this, "New name for cells in this group", defaultName)) == null) {
                return;
            }
            CircuitChanges.renameCellGroupInJob(cellGroup, response);
        }

        private void duplicateGroupAction() {
            Cell.CellGroup cellGroup = (Cell.CellGroup)ExplorerTree.this.getCurrentlySelectedObject(0);
            Cell cell = null;
            Iterator<WindowFrame> it = WindowFrame.getWindows();
            while (it.hasNext()) {
                WindowFrame wf = it.next();
                if (!cellGroup.containsCell(wf.getContent().getCell())) continue;
                cell = wf.getContent().getCell();
                break;
            }
            if (cell == null) {
                cell = cellGroup.getCells().next();
            }
            CellMenu.duplicateCell(cell, true);
        }

        private void editCellAction(boolean newWindow) {
            Cell cell = null;
            int pageNo = 1;
            if (ExplorerTree.this.getCurrentlySelectedObject(0) instanceof Cell) {
                cell = (Cell)ExplorerTree.this.getCurrentlySelectedObject(0);
            } else if (ExplorerTree.this.getCurrentlySelectedObject(0) instanceof ExplorerTreeModel.MultiPageCell) {
                ExplorerTreeModel.MultiPageCell mpc = (ExplorerTreeModel.MultiPageCell)ExplorerTree.this.getCurrentlySelectedObject(0);
                cell = mpc.getCell();
                pageNo = mpc.getPageNo();
            }
            WindowFrame wf = null;
            wf = newWindow ? WindowFrame.createEditWindow(cell) : WindowFrame.getCurrentWindowFrame();
            wf.setCellWindow(cell, null);
            if (cell.isMultiPage() && wf.getContent() instanceof EditWindow) {
                EditWindow wnd = (EditWindow)wf.getContent();
                wnd.setMultiPageNumber(pageNo);
            }
        }

        private void newCellInstanceAction() {
            Cell cell = (Cell)ExplorerTree.this.getCurrentlySelectedObject(0);
            if (cell == null) {
                return;
            }
            PaletteFrame.placeInstance(cell, null, false);
        }

        private void newCellAction() {
            TopLevel jf = TopLevel.getCurrentJFrame();
            NewCell dialog = new NewCell((Frame)jf, true);
            assert (!Job.BATCHMODE);
            dialog.setVisible(true);
        }

        private void addToWaveform(boolean newPanel) {
            WindowFrame wf = WindowFrame.getCurrentWindowFrame();
            if (!(wf.getContent() instanceof WaveformWindow)) {
                return;
            }
            WaveformWindow ww = (WaveformWindow)wf.getContent();
            Signal[] sigs = new Signal[ExplorerTree.this.numCurrentlySelectedObjects()];
            for (int i = 0; i < ExplorerTree.this.numCurrentlySelectedObjects(); ++i) {
                Signal sig;
                sigs[i] = sig = (Signal)ExplorerTree.this.getCurrentlySelectedObject(i);
            }
            ww.showSignals(sigs, newPanel);
        }

        private void setSweepAction(boolean include) {
            for (int i = 0; i < ExplorerTree.this.numCurrentlySelectedObjects(); ++i) {
                SweepSignal ss = (SweepSignal)ExplorerTree.this.getCurrentlySelectedObject(i);
                if (ss == null) continue;
                boolean update = i == ExplorerTree.this.numCurrentlySelectedObjects() - 1;
                ss.setIncluded(include, update);
            }
            ExplorerTree.this.updateUI();
        }

        private void highlightSweepAction() {
            for (int i = 0; i < ExplorerTree.this.numCurrentlySelectedObjects(); ++i) {
                SweepSignal ss = (SweepSignal)ExplorerTree.this.getCurrentlySelectedObject(i);
                if (ss == null) continue;
                ss.highlight();
            }
            ExplorerTree.this.updateUI();
        }

        private void setAllSweepsAction(boolean include) {
            if (this.currentPaths.length != 1) {
                return;
            }
            TreePath path = this.currentPaths[0];
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            int numChildren = node.getChildCount();
            ArrayList<SweepSignal> sweeps = new ArrayList<SweepSignal>();
            for (int i = 0; i < numChildren; ++i) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
                TreePath descentPath = path.pathByAddingChild(child);
                Object obj = descentPath.getLastPathComponent();
                SweepSignal ss = (SweepSignal)((DefaultMutableTreeNode)obj).getUserObject();
                sweeps.add(ss);
            }
            WindowFrame wf = WindowFrame.getCurrentWindowFrame();
            if (wf == null) {
                return;
            }
            if (wf.getContent() instanceof WaveformWindow) {
                WaveformWindow ww = (WaveformWindow)wf.getContent();
                ww.setIncludeInAllSweeps(sweeps, include);
            }
            ExplorerTree.this.updateUI();
        }

        private void removeSweepHighlighting() {
            WindowFrame wf = WindowFrame.getCurrentWindowFrame();
            if (wf == null) {
                return;
            }
            if (wf.getContent() instanceof WaveformWindow) {
                WaveformWindow ww = (WaveformWindow)wf.getContent();
                ww.setHighlightedSweep(-1);
                Iterator<Panel> it = ww.getPanels();
                while (it.hasNext()) {
                    Panel wp = it.next();
                    wp.repaintWithRulers();
                }
            }
            ExplorerTree.this.updateUI();
        }

        private void newCellVersionAction() {
            Cell cell = (Cell)ExplorerTree.this.getCurrentlySelectedObject(0);
            CircuitChanges.newVersionOfCell(cell);
        }

        private void duplicateCellAction() {
            Cell cell = (Cell)ExplorerTree.this.getCurrentlySelectedObject(0);
            CellMenu.duplicateCell(cell, false);
        }

        private void deleteCellAction() {
            ArrayList<Cell> cellsToDelete = new ArrayList<Cell>();
            for (int i = 0; i < ExplorerTree.this.numCurrentlySelectedObjects(); ++i) {
                Cell cell = (Cell)ExplorerTree.this.getCurrentlySelectedObject(i);
                cellsToDelete.add(cell);
            }
            boolean confirm = true;
            if (cellsToDelete.size() > 1) {
                String confirmMsg = "Are you sure you want to delete cells";
                for (Cell cell : cellsToDelete) {
                    confirmMsg = confirmMsg + " " + cell.describe(false);
                }
                int response = JOptionPane.showConfirmDialog(TopLevel.getCurrentJFrame(), confirmMsg + "?", "Delete Cells Dialog", 0);
                if (response != 0) {
                    return;
                }
                confirm = false;
            }
            for (Cell cell : cellsToDelete) {
                CircuitChanges.deleteCell(cell, confirm, false);
            }
        }

        private void renameCellAction() {
            Cell cell = (Cell)ExplorerTree.this.getCurrentlySelectedObject(0);
            String response = JOptionPane.showInputDialog(ExplorerTree.this, "New name for " + cell, cell.getName());
            if (response == null) {
                return;
            }
            CircuitChanges.renameCellInJob(cell, response);
        }

        private void reViewCellAction(ActionEvent e) {
            JMenuItem menuItem = (JMenuItem)e.getSource();
            String viewName = menuItem.getText();
            View newView = View.findView(viewName);
            if (newView != null) {
                ArrayList<Cell> cellsToReview = new ArrayList<Cell>();
                for (int i = 0; i < ExplorerTree.this.numCurrentlySelectedObjects(); ++i) {
                    Cell cell = (Cell)ExplorerTree.this.getCurrentlySelectedObject(i);
                    cellsToReview.add(cell);
                }
                for (Cell cell : cellsToReview) {
                    ViewChanges.changeCellView(cell, newView);
                }
            }
        }

        private void changeCellGroupAction() {
            ArrayList<Cell> cellsToChange = new ArrayList<Cell>();
            Library lib = null;
            for (int i = 0; i < ExplorerTree.this.numCurrentlySelectedObjects(); ++i) {
                Cell cell = (Cell)ExplorerTree.this.getCurrentlySelectedObject(i);
                if (lib == null) {
                    lib = cell.getLibrary();
                } else if (lib != cell.getLibrary()) {
                    Job.getUserInterface().showErrorMessage("All Cells to be regrouped must be in the same library", "Cannot Regroup These Cells");
                    return;
                }
                cellsToChange.add(cell);
            }
            if (cellsToChange.size() == 0) {
                return;
            }
            ChangeCellGroup dialog = new ChangeCellGroup((Frame)TopLevel.getCurrentJFrame(), true, cellsToChange, lib);
            assert (!Job.BATCHMODE);
            dialog.setVisible(true);
        }

        private void makeNewSchematicPage() {
            ExplorerTreeModel.MultiPageCell mpc = (ExplorerTreeModel.MultiPageCell)ExplorerTree.this.getCurrentlySelectedObject(0);
            Cell cell = mpc.getCell();
            if (!cell.isMultiPage()) {
                System.out.println("First turn this cell into a multi-page schematic");
                return;
            }
            int numPages = cell.getNumMultiPages();
            new CellMenu.SetMultiPageJob(cell, numPages + 1);
            EditWindow wnd = EditWindow.needCurrent();
            if (wnd != null) {
                wnd.setMultiPageNumber(numPages);
            }
        }

        private void deleteSchematicPage() {
            ExplorerTreeModel.MultiPageCell mpc = (ExplorerTreeModel.MultiPageCell)ExplorerTree.this.getCurrentlySelectedObject(0);
            Cell cell = mpc.getCell();
            if (!cell.isMultiPage()) {
                return;
            }
            int numPages = cell.getNumMultiPages();
            if (numPages <= 1) {
                System.out.println("Cannot delete the last page of a multi-page schematic");
                return;
            }
            new CellMenu.DeleteMultiPageJob(cell, mpc.getPageNo());
        }

        private void searchAction() {
            String name = JOptionPane.showInputDialog(ExplorerTree.this, "Name of cell to search", "");
            if (name == null) {
                return;
            }
            System.out.println("Searching cell name like " + name);
            Cell cell = Library.findCellInLibraries(name, null, null);
            if (cell != null) {
                System.out.println("\t" + cell + " in " + cell.getLibrary());
            }
        }

        private void addCVSMenu(JMenu cvsMenu) {
            List<Library> libs = ExplorerTree.this.getCurrentlySelectedLibraries();
            List<Cell> cells = ExplorerTree.this.getCurrentlySelectedCells();
            TreeSet<State> states = new TreeSet<State>();
            for (Library lib : libs) {
                states.add(CVSLibrary.getState(lib));
            }
            for (Cell cell : cells) {
                states.add(CVSLibrary.getState(cell));
            }
            JMenuItem menuItem = new JMenuItem("Commit");
            cvsMenu.add(menuItem);
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TreeHandler.this.cvsCommit();
                }
            });
            menuItem.setEnabled(!states.contains(State.UNKNOWN));
            menuItem = new JMenuItem("Update");
            cvsMenu.add(menuItem);
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TreeHandler.this.cvsUpdate(0);
                }
            });
            menuItem.setEnabled(!states.contains(State.UNKNOWN));
            menuItem = new JMenuItem("Get Status");
            cvsMenu.add(menuItem);
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TreeHandler.this.cvsUpdate(1);
                }
            });
            menuItem.setEnabled(true);
            menuItem = new JMenuItem("List Editors");
            cvsMenu.add(menuItem);
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TreeHandler.this.cvsListEditors();
                }
            });
            menuItem.setEnabled(!states.contains(State.UNKNOWN));
            menuItem = new JMenuItem("Show Log");
            cvsMenu.add(menuItem);
            boolean showLog = false;
            if (libs.size() == 1 && cells.size() == 0) {
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TreeHandler.this.showLog(1);
                    }
                });
                showLog = true;
            }
            if (libs.size() == 0 && cells.size() == 1) {
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TreeHandler.this.showLog(0);
                    }
                });
                showLog = true;
            }
            menuItem.setEnabled(showLog && !states.contains(State.UNKNOWN));
            cvsMenu.addSeparator();
            menuItem = new JMenuItem("Rollback");
            cvsMenu.add(menuItem);
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TreeHandler.this.cvsUpdate(2);
                }
            });
            menuItem.setEnabled(!states.contains(State.UNKNOWN));
            menuItem = new JMenuItem("Add to CVS");
            cvsMenu.add(menuItem);
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TreeHandler.this.cvsAddRemove(true);
                }
            });
            menuItem.setEnabled(states.contains(State.UNKNOWN) || states.contains(State.REMOVED));
            if (libs.size() > 0 && cells.size() == 0) {
                menuItem = new JMenuItem("Remove from CVS");
                cvsMenu.add(menuItem);
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TreeHandler.this.cvsAddRemove(false);
                    }
                });
                menuItem.setEnabled(!states.contains(State.UNKNOWN));
            }
            menuItem = new JMenuItem("Undo CVS Add or Remove");
            cvsMenu.add(menuItem);
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TreeHandler.this.cvsUndoAddRemove();
                }
            });
            menuItem.setEnabled(false);
            menuItem.setEnabled(states.size() == 1 && (states.contains(State.ADDED) || states.contains(State.REMOVED)) || states.size() == 2 && states.contains(State.ADDED) && states.contains(State.REMOVED));
            menuItem = new JMenuItem("Rollforward");
            cvsMenu.add(menuItem);
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TreeHandler.this.cvsUpdate(3);
                }
            });
            menuItem.setEnabled(false);
        }

        private void cvsUpdate(int type) {
            List<Library> libs = ExplorerTree.this.getCurrentlySelectedLibraries();
            List<Cell> cells = ExplorerTree.this.getCurrentlySelectedCells();
            Update.update(libs, cells, type, false);
        }

        private void cvsListEditors() {
            List<Library> libs = ExplorerTree.this.getCurrentlySelectedLibraries();
            List<Cell> cells = ExplorerTree.this.getCurrentlySelectedCells();
            Edit.listEditors(libs, cells);
        }

        private void showLog(int type) {
            if (type == 1) {
                List<Library> libs = ExplorerTree.this.getCurrentlySelectedLibraries();
                Log.showLog(libs.get(0));
            }
            if (type == 0) {
                List<Cell> cells = ExplorerTree.this.getCurrentlySelectedCells();
                Log.showLog(cells.get(0));
            }
        }

        private void cvsCommit() {
            List<Library> libs = ExplorerTree.this.getCurrentlySelectedLibraries();
            List<Cell> cells = ExplorerTree.this.getCurrentlySelectedCells();
            Commit.commit(libs, cells);
        }

        private void cvsAddRemove(boolean add) {
            List<Library> libs = ExplorerTree.this.getCurrentlySelectedLibraries();
            List<Cell> cells = ExplorerTree.this.getCurrentlySelectedCells();
            AddRemove.addremove(libs, cells, add, false);
        }

        private void cvsUndoAddRemove() {
            List<Library> libs = ExplorerTree.this.getCurrentlySelectedLibraries();
            List<Cell> cells = ExplorerTree.this.getCurrentlySelectedCells();
            AddRemove.addremove(libs, cells, false, true);
        }
    }

    private class MyRenderer
    extends DefaultTreeCellRenderer {
        private Font plainFont;
        private Font boldFont;
        private Font italicFont;
        private HashMap<View, IconGroup> iconGroups = new HashMap();

        public MyRenderer() {
            this.plainFont = new Font("arial", 0, 11);
            this.boldFont = new Font("arial", 1, 11);
            this.italicFont = new Font("arial", 2, 11);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            this.setFont(this.plainFont);
            if (!(value instanceof DefaultMutableTreeNode)) {
                return this;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            Object nodeInfo = node.getUserObject();
            if (nodeInfo instanceof Library) {
                Library lib = (Library)nodeInfo;
                if (iconLibraryNormal == null) {
                    iconLibraryNormal = Resources.getResource(this.getClass(), "IconLibrary.gif");
                }
                if (iconLibrary == null) {
                    iconLibrary = iconLibraryNormal;
                }
                if (lib.isChanged()) {
                    this.setFont(this.boldFont);
                }
                if (CVS.isEnabled()) {
                    this.setForeground(CVSLibrary.getColor(lib));
                }
                this.setIcon(iconLibrary);
            }
            if (nodeInfo instanceof ExplorerTreeModel.CellAndCount) {
                ExplorerTreeModel.CellAndCount cc = (ExplorerTreeModel.CellAndCount)nodeInfo;
                nodeInfo = cc.getCell();
                if (cc.getCell().isModified(true)) {
                    this.setFont(this.boldFont);
                } else if (cc.getCell().isModified(false)) {
                    this.setFont(this.italicFont);
                }
            }
            if (nodeInfo instanceof Cell) {
                Cell cell = (Cell)nodeInfo;
                if (cell.isModified(true)) {
                    this.setFont(this.boldFont);
                } else if (cell.isModified(false)) {
                    this.setFont(this.italicFont);
                }
                if (CVS.isEnabled()) {
                    this.setForeground(CVSLibrary.getColor(cell));
                }
                IconGroup ig = cell.isIcon() ? this.findIconGroup(View.ICON) : (cell.getView() == View.LAYOUT ? this.findIconGroup(View.LAYOUT) : (cell.isSchematic() ? this.findIconGroup(View.SCHEMATIC) : (cell.getView().isTextView() ? this.findIconGroup(View.DOC) : this.findIconGroup(View.UNKNOWN))));
                if (cell.getNewestVersion() != cell) {
                    this.setIcon(ig.old);
                } else {
                    switch (Project.getCellStatus(cell)) {
                        case 0: {
                            this.setIcon(ig.regular);
                            break;
                        }
                        case 1: {
                            this.setIcon(ig.available);
                            break;
                        }
                        case 3: {
                            this.setIcon(ig.locked);
                            break;
                        }
                        case 2: {
                            this.setIcon(ig.unlocked);
                        }
                    }
                }
            }
            if (nodeInfo instanceof ExplorerTreeModel.MultiPageCell) {
                if (iconViewMultiPageSchematics == null) {
                    iconViewMultiPageSchematics = Resources.getResource(this.getClass(), "IconViewMultiPageSchematics.gif");
                }
                this.setIcon(iconViewMultiPageSchematics);
            }
            if (nodeInfo instanceof Cell.CellGroup) {
                Cell.CellGroup cg = (Cell.CellGroup)nodeInfo;
                int status = -1;
                Iterator<Cell> it = cg.getCells();
                while (status != 1 && it.hasNext()) {
                    Cell c = it.next();
                    if (c.isModified(true)) {
                        status = 1;
                        break;
                    }
                    if (!c.isModified(false)) continue;
                    status = 0;
                }
                if (status == 1) {
                    this.setFont(this.boldFont);
                } else if (status == 0) {
                    this.setFont(this.italicFont);
                }
                if (CVS.isEnabled()) {
                    this.setForeground(CVSLibrary.getColor(cg));
                }
                if (iconGroup == null) {
                    iconGroup = Resources.getResource(this.getClass(), "IconGroup.gif");
                }
                this.setIcon(iconGroup);
            }
            if (nodeInfo instanceof String) {
                String theString = (String)nodeInfo;
                if (theString.equalsIgnoreCase("jobs")) {
                    if (iconJobs == null) {
                        iconJobs = Resources.getResource(this.getClass(), "IconJobs.gif");
                    }
                    this.setIcon(iconJobs);
                } else if (theString.equalsIgnoreCase("libraries")) {
                    if (iconLibraries == null) {
                        iconLibraries = Resources.getResource(this.getClass(), "IconLibraries.gif");
                    }
                    this.setIcon(iconLibraries);
                } else if (theString.equalsIgnoreCase("errors")) {
                    if (iconErrors == null) {
                        iconErrors = Resources.getResource(this.getClass(), "IconErrors.gif");
                    }
                    this.setIcon(iconErrors);
                } else if (theString.equalsIgnoreCase("signals") || theString.equalsIgnoreCase("trans signals") || theString.equalsIgnoreCase("ac signals") || theString.equalsIgnoreCase("dc signals")) {
                    if (iconSignals == null) {
                        iconSignals = Resources.getResource(this.getClass(), "IconSignals.gif");
                    }
                    this.setIcon(iconSignals);
                } else if (theString.equalsIgnoreCase("sweeps") || theString.equalsIgnoreCase("trans sweeps") || theString.equalsIgnoreCase("ac sweeps") || theString.equalsIgnoreCase("dc sweeps")) {
                    if (iconSweeps == null) {
                        iconSweeps = Resources.getResource(this.getClass(), "IconSweeps.gif");
                    }
                    this.setIcon(iconSweeps);
                } else if (theString.equalsIgnoreCase("measurements")) {
                    if (iconMeasurements == null) {
                        iconMeasurements = Resources.getResource(this.getClass(), "IconMeasurement.gif");
                    }
                    this.setIcon(iconMeasurements);
                }
            }
            if (nodeInfo instanceof ErrorLogger.MessageLog) {
                ErrorLogger.MessageLog theLog = (ErrorLogger.MessageLog)nodeInfo;
                if (theLog instanceof ErrorLogger.WarningLog) {
                    if (iconWarnMsg == null) {
                        iconWarnMsg = Resources.getResource(this.getClass(), "IconWarningLog.gif");
                    }
                    this.setIcon(iconWarnMsg);
                } else {
                    if (iconErrorMsg == null) {
                        iconErrorMsg = Resources.getResource(this.getClass(), "IconErrorLog.gif");
                    }
                    this.setIcon(iconErrorMsg);
                }
            }
            if (nodeInfo instanceof JobTree.JobTreeNode) {
                // empty if block
            }
            return this;
        }

        private IconGroup findIconGroup(View view) {
            IconGroup ig = this.iconGroups.get(view);
            if (ig == null) {
                ig = new IconGroup();
                if (view == View.LAYOUT) {
                    ig.regular = Resources.getResource(this.getClass(), "IconViewLayout.gif");
                } else if (view == View.SCHEMATIC) {
                    ig.regular = Resources.getResource(this.getClass(), "IconViewSchematics.gif");
                } else if (view == View.ICON) {
                    ig.regular = Resources.getResource(this.getClass(), "IconViewIcon.gif");
                } else if (view == View.DOC) {
                    ig.regular = Resources.getResource(this.getClass(), "IconViewText.gif");
                } else {
                    ig.regular = Resources.getResource(this.getClass(), "IconViewMisc.gif");
                }
                if (iconSpiderWeb == null) {
                    iconSpiderWeb = Resources.getResource(this.getClass(), "IconSpiderWeb.gif");
                }
                if (iconLocked == null) {
                    iconLocked = Resources.getResource(this.getClass(), "IconLocked.gif");
                }
                if (iconUnlocked == null) {
                    iconUnlocked = Resources.getResource(this.getClass(), "IconUnlocked.gif");
                }
                if (iconAvailable == null) {
                    iconAvailable = Resources.getResource(this.getClass(), "IconAvailable.gif");
                }
                ig.old = this.buildIcon(iconSpiderWeb, ig.regular);
                ig.available = this.buildIcon(iconAvailable, ig.regular);
                ig.locked = this.buildIcon(iconLocked, ig.regular);
                ig.unlocked = this.buildIcon(iconUnlocked, ig.regular);
                this.iconGroups.put(view, ig);
            }
            return ig;
        }

        private ImageIcon buildIcon(ImageIcon fg, ImageIcon bg) {
            int wid = fg.getIconWidth();
            int hei = fg.getIconHeight();
            BufferedImage bi = new BufferedImage(wid, hei, 1);
            int[] backgroundValues = new int[wid * hei];
            PixelGrabber background = new PixelGrabber(bg.getImage(), 0, 0, wid, hei, backgroundValues, 0, wid);
            int[] foregroundValues = new int[wid * hei];
            PixelGrabber foreground = new PixelGrabber(fg.getImage(), 0, 0, wid, hei, foregroundValues, 0, wid);
            try {
                background.grabPixels();
                foreground.grabPixels();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            for (int y = 0; y < hei; ++y) {
                for (int x = 0; x < wid; ++x) {
                    int bCol = backgroundValues[y * wid + x];
                    int fCol = foregroundValues[y * wid + x];
                    if ((fCol & 0xFFFFFF) != 0xFFFFFF) {
                        bCol = fCol;
                    }
                    bi.setRGB(x, y, bCol);
                }
            }
            return new ImageIcon(bi);
        }
    }

    private static class CrossLibraryCopyJob
    extends Job {
        private Cell fromCell;
        private Library toLibrary;
        private boolean copyRelated;
        private boolean copySubs;

        private CrossLibraryCopyJob(Cell fromCell, Library toLibrary, boolean copyRelated, boolean copySubs) {
            super("Cross-Library copy", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.fromCell = fromCell;
            this.toLibrary = toLibrary;
            this.copyRelated = copyRelated;
            this.copySubs = copySubs;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            ArrayList<Cell> fromCells = new ArrayList<Cell>();
            fromCells.add(this.fromCell);
            CellChangeJobs.copyRecursively(fromCells, this.toLibrary, true, false, this.copyRelated, this.copySubs, true);
            return true;
        }
    }

    private static class ExplorerTreeDropTarget
    implements DropTargetListener {
        private Rectangle lastDrawn = null;

        private ExplorerTreeDropTarget() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent e) {
            this.dragAction(e);
        }

        @Override
        public void dragOver(DropTargetDragEvent e) {
            TreePath cp;
            Library destLib;
            DropTarget dt = (DropTarget)e.getSource();
            ExplorerTree tree = (ExplorerTree)dt.getComponent();
            Graphics2D g2 = (Graphics2D)tree.getGraphics();
            this.eraseDragImage(dt);
            Object obj = this.getDraggedObject(e.getCurrentDataFlavors());
            ExplorerTree originalTree = this.getOriginalTree(e.getCurrentDataFlavors());
            if (originalTree == null) {
                return;
            }
            if (obj instanceof Cell.CellGroup) {
                obj = ((Cell.CellGroup)obj).getCells().next();
            }
            if (!(obj instanceof Cell)) {
                return;
            }
            Cell origCell = (Cell)obj;
            if (!DragSource.isDragImageSupported()) {
                this.lastDrawn = new Rectangle(e.getLocation().x - ((ExplorerTree)originalTree).dragOffset.x, e.getLocation().y - ((ExplorerTree)originalTree).dragOffset.y, originalTree.dragImage.getWidth(), originalTree.dragImage.getHeight());
                g2.drawImage(originalTree.dragImage, AffineTransform.getTranslateInstance(this.lastDrawn.getX(), this.lastDrawn.getY()), null);
            }
            if ((destLib = this.findLibrary(cp = tree.getPathForLocation(e.getLocation().x, e.getLocation().y))) == null) {
                return;
            }
            if (destLib == origCell.getLibrary()) {
                return;
            }
            Rectangle path = tree.getPathBounds(cp);
            if (path == null) {
                return;
            }
            g2.setColor(Color.RED);
            g2.drawRect(path.x, path.y, path.width - 1, path.height - 1);
            if (this.lastDrawn == null) {
                this.lastDrawn = path;
            } else {
                Rectangle.union(this.lastDrawn, path, this.lastDrawn);
            }
            this.dragAction(e);
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent e) {
            e.acceptDrag(e.getDropAction());
        }

        @Override
        public void dragExit(DropTargetEvent e) {
            this.eraseDragImage((DropTarget)e.getSource());
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            dtde.acceptDrop(0x40000000);
            this.eraseDragImage((DropTarget)dtde.getSource());
            Object obj = this.getDraggedObject(dtde.getCurrentDataFlavors());
            if (obj != null) {
                ExplorerTree originalTree;
                DropTarget dt;
                ExplorerTree tree;
                TreePath cp;
                Library destLib;
                Cell origCell = null;
                if (obj instanceof Cell) {
                    origCell = (Cell)obj;
                } else if (obj instanceof Cell.CellGroup) {
                    origCell = ((Cell.CellGroup)obj).getCells().next();
                }
                if (origCell != null && (destLib = this.findLibrary(cp = (tree = (ExplorerTree)(dt = (DropTarget)dtde.getSource()).getComponent()).getPathForLocation(dtde.getLocation().x, dtde.getLocation().y))) != null && origCell.getLibrary() != destLib && (originalTree = this.getOriginalTree(dtde.getCurrentDataFlavors())) != null) {
                    new CrossLibraryCopyJob(origCell, destLib, obj instanceof Cell.CellGroup, originalTree.subCells);
                    dtde.dropComplete(true);
                    return;
                }
            }
            dtde.dropComplete(false);
        }

        private Library findLibrary(TreePath cp) {
            if (cp == null) {
                return null;
            }
            Object obj = cp.getLastPathComponent();
            if (obj instanceof DefaultMutableTreeNode) {
                if ((obj = ((DefaultMutableTreeNode)obj).getUserObject()) instanceof Library) {
                    return (Library)obj;
                }
                if (obj instanceof Cell.CellGroup) {
                    return ((Cell.CellGroup)obj).getCells().next().getLibrary();
                }
                if (obj instanceof Cell) {
                    return ((Cell)obj).getLibrary();
                }
            }
            return null;
        }

        private Object getDraggedObject(DataFlavor[] flavors) {
            if (flavors.length > 0 && flavors[0] instanceof EditWindow.NodeProtoDataFlavor) {
                EditWindow.NodeProtoDataFlavor npdf = (EditWindow.NodeProtoDataFlavor)flavors[0];
                Object obj = npdf.getFlavorObject();
                return obj;
            }
            return null;
        }

        private ExplorerTree getOriginalTree(DataFlavor[] flavors) {
            if (flavors.length > 0 && flavors[0] instanceof EditWindow.NodeProtoDataFlavor) {
                EditWindow.NodeProtoDataFlavor npdf = (EditWindow.NodeProtoDataFlavor)flavors[0];
                return npdf.getOriginalTree();
            }
            return null;
        }

        private void dragAction(DropTargetDragEvent e) {
            Object obj = this.getDraggedObject(e.getCurrentDataFlavors());
            if (obj != null) {
                e.acceptDrag(e.getDropAction());
            }
        }

        private void eraseDragImage(DropTarget dt) {
            if (this.lastDrawn == null) {
                return;
            }
            ExplorerTree tree = (ExplorerTree)dt.getComponent();
            tree.paintImmediately(this.lastDrawn);
            this.lastDrawn = null;
        }
    }

    private class MyTransferHandler
    extends TransferHandler {
        private TransferHandler real;
        private ExplorerTree tree;

        MyTransferHandler(TransferHandler real, ExplorerTree tree) {
            this.real = real;
            this.tree = tree;
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            if (ExplorerTree.this.numCurrentlySelectedObjects() == 0) {
                return null;
            }
            if (ExplorerTree.this.getCurrentlySelectedObject(0) instanceof Signal) {
                StringBuffer buf = new StringBuffer();
                for (int i = 0; i < ExplorerTree.this.numCurrentlySelectedObjects(); ++i) {
                    Signal sSig = (Signal)ExplorerTree.this.getCurrentlySelectedObject(i);
                    String sigName = sSig.getFullName();
                    if (sSig instanceof AnalogSignal) {
                        AnalogSignal as = (AnalogSignal)sSig;
                        if (as.getAnalysis().getAnalysisType() == Analysis.ANALYSIS_TRANS) {
                            sigName = "TRANS " + sigName;
                        } else if (as.getAnalysis().getAnalysisType() == Analysis.ANALYSIS_AC) {
                            sigName = "AC " + sigName;
                        } else if (as.getAnalysis().getAnalysisType() == Analysis.ANALYSIS_DC) {
                            sigName = "DC " + sigName;
                        } else if (as.getAnalysis().getAnalysisType() == Analysis.ANALYSIS_MEAS) {
                            sigName = "MEASUREMENT " + sigName;
                        }
                    }
                    buf.append(sigName);
                    buf.append("\n");
                }
                StringSelection transferable = new StringSelection(buf.toString());
                return transferable;
            }
            if (ExplorerTree.this.numCurrentlySelectedObjects() > 1) {
                Job.getUserInterface().showErrorMessage("Can drag only one Cell or Group", "Too Much Selected");
                return null;
            }
            EditWindow.NodeProtoTransferable transferable = new EditWindow.NodeProtoTransferable(ExplorerTree.this.getCurrentlySelectedObject(0), this.tree);
            if (!transferable.isValid()) {
                return null;
            }
            TreePath path = ExplorerTree.this.currentSelectedPaths[0];
            Rectangle pathRect = ExplorerTree.this.getPathBounds(path);
            if (pathRect == null) {
                return null;
            }
            ExplorerTree.this.dragOffset = new Point(0, 0);
            Component comp = ExplorerTree.this.getCellRenderer().getTreeCellRendererComponent(this.tree, path.getLastPathComponent(), false, ExplorerTree.this.isExpanded(path), ExplorerTree.this.getModel().isLeaf(path.getLastPathComponent()), 0, false);
            int wid = (int)pathRect.getWidth();
            int hei = (int)pathRect.getHeight();
            ExplorerTree.this.subCells = false;
            if (ExplorerTree.this.subCells) {
                hei *= 2;
            }
            comp.setSize(wid, hei);
            ExplorerTree.this.dragImage = new BufferedImage(wid, hei, 3);
            Graphics2D g2 = ExplorerTree.this.dragImage.createGraphics();
            g2.setComposite(AlphaComposite.getInstance(2, 0.5f));
            AffineTransform saveAT = g2.getTransform();
            if (ExplorerTree.this.subCells) {
                g2.translate(0, -hei / 4);
            }
            comp.paint(g2);
            g2.setTransform(saveAT);
            if (ExplorerTree.this.subCells) {
                g2.setColor(Color.BLACK);
                g2.drawLine(wid / 2, hei / 2, 0, hei);
                g2.drawLine(wid / 2, hei / 2, wid / 3, hei);
                g2.drawLine(wid / 2, hei / 2, wid / 3 * 2, hei);
                g2.drawLine(wid / 2, hei / 2, wid, hei);
            }
            g2.dispose();
            return transferable;
        }

        @Override
        public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
            return this.real.canImport(comp, transferFlavors);
        }

        @Override
        public void exportAsDrag(JComponent comp, InputEvent e, int action) {
            this.real.exportAsDrag(comp, e, action);
        }

        @Override
        protected void exportDone(JComponent source, Transferable data, int action) {
        }

        @Override
        public void exportToClipboard(JComponent comp, Clipboard clip, int action) {
            this.real.exportToClipboard(comp, clip, action);
        }

        @Override
        public int getSourceActions(JComponent c) {
            return this.real.getSourceActions(c);
        }

        @Override
        public Icon getVisualRepresentation(Transferable t) {
            return this.real.getVisualRepresentation(t);
        }

        @Override
        public boolean importData(JComponent comp, Transferable t) {
            return this.real.importData(comp, t);
        }
    }

    private static class IconGroup {
        private ImageIcon regular;
        private ImageIcon old;
        private ImageIcon available;
        private ImageIcon locked;
        private ImageIcon unlocked;

        private IconGroup() {
        }
    }
}

