/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout.gates;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.tool.generator.layout.FoldedNmos;
import com.sun.electric.tool.generator.layout.FoldsAndWidth;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.StdCellParams;
import com.sun.electric.tool.generator.layout.TechType;
import com.sun.electric.tool.generator.layout.TrackRouterH;

public class Nms1 {
    private static final double wellOverhangDiff = 6.0;
    private static final double gY = -4.0;
    private static final double dY = -11.0;
    private static final double nmosTop = -9.0;

    private static void error(boolean pred, String msg) {
        LayoutLib.error(pred, msg);
    }

    public static Cell makePart(double sz, StdCellParams stdCell) {
        TechType tech = stdCell.getTechType();
        sz = stdCell.roundSize(sz);
        String nm = "nms1" + (stdCell.getDoubleStrapGate() ? "_strap" : "");
        sz = stdCell.checkMinStrength(sz, 1.0, nm);
        double outsideSpace = stdCell.getDoubleStrapGate() ? 8.5 : 6.0;
        double spaceAvail = -9.0 - (stdCell.getCellBot() + outsideSpace);
        double totWid = sz * 3.0;
        FoldsAndWidth fw = stdCell.calcFoldsAndWidth(spaceAvail, totWid, 1);
        Nms1.error(fw == null, "can't make Nms1 this small: " + sz);
        Cell nms1 = stdCell.findPart(nm, sz);
        if (nms1 != null) {
            return nms1;
        }
        nms1 = stdCell.newPart(nm, sz);
        double gX = 3.5;
        LayoutLib.newExport(nms1, "g", PortCharacteristic.IN, tech.m1(), 4.0, gX, -4.0);
        double mosX = gX + 2.0 + 3.0 + 2.0;
        double nmosY = -9.0 - fw.physWid / 2.0;
        FoldedNmos nmos = new FoldedNmos(mosX, nmosY, fw.nbFolds, 1, fw.gateWid, nms1, tech);
        double dX = StdCellParams.getRightDiffX(nmos) + 2.0 + 3.0 + 2.0;
        LayoutLib.newExport(nms1, "d", PortCharacteristic.OUT, tech.m1(), 4.0, dX, -11.0);
        stdCell.wireVddGnd(nmos, StdCellParams.EVEN, nms1);
        TrackRouterH g = new TrackRouterH(tech.m1(), 3.0, -4.0, tech, nms1);
        g.connect(nms1.findExport("g"));
        for (int i = 0; i < nmos.nbGates(); ++i) {
            g.connect(nmos.getGate(i, 'T'));
        }
        if (stdCell.getDoubleStrapGate()) {
            double gndBot = stdCell.getGndY() - stdCell.getGndWidth() / 2.0;
            double inLoFromGnd = gndBot - 3.0 - 2.0;
            double nmosBot = nmosY - fw.physWid / 2.0;
            double inLoFromMos = nmosBot - 2.0 - 2.5;
            double inLoY = Math.min(inLoFromGnd, inLoFromMos);
            TrackRouterH inLo = new TrackRouterH(tech.m1(), 3.0, inLoY, tech, nms1);
            inLo.connect(nms1.findExport("g"));
            for (int i = 0; i < nmos.nbGates(); ++i) {
                inLo.connect(nmos.getGate(i, 'B'));
            }
        }
        TrackRouterH d = new TrackRouterH(tech.m2(), 4.0, -11.0, tech, nms1);
        d.connect(nms1.findExport("d"));
        for (int i = 1; i < nmos.nbSrcDrns(); i += 2) {
            d.connect(nmos.getSrcDrn(i));
        }
        double wellMinX = 0.0;
        double wellMaxX = dX + 2.0 + 1.5;
        stdCell.addNmosWell(wellMinX, wellMaxX, nms1);
        stdCell.addNstackEssentialBounds(wellMinX, wellMaxX, nms1);
        stdCell.doNCC(nms1, nm + "{sch}");
        return nms1;
    }
}

