/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation;

import com.sun.electric.tool.simulation.DigitalAnalysis;
import com.sun.electric.tool.simulation.Signal;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DigitalSignal
extends Signal {
    private DigitalAnalysis an;
    private List<DigitalSignal> bussedSignals;
    private int busCount;
    private double[] time;
    private int[] state;

    public DigitalSignal(DigitalAnalysis an) {
        this.an = an;
        an.addSignal(this);
    }

    @Override
    public void finished() {
        super.finished();
        if (this.bussedSignals != null) {
            for (DigitalSignal s : this.bussedSignals) {
                ((Signal)s).finished();
            }
            this.bussedSignals.clear();
        }
        this.busCount = 0;
        this.time = null;
        this.state = null;
    }

    @Override
    public DigitalAnalysis getAnalysis() {
        return this.an;
    }

    public void buildBussedSignalList() {
        this.bussedSignals = new ArrayList<DigitalSignal>();
        this.an.getBussedSignals().add(this);
    }

    public List<DigitalSignal> getBussedSignals() {
        return this.bussedSignals;
    }

    public void clearBussedSignalList() {
        for (DigitalSignal sig : this.bussedSignals) {
            --sig.busCount;
        }
        this.bussedSignals.clear();
    }

    public void addToBussedSignalList(DigitalSignal ws) {
        this.bussedSignals.add(ws);
        ++ws.busCount;
    }

    public boolean isInBus() {
        return this.busCount != 0;
    }

    public void buildTime(int numEvents) {
        this.time = new double[numEvents];
    }

    public double getTime(int index) {
        return this.time[index];
    }

    public double[] getTimeVector() {
        return this.time;
    }

    public void setTimeVector(double[] time) {
        this.bounds = null;
        this.time = time;
    }

    public void setTime(int entry, double t) {
        this.bounds = null;
        this.time[entry] = t;
    }

    public void buildState(int numEvents) {
        this.state = new int[numEvents];
    }

    public void setState(int index, int st) {
        this.state[index] = st;
        this.bounds = null;
    }

    public int getState(int index) {
        return this.state[index];
    }

    public int[] getStateVector() {
        return this.state;
    }

    public void setStateVector(int[] state) {
        this.state = state;
        this.bounds = null;
    }

    public int getNumEvents() {
        if (this.state == null) {
            return 0;
        }
        return this.state.length;
    }

    @Override
    protected void calcBounds() {
        boolean first = true;
        double lowTime = 0.0;
        double highTime = 0.0;
        if (this.state != null) {
            for (int i = 0; i < this.state.length; ++i) {
                double time = this.getTime(i);
                if (i == 0) {
                    this.leftEdge = time;
                } else if (i == this.state.length - 1) {
                    this.rightEdge = time;
                }
                if (first) {
                    first = false;
                    lowTime = highTime = time;
                    continue;
                }
                if (time < lowTime) {
                    lowTime = time;
                }
                if (!(time > highTime)) continue;
                highTime = time;
            }
        }
        this.bounds = new Rectangle2D.Double(lowTime, 0.0, highTime - lowTime, 1.0);
    }
}

