/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.tecEditWizard;

import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.DRCTemplate;
import com.sun.electric.technology.Foundry;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.Xml;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.user.dialogs.OpenFile;
import com.sun.electric.tool.user.tecEditWizard.WizardField;
import java.awt.Color;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TechEditWizardData {
    private String tech_name;
    private String tech_description;
    private int num_metal_layers = 2;
    private int stepsize = 100;
    private WizardField diff_width = new WizardField();
    private WizardField diff_poly_overhang = new WizardField();
    private WizardField diff_contact_overhang = new WizardField();
    private WizardField diff_spacing = new WizardField();
    private WizardField poly_width = new WizardField();
    private WizardField poly_endcap = new WizardField();
    private WizardField poly_spacing = new WizardField();
    private WizardField poly_diff_spacing = new WizardField();
    private WizardField gate_length = new WizardField();
    private WizardField gate_width = new WizardField();
    private WizardField gate_spacing = new WizardField();
    private WizardField gate_contact_spacing = new WizardField();
    private WizardField contact_size = new WizardField();
    private WizardField contact_spacing = new WizardField();
    private WizardField contact_array_spacing = new WizardField();
    private WizardField contact_metal_overhang_inline_only = new WizardField();
    private WizardField contact_metal_overhang_all_sides = new WizardField();
    private WizardField contact_poly_overhang = new WizardField();
    private WizardField polycon_diff_spacing = new WizardField();
    private WizardField nplus_width = new WizardField();
    private WizardField nplus_overhang_diff = new WizardField();
    private WizardField nplus_overhang_poly = new WizardField();
    private WizardField nplus_spacing = new WizardField();
    private WizardField pplus_width = new WizardField();
    private WizardField pplus_overhang_diff = new WizardField();
    private WizardField pplus_overhang_poly = new WizardField();
    private WizardField pplus_spacing = new WizardField();
    private WizardField nwell_width = new WizardField();
    private WizardField nwell_overhang_diff_p = new WizardField();
    private WizardField nwell_overhang_diff_n = new WizardField();
    private WizardField nwell_spacing = new WizardField();
    private WizardField[] metal_width = new WizardField[this.num_metal_layers];
    private WizardField[] metal_spacing = new WizardField[this.num_metal_layers];
    private WizardField[] via_size = new WizardField[this.num_metal_layers - 1];
    private WizardField[] via_spacing = new WizardField[this.num_metal_layers - 1];
    private WizardField[] via_array_spacing = new WizardField[this.num_metal_layers - 1];
    private WizardField[] via_overhang_inline = new WizardField[this.num_metal_layers - 1];
    private double poly_antenna_ratio;
    private double[] metal_antenna_ratio = new double[this.num_metal_layers];
    private int gds_diff_layer;
    private int gds_poly_layer;
    private int gds_nplus_layer;
    private int gds_pplus_layer;
    private int gds_nwell_layer;
    private int gds_contact_layer;
    private int[] gds_metal_layer = new int[this.num_metal_layers];
    private int[] gds_via_layer = new int[this.num_metal_layers - 1];
    private int gds_marking_layer;

    public TechEditWizardData() {
        int i;
        for (i = 0; i < this.num_metal_layers; ++i) {
            this.metal_width[i] = new WizardField();
            this.metal_spacing[i] = new WizardField();
        }
        for (i = 0; i < this.num_metal_layers - 1; ++i) {
            this.via_size[i] = new WizardField();
            this.via_spacing[i] = new WizardField();
            this.via_array_spacing[i] = new WizardField();
            this.via_overhang_inline[i] = new WizardField();
        }
    }

    public String getTechName() {
        return this.tech_name;
    }

    public void setTechName(String s) {
        this.tech_name = s;
    }

    public String getTechDescription() {
        return this.tech_description;
    }

    public void setTechDescription(String s) {
        this.tech_description = s;
    }

    public int getStepSize() {
        return this.stepsize;
    }

    public void setStepSize(int n) {
        this.stepsize = n;
    }

    public int getNumMetalLayers() {
        return this.num_metal_layers;
    }

    public void setNumMetalLayers(int n) {
        int i;
        int i2;
        int i3;
        int i4;
        int i5;
        int i6;
        int smallest = Math.min(n, this.num_metal_layers);
        WizardField[] new_metal_width = new WizardField[n];
        for (i6 = 0; i6 < smallest; ++i6) {
            new_metal_width[i6] = this.metal_width[i6];
        }
        for (i6 = smallest; i6 < n; ++i6) {
            new_metal_width[i6] = new WizardField();
        }
        this.metal_width = new_metal_width;
        WizardField[] new_metal_spacing = new WizardField[n];
        for (i5 = 0; i5 < smallest; ++i5) {
            new_metal_spacing[i5] = this.metal_spacing[i5];
        }
        for (i5 = smallest; i5 < n; ++i5) {
            new_metal_spacing[i5] = new WizardField();
        }
        this.metal_spacing = new_metal_spacing;
        WizardField[] new_via_size = new WizardField[n - 1];
        for (i4 = 0; i4 < smallest - 1; ++i4) {
            new_via_size[i4] = this.via_size[i4];
        }
        for (i4 = smallest - 1; i4 < n - 1; ++i4) {
            new_via_size[i4] = new WizardField();
        }
        this.via_size = new_via_size;
        WizardField[] new_via_spacing = new WizardField[n - 1];
        for (i3 = 0; i3 < smallest - 1; ++i3) {
            new_via_spacing[i3] = this.via_spacing[i3];
        }
        for (i3 = smallest - 1; i3 < n - 1; ++i3) {
            new_via_spacing[i3] = new WizardField();
        }
        this.via_spacing = new_via_spacing;
        WizardField[] new_via_array_spacing = new WizardField[n - 1];
        for (i2 = 0; i2 < smallest - 1; ++i2) {
            new_via_array_spacing[i2] = this.via_array_spacing[i2];
        }
        for (i2 = smallest - 1; i2 < n - 1; ++i2) {
            new_via_array_spacing[i2] = new WizardField();
        }
        this.via_array_spacing = new_via_array_spacing;
        WizardField[] new_via_overhang_inline = new WizardField[n - 1];
        for (i = 0; i < smallest - 1; ++i) {
            new_via_overhang_inline[i] = this.via_overhang_inline[i];
        }
        for (i = smallest - 1; i < n - 1; ++i) {
            new_via_overhang_inline[i] = new WizardField();
        }
        this.via_overhang_inline = new_via_overhang_inline;
        double[] new_metal_antenna_ratio = new double[n];
        for (int i7 = 0; i7 < smallest; ++i7) {
            new_metal_antenna_ratio[i7] = this.metal_antenna_ratio[i7];
        }
        this.metal_antenna_ratio = new_metal_antenna_ratio;
        int[] new_gds_metal_layer = new int[n];
        for (int i8 = 0; i8 < smallest; ++i8) {
            new_gds_metal_layer[i8] = this.gds_metal_layer[i8];
        }
        this.gds_metal_layer = new_gds_metal_layer;
        int[] new_gds_via_layer = new int[n - 1];
        for (int i9 = 0; i9 < smallest - 1; ++i9) {
            new_gds_via_layer[i9] = this.gds_via_layer[i9];
        }
        this.gds_via_layer = new_gds_via_layer;
        this.num_metal_layers = n;
    }

    public WizardField getDiffWidth() {
        return this.diff_width;
    }

    public void setDiffWidth(WizardField v) {
        this.diff_width = v;
    }

    public WizardField getDiffPolyOverhang() {
        return this.diff_poly_overhang;
    }

    public void setDiffPolyOverhang(WizardField v) {
        this.diff_poly_overhang = v;
    }

    public WizardField getDiffContactOverhang() {
        return this.diff_contact_overhang;
    }

    public void setDiffContactOverhang(WizardField v) {
        this.diff_contact_overhang = v;
    }

    public WizardField getDiffSpacing() {
        return this.diff_spacing;
    }

    public void setDiffSpacing(WizardField v) {
        this.diff_spacing = v;
    }

    public WizardField getPolyWidth() {
        return this.poly_width;
    }

    public void setPolyWidth(WizardField v) {
        this.poly_width = v;
    }

    public WizardField getPolyEndcap() {
        return this.poly_endcap;
    }

    public void setPolyEndcap(WizardField v) {
        this.poly_endcap = v;
    }

    public WizardField getPolySpacing() {
        return this.poly_spacing;
    }

    public void setPolySpacing(WizardField v) {
        this.poly_spacing = v;
    }

    public WizardField getPolyDiffSpacing() {
        return this.poly_diff_spacing;
    }

    public void setPolyDiffSpacing(WizardField v) {
        this.poly_diff_spacing = v;
    }

    public WizardField getGateLength() {
        return this.gate_length;
    }

    public void setGateLength(WizardField v) {
        this.gate_length = v;
    }

    public WizardField getGateWidth() {
        return this.gate_width;
    }

    public void setGateWidth(WizardField v) {
        this.gate_width = v;
    }

    public WizardField getGateSpacing() {
        return this.gate_spacing;
    }

    public void setGateSpacing(WizardField v) {
        this.gate_spacing = v;
    }

    public WizardField getGateContactSpacing() {
        return this.gate_contact_spacing;
    }

    public void setGateContactSpacing(WizardField v) {
        this.gate_contact_spacing = v;
    }

    public WizardField getContactSize() {
        return this.contact_size;
    }

    public void setContactSize(WizardField v) {
        this.contact_size = v;
    }

    public WizardField getContactSpacing() {
        return this.contact_spacing;
    }

    public void setContactSpacing(WizardField v) {
        this.contact_spacing = v;
    }

    public WizardField getContactArraySpacing() {
        return this.contact_array_spacing;
    }

    public void setContactArraySpacing(WizardField v) {
        this.contact_array_spacing = v;
    }

    public WizardField getContactMetalOverhangInlineOnly() {
        return this.contact_metal_overhang_inline_only;
    }

    public void setContactMetalOverhangInlineOnly(WizardField v) {
        this.contact_metal_overhang_inline_only = v;
    }

    public WizardField getContactMetalOverhangAllSides() {
        return this.contact_metal_overhang_all_sides;
    }

    public void setContactMetalOverhangAllSides(WizardField v) {
        this.contact_metal_overhang_all_sides = v;
    }

    public WizardField getContactPolyOverhang() {
        return this.contact_poly_overhang;
    }

    public void setContactPolyOverhang(WizardField v) {
        this.contact_poly_overhang = v;
    }

    public WizardField getPolyconDiffSpacing() {
        return this.polycon_diff_spacing;
    }

    public void setPolyconDiffSpacing(WizardField v) {
        this.polycon_diff_spacing = v;
    }

    public WizardField getNPlusWidth() {
        return this.nplus_width;
    }

    public void setNPlusWidth(WizardField v) {
        this.nplus_width = v;
    }

    public WizardField getNPlusOverhangDiff() {
        return this.nplus_overhang_diff;
    }

    public void setNPlusOverhangDiff(WizardField v) {
        this.nplus_overhang_diff = v;
    }

    public WizardField getNPlusOverhangPoly() {
        return this.nplus_overhang_poly;
    }

    public void setNPlusOverhangPoly(WizardField v) {
        this.nplus_overhang_poly = v;
    }

    public WizardField getNPlusSpacing() {
        return this.nplus_spacing;
    }

    public void setNPlusSpacing(WizardField v) {
        this.nplus_spacing = v;
    }

    public WizardField getPPlusWidth() {
        return this.pplus_width;
    }

    public void setPPlusWidth(WizardField v) {
        this.pplus_width = v;
    }

    public WizardField getPPlusOverhangDiff() {
        return this.pplus_overhang_diff;
    }

    public void setPPlusOverhangDiff(WizardField v) {
        this.pplus_overhang_diff = v;
    }

    public WizardField getPPlusOverhangPoly() {
        return this.pplus_overhang_poly;
    }

    public void setPPlusOverhangPoly(WizardField v) {
        this.pplus_overhang_poly = v;
    }

    public WizardField getPPlusSpacing() {
        return this.pplus_spacing;
    }

    public void setPPlusSpacing(WizardField v) {
        this.pplus_spacing = v;
    }

    public WizardField getNWellWidth() {
        return this.nwell_width;
    }

    public void setNWellWidth(WizardField v) {
        this.nwell_width = v;
    }

    public WizardField getNWellOverhangDiffP() {
        return this.nwell_overhang_diff_p;
    }

    public void setNWellOverhangDiffP(WizardField v) {
        this.nwell_overhang_diff_p = v;
    }

    public WizardField getNWellOverhangDiffN() {
        return this.nwell_overhang_diff_n;
    }

    public void setNWellOverhangDiffN(WizardField v) {
        this.nwell_overhang_diff_n = v;
    }

    public WizardField getNWellSpacing() {
        return this.nwell_spacing;
    }

    public void setNWellSpacing(WizardField v) {
        this.nwell_spacing = v;
    }

    public WizardField[] getMetalWidth() {
        return this.metal_width;
    }

    public void setMetalWidth(int met, WizardField value) {
        this.metal_width[met] = value;
    }

    public WizardField[] getMetalSpacing() {
        return this.metal_spacing;
    }

    public void setMetalSpacing(int met, WizardField value) {
        this.metal_spacing[met] = value;
    }

    public WizardField[] getViaSize() {
        return this.via_size;
    }

    public void setViaSize(int via, WizardField value) {
        this.via_size[via] = value;
    }

    public WizardField[] getViaSpacing() {
        return this.via_spacing;
    }

    public void setViaSpacing(int via, WizardField value) {
        this.via_spacing[via] = value;
    }

    public WizardField[] getViaArraySpacing() {
        return this.via_array_spacing;
    }

    public void setViaArraySpacing(int via, WizardField value) {
        this.via_array_spacing[via] = value;
    }

    public WizardField[] getViaOverhangInline() {
        return this.via_overhang_inline;
    }

    public void setViaOverhangInline(int via, WizardField value) {
        this.via_overhang_inline[via] = value;
    }

    public double getPolyAntennaRatio() {
        return this.poly_antenna_ratio;
    }

    public void setPolyAntennaRatio(double v) {
        this.poly_antenna_ratio = v;
    }

    public double[] getMetalAntennaRatio() {
        return this.metal_antenna_ratio;
    }

    public void setMetalAntennaRatio(int met, double value) {
        this.metal_antenna_ratio[met] = value;
    }

    public int getGDSDiff() {
        return this.gds_diff_layer;
    }

    public void setGDSDiff(int l) {
        this.gds_diff_layer = l;
    }

    public int getGDSPoly() {
        return this.gds_poly_layer;
    }

    public void setGDSPoly(int l) {
        this.gds_poly_layer = l;
    }

    public int getGDSNPlus() {
        return this.gds_nplus_layer;
    }

    public void setGDSNPlus(int l) {
        this.gds_nplus_layer = l;
    }

    public int getGDSPPlus() {
        return this.gds_pplus_layer;
    }

    public void setGDSPPlus(int l) {
        this.gds_pplus_layer = l;
    }

    public int getGDSNWell() {
        return this.gds_nwell_layer;
    }

    public void setGDSNWell(int l) {
        this.gds_nwell_layer = l;
    }

    public int getGDSContact() {
        return this.gds_contact_layer;
    }

    public void setGDSContact(int l) {
        this.gds_contact_layer = l;
    }

    public int[] getGDSMetal() {
        return this.gds_metal_layer;
    }

    public void setGDSMetal(int met, int l) {
        this.gds_metal_layer[met] = l;
    }

    public int[] getGDSVia() {
        return this.gds_via_layer;
    }

    public void setGDSVia(int via, int l) {
        this.gds_via_layer[via] = l;
    }

    public int getGDSMarking() {
        return this.gds_marking_layer;
    }

    public void setGDSMarking(int l) {
        this.gds_marking_layer = l;
    }

    public String errorInData() {
        int i;
        if (this.tech_name == null || this.tech_name.length() == 0) {
            return "General panel: No technology name";
        }
        if (this.stepsize == 0) {
            return "General panel: Invalid unit size";
        }
        if (this.diff_width.v == 0.0) {
            return "Active panel: Invalid width";
        }
        if (this.poly_width.v == 0.0) {
            return "Poly panel: Invalid width";
        }
        if (this.gate_width.v == 0.0) {
            return "Gate panel: Invalid width";
        }
        if (this.gate_length.v == 0.0) {
            return "Gate panel: Invalid length";
        }
        if (this.contact_size.v == 0.0) {
            return "Contact panel: Invalid size";
        }
        if (this.nplus_width.v == 0.0) {
            return "Well/Implant panel: Invalid NPlus width";
        }
        if (this.pplus_width.v == 0.0) {
            return "Well/Implant panel: Invalid PPlus width";
        }
        if (this.nwell_width.v == 0.0) {
            return "Well/Implant panel: Invalid NWell width";
        }
        for (i = 0; i < this.num_metal_layers; ++i) {
            if (this.metal_width[i].v != 0.0) continue;
            return "Metal panel: Invalid Metal-" + (i + 1) + " width";
        }
        for (i = 0; i < this.num_metal_layers - 1; ++i) {
            if (this.via_size[i].v != 0.0) continue;
            return "Via panel: Invalid Via-" + (i + 1) + " size";
        }
        return null;
    }

    boolean importData() {
        String fileName = OpenFile.chooseInputFile(FileType.ANY, "Technology Wizard File");
        if (fileName == null) {
            return false;
        }
        return this.importData(fileName);
    }

    public boolean importData(String fileName) {
        URL url = TextUtils.makeURLToFile(fileName);
        try {
            String buf;
            URLConnection urlCon = url.openConnection();
            InputStreamReader is = new InputStreamReader(urlCon.getInputStream());
            LineNumberReader lineReader = new LineNumberReader(is);
            while ((buf = lineReader.readLine()) != null) {
                if ((buf = buf.trim()).length() == 0 || buf.startsWith("#") || !buf.startsWith("$") && !buf.startsWith("@")) continue;
                int spacePos = buf.indexOf(32);
                int equalsPos = buf.indexOf(61);
                if (equalsPos < 0) {
                    Job.getUserInterface().showErrorMessage("Missing '=' on line " + lineReader.getLineNumber(), "Syntax Error In Technology File");
                    break;
                }
                spacePos = spacePos < 0 ? equalsPos : Math.min(spacePos, equalsPos);
                String varName = buf.substring(1, spacePos);
                int semiPos = buf.indexOf(59);
                if (semiPos < 0) {
                    Job.getUserInterface().showErrorMessage("Missing ';' on line " + lineReader.getLineNumber(), "Syntax Error In Technology File");
                    break;
                }
                ++equalsPos;
                while (equalsPos < semiPos && buf.charAt(equalsPos) == ' ') {
                    ++equalsPos;
                }
                String varValue = buf.substring(equalsPos, semiPos);
                if (varName.equalsIgnoreCase("tech_libname")) continue;
                if (varName.equalsIgnoreCase("tech_name")) {
                    this.setTechName(this.stripQuotes(varValue));
                    continue;
                }
                if (varName.equalsIgnoreCase("tech_description")) {
                    this.setTechDescription(this.stripQuotes(varValue));
                    continue;
                }
                if (varName.equalsIgnoreCase("num_metal_layers")) {
                    this.setNumMetalLayers(TextUtils.atoi(varValue));
                    continue;
                }
                if (varName.equalsIgnoreCase("stepsize")) {
                    this.setStepSize(TextUtils.atoi(varValue));
                    continue;
                }
                if (varName.equalsIgnoreCase("diff_width")) {
                    this.diff_width.v = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("diff_width_rule")) {
                    this.diff_width.rule = this.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("diff_poly_overhang")) {
                    this.diff_poly_overhang.v = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("diff_poly_overhang_rule")) {
                    this.diff_poly_overhang.rule = this.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("diff_contact_overhang")) {
                    this.diff_contact_overhang.v = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("diff_contact_overhang_rule")) {
                    this.diff_contact_overhang.rule = this.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("diff_spacing")) {
                    this.diff_spacing.v = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("diff_spacing_rule")) {
                    this.diff_spacing.rule = this.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("poly_width")) {
                    this.poly_width.v = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("poly_width_rule")) {
                    this.poly_width.rule = this.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("poly_endcap")) {
                    this.poly_endcap.v = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("poly_endcap_rule")) {
                    this.poly_endcap.rule = this.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("poly_spacing")) {
                    this.poly_spacing.v = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("poly_spacing_rule")) {
                    this.poly_spacing.rule = this.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("poly_diff_spacing")) {
                    this.poly_diff_spacing.v = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("poly_diff_spacing_rule")) {
                    this.poly_diff_spacing.rule = this.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("gate_length")) {
                    this.gate_length.v = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("gate_length_rule")) {
                    this.gate_length.rule = this.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("gate_width")) {
                    this.gate_width.v = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("gate_width_rule")) {
                    this.gate_width.rule = this.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("gate_spacing")) {
                    this.gate_spacing.v = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("gate_spacing_rule")) {
                    this.gate_spacing.rule = this.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("gate_contact_spacing")) {
                    this.gate_contact_spacing.v = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("gate_contact_spacing_rule")) {
                    this.gate_contact_spacing.rule = this.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("contact_size")) {
                    this.contact_size.v = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("contact_size_rule")) {
                    this.contact_size.rule = this.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("contact_spacing")) {
                    this.contact_spacing.v = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("contact_spacing_rule")) {
                    this.contact_spacing.rule = this.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("contact_array_spacing")) {
                    this.contact_array_spacing.v = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("contact_array_spacing_rule")) {
                    this.contact_array_spacing.rule = this.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("contact_metal_overhang_inline_only")) {
                    this.contact_metal_overhang_inline_only.v = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("contact_metal_overhang_inline_only_rule")) {
                    this.contact_metal_overhang_inline_only.rule = this.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("contact_metal_overhang_all_sides")) {
                    this.contact_metal_overhang_all_sides.v = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("contact_metal_overhang_all_sides_rule")) {
                    this.contact_metal_overhang_all_sides.rule = this.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("contact_poly_overhang")) {
                    this.contact_poly_overhang.v = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("contact_poly_overhang_rule")) {
                    this.contact_poly_overhang.rule = this.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("polycon_diff_spacing")) {
                    this.polycon_diff_spacing.v = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("polycon_diff_spacing_rule")) {
                    this.polycon_diff_spacing.rule = this.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("nplus_width")) {
                    this.nplus_width.v = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("nplus_width_rule")) {
                    this.nplus_width.rule = this.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("nplus_overhang_diff")) {
                    this.nplus_overhang_diff.v = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("nplus_overhang_diff_rule")) {
                    this.nplus_overhang_diff.rule = this.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("nplus_overhang_poly")) {
                    this.nplus_overhang_poly.v = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("nplus_overhang_poly_rule")) {
                    this.nplus_overhang_poly.rule = this.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("nplus_spacing")) {
                    this.nplus_spacing.v = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("nplus_spacing_rule")) {
                    this.nplus_spacing.rule = this.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("pplus_width")) {
                    this.pplus_width.v = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("pplus_width_rule")) {
                    this.pplus_width.rule = this.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("pplus_overhang_diff")) {
                    this.pplus_overhang_diff.v = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("pplus_overhang_diff_rule")) {
                    this.pplus_overhang_diff.rule = this.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("pplus_overhang_poly")) {
                    this.pplus_overhang_poly.v = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("pplus_overhang_poly_rule")) {
                    this.pplus_overhang_poly.rule = this.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("pplus_spacing")) {
                    this.pplus_spacing.v = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("pplus_spacing_rule")) {
                    this.pplus_spacing.rule = this.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("nwell_width")) {
                    this.nwell_width.v = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("nwell_width_rule")) {
                    this.nwell_width.rule = this.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("nwell_overhang_diff_p")) {
                    this.nwell_overhang_diff_p.v = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("nwell_overhang_diff_rule_p")) {
                    this.nwell_overhang_diff_p.rule = this.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("nwell_overhang_diff_n")) {
                    this.nwell_overhang_diff_n.v = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("nwell_overhang_diff_rule_n")) {
                    this.nwell_overhang_diff_n.rule = this.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("nwell_spacing")) {
                    this.nwell_spacing.v = TextUtils.atof(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("nwell_spacing_rule")) {
                    this.nwell_spacing.rule = this.stripQuotes(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("metal_width")) {
                    this.fillWizardArray(varValue, this.metal_width, this.num_metal_layers, false);
                    continue;
                }
                if (varName.equalsIgnoreCase("metal_width_rule")) {
                    this.fillWizardArray(varValue, this.metal_width, this.num_metal_layers, true);
                    continue;
                }
                if (varName.equalsIgnoreCase("metal_spacing")) {
                    this.fillWizardArray(varValue, this.metal_spacing, this.num_metal_layers, false);
                    continue;
                }
                if (varName.equalsIgnoreCase("metal_spacing_rule")) {
                    this.fillWizardArray(varValue, this.metal_spacing, this.num_metal_layers, true);
                    continue;
                }
                if (varName.equalsIgnoreCase("via_size")) {
                    this.fillWizardArray(varValue, this.via_size, this.num_metal_layers - 1, false);
                    continue;
                }
                if (varName.equalsIgnoreCase("via_size_rule")) {
                    this.fillWizardArray(varValue, this.via_size, this.num_metal_layers - 1, true);
                    continue;
                }
                if (varName.equalsIgnoreCase("via_spacing")) {
                    this.fillWizardArray(varValue, this.via_spacing, this.num_metal_layers - 1, false);
                    continue;
                }
                if (varName.equalsIgnoreCase("via_spacing_rule")) {
                    this.fillWizardArray(varValue, this.via_spacing, this.num_metal_layers - 1, true);
                    continue;
                }
                if (varName.equalsIgnoreCase("via_array_spacing")) {
                    this.fillWizardArray(varValue, this.via_array_spacing, this.num_metal_layers - 1, false);
                    continue;
                }
                if (varName.equalsIgnoreCase("via_array_spacing_rule")) {
                    this.fillWizardArray(varValue, this.via_array_spacing, this.num_metal_layers - 1, true);
                    continue;
                }
                if (varName.equalsIgnoreCase("via_overhang_inline")) {
                    this.fillWizardArray(varValue, this.via_overhang_inline, this.num_metal_layers - 1, false);
                    continue;
                }
                if (varName.equalsIgnoreCase("via_overhang_inline_rule")) {
                    this.fillWizardArray(varValue, this.via_overhang_inline, this.num_metal_layers - 1, true);
                    continue;
                }
                if (varName.equalsIgnoreCase("poly_antenna_ratio")) {
                    this.setPolyAntennaRatio(TextUtils.atof(varValue));
                    continue;
                }
                if (varName.equalsIgnoreCase("metal_antenna_ratio")) {
                    this.metal_antenna_ratio = this.makeDoubleArray(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("gds_diff_layer")) {
                    this.setGDSDiff(TextUtils.atoi(varValue));
                    continue;
                }
                if (varName.equalsIgnoreCase("gds_poly_layer")) {
                    this.setGDSPoly(TextUtils.atoi(varValue));
                    continue;
                }
                if (varName.equalsIgnoreCase("gds_nplus_layer")) {
                    this.setGDSNPlus(TextUtils.atoi(varValue));
                    continue;
                }
                if (varName.equalsIgnoreCase("gds_pplus_layer")) {
                    this.setGDSPPlus(TextUtils.atoi(varValue));
                    continue;
                }
                if (varName.equalsIgnoreCase("gds_nwell_layer")) {
                    this.setGDSNWell(TextUtils.atoi(varValue));
                    continue;
                }
                if (varName.equalsIgnoreCase("gds_contact_layer")) {
                    this.setGDSContact(TextUtils.atoi(varValue));
                    continue;
                }
                if (varName.equalsIgnoreCase("gds_metal_layer")) {
                    this.gds_metal_layer = this.makeIntArray(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("gds_via_layer")) {
                    this.gds_via_layer = this.makeIntArray(varValue);
                    continue;
                }
                if (varName.equalsIgnoreCase("gds_marking_layer")) {
                    this.setGDSMarking(TextUtils.atoi(varValue));
                    continue;
                }
                Job.getUserInterface().showErrorMessage("Unknown keyword '" + varName + "' on line " + lineReader.getLineNumber(), "Syntax Error In Technology File");
                break;
            }
            lineReader.close();
        }
        catch (IOException e) {
            System.out.println("Error reading " + fileName);
            return false;
        }
        return true;
    }

    private String stripQuotes(String str) {
        if (str.startsWith("\"") && str.endsWith("\"")) {
            return str.substring(1, str.length() - 1);
        }
        return str;
    }

    private int[] makeIntArray(String str) {
        WizardField[] foundArray = new WizardField[this.num_metal_layers];
        for (int i = 0; i < this.num_metal_layers; ++i) {
            foundArray[i] = new WizardField();
        }
        this.fillWizardArray(str, foundArray, this.num_metal_layers, false);
        int[] retArray = new int[foundArray.length];
        for (int i = 0; i < foundArray.length; ++i) {
            retArray[i] = (int)foundArray[i].v;
        }
        return retArray;
    }

    private double[] makeDoubleArray(String str) {
        WizardField[] foundArray = new WizardField[this.num_metal_layers];
        for (int i = 0; i < this.num_metal_layers; ++i) {
            foundArray[i] = new WizardField();
        }
        this.fillWizardArray(str, foundArray, this.num_metal_layers, false);
        double[] retArray = new double[foundArray.length];
        for (int i = 0; i < foundArray.length; ++i) {
            retArray[i] = foundArray[i].v;
        }
        return retArray;
    }

    private void fillWizardArray(String str, WizardField[] fieldArray, int expectedLength, boolean getRule) {
        if (!str.startsWith("(")) {
            Job.getUserInterface().showErrorMessage("Array does not start with '(' on " + str, "Syntax Error In Technology File");
            return;
        }
        int pos = 1;
        int index = 0;
        while (true) {
            if (pos < str.length() && str.charAt(pos) == ' ') {
                ++pos;
                continue;
            }
            if (index >= fieldArray.length) {
                Job.getUserInterface().showErrorMessage("Invalid metal index: " + index, "Syntax Error In Technology File");
                return;
            }
            if (getRule) {
                int end;
                if (str.charAt(pos) != '\"') {
                    Job.getUserInterface().showErrorMessage("Rule element does not start with quote on " + str, "Syntax Error In Technology File");
                    return;
                }
                for (end = ++pos; end < str.length() && str.charAt(end) != '\"'; ++end) {
                }
                if (str.charAt(end) != '\"') {
                    Job.getUserInterface().showErrorMessage("Rule element does not end with quote on " + str, "Syntax Error In Technology File");
                    return;
                }
                fieldArray[index++].rule = str.substring(pos, end);
                pos = end + 1;
            } else {
                double v = TextUtils.atof(str.substring(pos));
                fieldArray[index++].v = v;
            }
            while (pos < str.length() && str.charAt(pos) != ',' && str.charAt(pos) != ')') {
                ++pos;
            }
            if (str.charAt(pos) != ',') break;
            ++pos;
        }
    }

    public void exportData() {
        String fileName = OpenFile.chooseOutputFile(FileType.TEXT, "Technology Wizard File", "Technology.txt");
        if (fileName == null) {
            return;
        }
        try {
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
            this.dumpNumbers(printWriter);
            printWriter.close();
        }
        catch (IOException e) {
            System.out.println("Error writing XML file");
            return;
        }
    }

    private void dumpNumbers(PrintWriter pw) {
        int i;
        pw.println("#### Technology wizard data file");
        pw.println("####");
        pw.println("#### All dimensions in nanometers.");
        pw.println();
        pw.println("$tech_name = \"" + this.tech_name + "\";");
        pw.println("$tech_description = \"" + this.tech_description + "\";");
        pw.println("$num_metal_layers = " + this.num_metal_layers + ";");
        pw.println();
        pw.println("## stepsize is minimum granularity that will be used as movement grid");
        pw.println("## set to manufacturing grid or lowest common denominator with design rules");
        pw.println("$stepsize = " + this.stepsize + ";");
        pw.println();
        pw.println("######  DIFFUSION RULES  #####");
        pw.println("$diff_width = " + TextUtils.formatDouble(this.diff_width.v) + ";");
        pw.println("$diff_width_rule = \"" + this.diff_width.rule + "\";");
        pw.println("$diff_poly_overhang = " + TextUtils.formatDouble(this.diff_poly_overhang.v) + ";        # min. diff overhang from gate edge");
        pw.println("$diff_poly_overhang_rule = \"" + this.diff_poly_overhang.rule + "\";        # min. diff overhang from gate edge");
        pw.println("$diff_contact_overhang = " + TextUtils.formatDouble(this.diff_contact_overhang.v) + ";     # min. diff overhang contact");
        pw.println("$diff_contact_overhang_rule = \"" + this.diff_contact_overhang.rule + "\";     # min. diff overhang contact");
        pw.println("$diff_spacing = " + TextUtils.formatDouble(this.diff_spacing.v) + ";");
        pw.println("$diff_spacing_rule = \"" + this.diff_spacing.rule + "\";");
        pw.println();
        pw.println("######  POLY RULES  #####");
        pw.println("$poly_width = " + TextUtils.formatDouble(this.poly_width.v) + ";");
        pw.println("$poly_width_rule = \"" + this.poly_width.rule + "\";");
        pw.println("$poly_endcap = " + TextUtils.formatDouble(this.poly_endcap.v) + ";               # min. poly gate extension from edge of diffusion");
        pw.println("$poly_endcap_rule = \"" + this.poly_endcap.rule + "\";               # min. poly gate extension from edge of diffusion");
        pw.println("$poly_spacing = " + TextUtils.formatDouble(this.poly_spacing.v) + ";");
        pw.println("$poly_spacing_rule = \"" + this.poly_spacing.rule + "\";");
        pw.println("$poly_diff_spacing = " + TextUtils.formatDouble(this.poly_diff_spacing.v) + ";         # min. spacing between poly and diffusion");
        pw.println("$poly_diff_spacing_rule = \"" + this.poly_diff_spacing.rule + "\";         # min. spacing between poly and diffusion");
        pw.println();
        pw.println("######  GATE RULES  #####");
        pw.println("$gate_length = " + TextUtils.formatDouble(this.gate_length.v) + ";               # min. transistor gate length");
        pw.println("$gate_length_rule = \"" + this.gate_length.rule + "\";               # min. transistor gate length");
        pw.println("$gate_width = " + TextUtils.formatDouble(this.gate_width.v) + ";                # min. transistor gate width");
        pw.println("$gate_width_rule = \"" + this.gate_width.rule + "\";                # min. transistor gate width");
        pw.println("$gate_spacing = " + TextUtils.formatDouble(this.gate_spacing.v) + ";             # min. gate to gate spacing on diffusion");
        pw.println("$gate_spacing_rule = \"" + this.gate_spacing.rule + "\";             # min. gate to gate spacing on diffusion");
        pw.println("$gate_contact_spacing = " + TextUtils.formatDouble(this.gate_contact_spacing.v) + ";      # min. spacing from gate edge to contact inside diffusion");
        pw.println("$gate_contact_spacing_rule = \"" + this.gate_contact_spacing.rule + "\";      # min. spacing from gate edge to contact inside diffusion");
        pw.println();
        pw.println("######  CONTACT RULES  #####");
        pw.println("$contact_size = " + TextUtils.formatDouble(this.contact_size.v) + ";");
        pw.println("$contact_size_rule = \"" + this.contact_size.rule + "\";");
        pw.println("$contact_spacing = " + TextUtils.formatDouble(this.contact_spacing.v) + ";");
        pw.println("$contact_spacing_rule = \"" + this.contact_spacing.rule + "\";");
        pw.println("$contact_array_spacing = " + TextUtils.formatDouble(this.contact_array_spacing.v) + ";");
        pw.println("$contact_array_spacing_rule = \"" + this.contact_array_spacing.rule + "\";");
        pw.println("$contact_metal_overhang_inline_only = " + TextUtils.formatDouble(this.contact_metal_overhang_inline_only.v) + ";      # metal overhang when overhanging contact from two sides only");
        pw.println("$contact_metal_overhang_inline_only_rule = \"" + this.contact_metal_overhang_inline_only.rule + "\";      # metal overhang when overhanging contact from two sides only");
        pw.println("$contact_metal_overhang_all_sides = " + TextUtils.formatDouble(this.contact_metal_overhang_all_sides.v) + ";         # metal overhang when surrounding contact");
        pw.println("$contact_metal_overhang_all_sides_rule = \"" + this.contact_metal_overhang_all_sides.rule + "\";         # metal overhang when surrounding contact");
        pw.println("$contact_poly_overhang = " + TextUtils.formatDouble(this.contact_poly_overhang.v) + ";                    # poly overhang contact");
        pw.println("$contact_poly_overhang_rule = \"" + this.contact_poly_overhang.rule + "\";                    # poly overhang contact");
        pw.println("$polycon_diff_spacing = " + TextUtils.formatDouble(this.polycon_diff_spacing.v) + ";                    # spacing between poly-metal contact edge and diffusion");
        pw.println("$polycon_diff_spacing_rule = \"" + this.polycon_diff_spacing.rule + "\";                    # spacing between poly-metal contact edge and diffusion");
        pw.println();
        pw.println("######  WELL AND IMPLANT RULES  #####");
        pw.println("$nplus_width = " + TextUtils.formatDouble(this.nplus_width.v) + ";");
        pw.println("$nplus_width_rule = \"" + this.nplus_width.rule + "\";");
        pw.println("$nplus_overhang_diff = " + TextUtils.formatDouble(this.nplus_overhang_diff.v) + ";");
        pw.println("$nplus_overhang_diff_rule = \"" + this.nplus_overhang_diff.rule + "\";");
        pw.println("$nplus_overhang_poly = " + TextUtils.formatDouble(this.nplus_overhang_poly.v) + ";");
        pw.println("$nplus_overhang_poly_rule = \"" + this.nplus_overhang_poly.rule + "\";");
        pw.println("$nplus_spacing = " + TextUtils.formatDouble(this.nplus_spacing.v) + ";");
        pw.println("$nplus_spacing_rule = \"" + this.nplus_spacing.rule + "\";");
        pw.println();
        pw.println("$pplus_width = " + TextUtils.formatDouble(this.pplus_width.v) + ";");
        pw.println("$pplus_width_rule = \"" + this.pplus_width.rule + "\";");
        pw.println("$pplus_overhang_diff = " + TextUtils.formatDouble(this.pplus_overhang_diff.v) + ";");
        pw.println("$pplus_overhang_diff_rule = \"" + this.pplus_overhang_diff.rule + "\";");
        pw.println("$pplus_overhang_poly = " + TextUtils.formatDouble(this.pplus_overhang_poly.v) + ";");
        pw.println("$pplus_overhang_poly_rule = \"" + this.pplus_overhang_poly.rule + "\";");
        pw.println("$pplus_spacing = " + TextUtils.formatDouble(this.pplus_spacing.v) + ";");
        pw.println("$pplus_spacing_rule = \"" + this.pplus_spacing.rule + "\";");
        pw.println();
        pw.println("$nwell_width = " + TextUtils.formatDouble(this.nwell_width.v) + ";");
        pw.println("$nwell_width_rule = \"" + this.nwell_width.rule + "\";");
        pw.println("$nwell_overhang_diff_p = " + TextUtils.formatDouble(this.nwell_overhang_diff_p.v) + ";");
        pw.println("$nwell_overhang_diff_rule_p = \"" + this.nwell_overhang_diff_p.rule + "\";");
        pw.println("$nwell_overhang_diff_n = " + TextUtils.formatDouble(this.nwell_overhang_diff_n.v) + ";");
        pw.println("$nwell_overhang_diff_rule_n = \"" + this.nwell_overhang_diff_n.rule + "\";");
        pw.println("$nwell_spacing = " + TextUtils.formatDouble(this.nwell_spacing.v) + ";");
        pw.println("$nwell_spacing_rule = \"" + this.nwell_spacing.rule + "\";");
        pw.println();
        pw.println("######  METAL RULES  #####");
        pw.print("@metal_width = (");
        for (i = 0; i < this.num_metal_layers; ++i) {
            if (i > 0) {
                pw.print(", ");
            }
            pw.print(TextUtils.formatDouble(this.metal_width[i].v));
        }
        pw.println(");");
        pw.print("@metal_width_rule = (");
        for (i = 0; i < this.num_metal_layers; ++i) {
            if (i > 0) {
                pw.print(", ");
            }
            pw.print("\"" + this.metal_width[i].rule + "\"");
        }
        pw.println(");");
        pw.print("@metal_spacing = (");
        for (i = 0; i < this.num_metal_layers; ++i) {
            if (i > 0) {
                pw.print(", ");
            }
            pw.print(TextUtils.formatDouble(this.metal_spacing[i].v));
        }
        pw.println(");");
        pw.print("@metal_spacing_rule = (");
        for (i = 0; i < this.num_metal_layers; ++i) {
            if (i > 0) {
                pw.print(", ");
            }
            pw.print("\"" + this.metal_spacing[i].rule + "\"");
        }
        pw.println(");");
        pw.println();
        pw.println("######  VIA RULES  #####");
        pw.print("@via_size = (");
        for (i = 0; i < this.num_metal_layers - 1; ++i) {
            if (i > 0) {
                pw.print(", ");
            }
            pw.print(TextUtils.formatDouble(this.via_size[i].v));
        }
        pw.println(");");
        pw.print("@via_size_rule = (");
        for (i = 0; i < this.num_metal_layers - 1; ++i) {
            if (i > 0) {
                pw.print(", ");
            }
            pw.print("\"" + this.via_size[i].rule + "\"");
        }
        pw.println(");");
        pw.print("@via_spacing = (");
        for (i = 0; i < this.num_metal_layers - 1; ++i) {
            if (i > 0) {
                pw.print(", ");
            }
            pw.print(TextUtils.formatDouble(this.via_spacing[i].v));
        }
        pw.println(");");
        pw.print("@via_spacing_rule = (");
        for (i = 0; i < this.num_metal_layers - 1; ++i) {
            if (i > 0) {
                pw.print(", ");
            }
            pw.print("\"" + this.via_spacing[i].rule + "\"");
        }
        pw.println(");");
        pw.println();
        pw.println("## \"sep2d\" spacing, close proximity via array spacing");
        pw.print("@via_array_spacing = (");
        for (i = 0; i < this.num_metal_layers - 1; ++i) {
            if (i > 0) {
                pw.print(", ");
            }
            pw.print(TextUtils.formatDouble(this.via_array_spacing[i].v));
        }
        pw.println(");");
        pw.print("@via_array_spacing_rule = (");
        for (i = 0; i < this.num_metal_layers - 1; ++i) {
            if (i > 0) {
                pw.print(", ");
            }
            pw.print("\"" + this.via_array_spacing[i].rule + "\"");
        }
        pw.println(");");
        pw.print("@via_overhang_inline = (");
        for (i = 0; i < this.num_metal_layers - 1; ++i) {
            if (i > 0) {
                pw.print(", ");
            }
            pw.print(TextUtils.formatDouble(this.via_overhang_inline[i].v));
        }
        pw.println(");");
        pw.print("@via_overhang_inline_rule = (");
        for (i = 0; i < this.num_metal_layers - 1; ++i) {
            if (i > 0) {
                pw.print(", ");
            }
            pw.print("\"" + this.via_overhang_inline[i].rule + "\"");
        }
        pw.println(");");
        pw.println();
        pw.println("######  ANTENNA RULES  #####");
        pw.println("$poly_antenna_ratio = " + TextUtils.formatDouble(this.poly_antenna_ratio) + ";");
        pw.print("@metal_antenna_ratio = (");
        for (i = 0; i < this.num_metal_layers; ++i) {
            if (i > 0) {
                pw.print(", ");
            }
            pw.print(TextUtils.formatDouble(this.metal_antenna_ratio[i]));
        }
        pw.println(");");
        pw.println();
        pw.println("######  GDS-II LAYERS  #####");
        pw.println("$gds_diff_layer = " + this.gds_diff_layer + ";");
        pw.println("$gds_poly_layer = " + this.gds_poly_layer + ";");
        pw.println("$gds_nplus_layer = " + this.gds_nplus_layer + ";");
        pw.println("$gds_pplus_layer = " + this.gds_pplus_layer + ";");
        pw.println("$gds_nwell_layer = " + this.gds_nwell_layer + ";");
        pw.println("$gds_contact_layer = " + this.gds_contact_layer + ";");
        pw.print("@gds_metal_layer = (");
        for (i = 0; i < this.num_metal_layers; ++i) {
            if (i > 0) {
                pw.print(", ");
            }
            pw.print(this.gds_metal_layer[i]);
        }
        pw.println(");");
        pw.print("@gds_via_layer = (");
        for (i = 0; i < this.num_metal_layers - 1; ++i) {
            if (i > 0) {
                pw.print(", ");
            }
            pw.print(this.gds_via_layer[i]);
        }
        pw.println(");");
        pw.println();
        pw.println("## Device marking layer");
        pw.println("$gds_marking_layer = " + this.gds_marking_layer + ";");
        pw.println();
        pw.println("# End of techfile");
    }

    public void writeXML() {
        String errorMessage = this.errorInData();
        if (errorMessage != null) {
            Job.getUserInterface().showErrorMessage("ERROR: " + errorMessage, "Missing Technology Data");
            return;
        }
        String fileName = OpenFile.chooseOutputFile(FileType.XML, "Technology XML File", "Technology.xml");
        if (fileName == null) {
            return;
        }
        try {
            this.dumpXMLFile(fileName);
        }
        catch (IOException e) {
            System.out.println("Error writing XML file");
            return;
        }
    }

    private Xml.PrimitiveNode makeXmlPrimitivePin(List<Xml.PrimitiveNode> nodes, String name, double size, SizeOffset so, Xml.NodeLayer ... list) {
        ArrayList<Xml.NodeLayer> nodesList = new ArrayList<Xml.NodeLayer>(list.length);
        ArrayList<Xml.PrimitivePort> nodePorts = new ArrayList<Xml.PrimitivePort>();
        ArrayList<String> portNames = new ArrayList<String>();
        for (Xml.NodeLayer lb : list) {
            nodesList.add(lb);
        }
        portNames.add(name);
        nodePorts.add(this.makeXmlPrimitivePort(name.toLowerCase(), 0, 180, 0, null, 0.0, 0.0, 0.0, 0.0, portNames));
        return this.makeXmlPrimitive(nodes, name + "-Pin", PrimitiveNode.Function.PIN, size, size, 0.0, 0.0, so, nodesList, nodePorts, null, true);
    }

    private Xml.PrimitiveNode makeXmlPrimitiveCon(List<Xml.PrimitiveNode> nodes, String name, double size, SizeOffset so, List<String> portNames, Xml.NodeLayer ... list) {
        ArrayList<Xml.NodeLayer> nodesList = new ArrayList<Xml.NodeLayer>(list.length);
        ArrayList<Xml.PrimitivePort> nodePorts = new ArrayList<Xml.PrimitivePort>();
        for (Xml.NodeLayer lb : list) {
            nodesList.add(lb);
        }
        nodePorts.add(this.makeXmlPrimitivePort(name.toLowerCase(), 0, 180, 0, null, 0.0, 0.0, 0.0, 0.0, portNames));
        return this.makeXmlPrimitive(nodes, name + "-Con", PrimitiveNode.Function.CONTACT, size, size, 0.0, 0.0, so, nodesList, nodePorts, null, false);
    }

    private Xml.PrimitiveNode makeXmlPrimitive(List<Xml.PrimitiveNode> nodes, String name, PrimitiveNode.Function function, double width, double height, double ppLeft, double ppBottom, SizeOffset so, List<Xml.NodeLayer> nodeLayers, List<Xml.PrimitivePort> nodePorts, PrimitiveNode.NodeSizeRule nodeSizeRule, boolean isArcsShrink) {
        Xml.PrimitiveNode n = new Xml.PrimitiveNode();
        n.name = name;
        n.function = function;
        n.shrinkArcs = isArcsShrink;
        EPoint minFullSize = EPoint.fromLambda(0.5 * width, 0.5 * height);
        EPoint topLeft = EPoint.fromLambda(ppLeft, ppBottom + height);
        EPoint size = EPoint.fromLambda(width, height);
        double getDefWidth = width;
        double getDefHeight = height;
        if (function == PrimitiveNode.Function.PIN && isArcsShrink) {
            minFullSize = EPoint.fromLambda(ppLeft, ppBottom);
        }
        if (so != null && so.getLowXOffset() == 0.0 && so.getHighXOffset() == 0.0 && so.getLowYOffset() == 0.0 && so.getHighYOffset() == 0.0) {
            so = null;
        }
        n.sizeOffset = so;
        ERectangle baseRectangle = ERectangle.fromGrid(topLeft.getGridX(), topLeft.getGridY(), size.getGridX(), size.getGridY());
        boolean isSerp = false;
        if (nodeLayers != null) {
            n.nodeLayers.addAll(nodeLayers);
        }
        n.specialType = 0;
        if (nodeSizeRule != null) {
            n.nodeSizeRule = new Xml.NodeSizeRule();
            n.nodeSizeRule.width = nodeSizeRule.getWidth();
            n.nodeSizeRule.height = nodeSizeRule.getHeight();
            n.nodeSizeRule.rule = nodeSizeRule.getRuleName();
        }
        n.ports.addAll(nodePorts);
        nodes.add(n);
        return n;
    }

    private Xml.ArcProto makeXmlArc(List<Xml.ArcProto> arcs, String name, ArcProto.Function function, double ant, Xml.ArcLayer ... arcLayers) {
        Xml.ArcProto a = new Xml.ArcProto();
        a.name = name;
        a.function = function;
        a.wipable = true;
        a.extended = true;
        a.fixedAngle = true;
        a.angleIncrement = 90;
        a.antennaRatio = DBMath.round(ant);
        for (Xml.ArcLayer al : arcLayers) {
            a.arcLayers.add(al);
        }
        arcs.add(a);
        return a;
    }

    private Xml.Layer makeXmlLayer(List<Xml.Layer> layers, Map<Xml.Layer, WizardField> layer_width, String name, Layer.Function function, int extraf, EGraphics graph, char cifLetter, WizardField width, boolean pureLayerNode, boolean pureLayerPortArc) {
        Xml.Layer l = new Xml.Layer();
        l.name = name;
        l.function = function;
        l.extraFunction = extraf;
        l.desc = graph;
        l.thick3D = 1.0;
        l.height3D = 1.0;
        l.mode3D = "NONE";
        l.factor3D = 1.0;
        l.cif = "C" + cifLetter + cifLetter;
        l.skill = name;
        l.resistance = 1.0;
        l.capacitance = 0.0;
        l.edgeCapacitance = 0.0;
        assert (pureLayerNode || !pureLayerPortArc);
        if (pureLayerNode) {
            l.pureLayerNode = new Xml.PureLayerNode();
            l.pureLayerNode.name = name + "-Node";
            l.pureLayerNode.style = Poly.Type.FILLED;
            l.pureLayerNode.size.addLambda(this.scaledValue(width.v));
            l.pureLayerNode.port = "Port_" + name;
            if (pureLayerPortArc) {
                l.pureLayerNode.portArcs.add(name);
            }
        }
        layers.add(l);
        layer_width.put(l, width);
        return l;
    }

    private Xml.NodeLayer makeXmlNodeLayer(double lx, double hx, double ly, double hy, Xml.Layer lb, Poly.Type style, boolean electricalLayers) {
        Xml.NodeLayer nl = new Xml.NodeLayer();
        nl.layer = lb.name;
        nl.style = style;
        nl.inLayers = true;
        nl.inElectricalLayers = electricalLayers;
        nl.representation = 1;
        nl.lx.k = -1.0;
        nl.hx.k = 1.0;
        nl.ly.k = -1.0;
        nl.hy.k = 1.0;
        nl.lx.addLambda(-lx);
        nl.hx.addLambda(hx);
        nl.ly.addLambda(-ly);
        nl.hy.addLambda(hy);
        return nl;
    }

    private Xml.NodeLayer makeXmlMulticut(Xml.Layer lb, double sizeRule, double sepRule, double sepRule2D) {
        Xml.NodeLayer nl = new Xml.NodeLayer();
        nl.layer = lb.name;
        nl.style = Poly.Type.FILLED;
        nl.inElectricalLayers = true;
        nl.inLayers = true;
        nl.representation = 3;
        nl.lx.k = -1.0;
        nl.hx.k = 1.0;
        nl.ly.k = -1.0;
        nl.hy.k = 1.0;
        nl.sizex = sizeRule;
        nl.sizey = sizeRule;
        nl.sep1d = sepRule;
        nl.sep2d = sepRule2D;
        return nl;
    }

    private Xml.PrimitivePort makeXmlPrimitivePort(String name, int portAngle, int portRange, int portTopology, EPoint minFullSize, double lx, double hx, double ly, double hy, List<String> portArcs) {
        Xml.PrimitivePort ppd = new Xml.PrimitivePort();
        double lambdaX = minFullSize != null ? minFullSize.getLambdaX() : 0.0;
        double lambdaY = minFullSize != null ? minFullSize.getLambdaY() : 0.0;
        ppd.name = name;
        ppd.portAngle = portAngle;
        ppd.portRange = portRange;
        ppd.portTopology = portTopology;
        ppd.lx.k = -1.0;
        ppd.lx.addLambda(DBMath.round(lx + lambdaX * ppd.lx.k));
        ppd.hx.k = 1.0;
        ppd.hx.addLambda(DBMath.round(hx + lambdaX * ppd.hx.k));
        ppd.ly.k = -1.0;
        ppd.ly.addLambda(DBMath.round(ly + lambdaY * ppd.ly.k));
        ppd.hy.k = 1.0;
        ppd.hy.addLambda(DBMath.round(hy + lambdaY * ppd.hy.k));
        if (portArcs != null) {
            for (String s : portArcs) {
                ppd.portArcs.add(s);
            }
        }
        return ppd;
    }

    public void dumpXMLFile(String fileName) throws IOException {
        int metalNum;
        int i;
        Xml.Technology t = new Xml.Technology();
        t.techName = this.getTechName();
        t.shortTechName = this.getTechName();
        t.description = this.getTechDescription();
        t.maxNumMetals = t.defaultNumMetals = this.getNumMetalLayers();
        t.minNumMetals = t.defaultNumMetals;
        t.scaleValue = this.getStepSize();
        t.scaleRelevant = true;
        t.defaultFoundry = "NONE";
        t.minResistance = 1.0;
        t.minCapacitance = 0.1;
        Color[] metal_colour = new Color[]{new Color(0, 150, 255), new Color(148, 0, 211), new Color(255, 215, 0), new Color(132, 112, 255), new Color(255, 160, 122), new Color(34, 139, 34), new Color(178, 34, 34), new Color(34, 34, 178), new Color(153, 153, 153), new Color(102, 102, 102)};
        Color poly_colour = new Color(255, 155, 192);
        Color diff_colour = new Color(107, 226, 96);
        Color via_colour = new Color(205, 205, 205);
        Color contact_colour = new Color(40, 40, 40);
        Color nplus_colour = new Color(224, 238, 224);
        Color pplus_colour = new Color(224, 224, 120);
        Color nwell_colour = new Color(140, 140, 140);
        Color[] colorMap = new Color[]{poly_colour, diff_colour, metal_colour[0], metal_colour[1], metal_colour[2]};
        for (int i2 = 0; i2 < colorMap.length; ++i2) {
            Color transparentColor = colorMap[i2];
            t.transparentLayers.add(transparentColor);
        }
        ArrayList<Xml.Layer> metalLayers = new ArrayList<Xml.Layer>();
        ArrayList<Xml.Layer> viaLayers = new ArrayList<Xml.Layer>();
        LinkedHashMap<Xml.Layer, WizardField> layer_width = new LinkedHashMap<Xml.Layer, WizardField>();
        int[] nullPattern = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        int cifNumber = 0;
        for (i = 0; i < this.num_metal_layers; ++i) {
            metalNum = i + 1;
            double opacity = (double)(75 - metalNum * 5) / 100.0;
            int metLayHigh = i / 10;
            int metLayDig = i % 10;
            int r = metal_colour[metLayDig].getRed() * (10 - metLayHigh) / 10;
            int g = metal_colour[metLayDig].getGreen() * (10 - metLayHigh) / 10;
            int b = metal_colour[metLayDig].getBlue() * (10 - metLayHigh) / 10;
            int tcol = 0;
            int[] pattern = null;
            switch (metLayDig) {
                case 0: {
                    tcol = 3;
                    break;
                }
                case 1: {
                    tcol = 4;
                    break;
                }
                case 2: {
                    tcol = 5;
                    break;
                }
                case 3: {
                    pattern = new int[]{65535, 0, 65535, 0, 65535, 0, 65535, 0, 65535, 0, 65535, 0, 65535, 0, 65535, 0};
                    break;
                }
                case 4: {
                    pattern = new int[]{34952, 4369, 8738, 17476, 34952, 4369, 8738, 17476, 34952, 4369, 8738, 17476, 34952, 4369, 8738, 17476};
                    break;
                }
                case 5: {
                    pattern = new int[]{4369, 65535, 4369, 21845, 4369, 65535, 4369, 21845, 4369, 65535, 4369, 21845, 4369, 65535, 4369, 21845};
                    break;
                }
                case 6: {
                    pattern = new int[]{34952, 17476, 8738, 4369, 34952, 17476, 8738, 4369, 34952, 17476, 8738, 4369, 34952, 17476, 8738, 4369};
                    break;
                }
                case 7: {
                    pattern = new int[]{8738, 0, 34952, 0, 8738, 0, 34952, 0, 8738, 0, 34952, 0, 8738, 0, 34952, 0};
                    break;
                }
                case 8: {
                    pattern = new int[]{0, 8738, 0, 34952, 0, 8738, 0, 34952, 0, 8738, 0, 34952, 0, 8738, 0, 34952};
                    break;
                }
                case 9: {
                    pattern = new int[]{21845, 21845, 21845, 21845, 21845, 21845, 21845, 21845, 21845, 21845, 21845, 21845, 21845, 21845, 21845, 21845};
                }
            }
            boolean onDisplay = true;
            boolean onPrinter = true;
            if (pattern == null) {
                pattern = nullPattern;
                onDisplay = false;
                onPrinter = false;
            }
            EGraphics graph = new EGraphics(onDisplay, onPrinter, null, tcol, r, g, b, opacity, true, pattern);
            Layer.Function fun = Layer.Function.getMetal(metalNum);
            if (fun == null) {
                throw new IOException("invalid number of metals");
            }
            Xml.Layer layer = this.makeXmlLayer(t.layers, layer_width, "Metal-" + metalNum, fun, 0, graph, (char)(65 + cifNumber++), this.metal_width[i], true, true);
            metalLayers.add(layer);
        }
        for (i = 0; i < this.num_metal_layers - 1; ++i) {
            metalNum = i + 1;
            int r = via_colour.getRed();
            int g = via_colour.getGreen();
            int b = via_colour.getBlue();
            double opacity = 0.7;
            EGraphics graph = new EGraphics(false, false, null, 0, r, g, b, opacity, true, nullPattern);
            Layer.Function fun = Layer.Function.getContact(metalNum);
            if (fun == null) {
                throw new IOException("invalid number of vias");
            }
            viaLayers.add(this.makeXmlLayer(t.layers, layer_width, "Via-" + metalNum, fun, 16384, graph, (char)(65 + cifNumber++), this.via_size[i], false, false));
        }
        EGraphics graph = new EGraphics(false, false, null, 1, 0, 0, 0, 1.0, true, nullPattern);
        Xml.Layer polyLayer = this.makeXmlLayer(t.layers, layer_width, "Poly", Layer.Function.POLY1, 0, graph, (char)(65 + cifNumber++), this.poly_width, true, true);
        Xml.Layer polyGateLayer = this.makeXmlLayer(t.layers, layer_width, "PolyGate", Layer.Function.GATE, 0, graph, (char)(65 + cifNumber++), this.poly_width, false, false);
        graph = new EGraphics(false, false, null, 0, contact_colour.getRed(), contact_colour.getGreen(), contact_colour.getBlue(), 1.0, true, nullPattern);
        Xml.Layer polyCon = this.makeXmlLayer(t.layers, layer_width, "PolyCon", Layer.Function.CONTACT1, 32768, graph, (char)(65 + cifNumber++), this.contact_size, false, false);
        Xml.Layer diffCon = this.makeXmlLayer(t.layers, layer_width, "DiffCon", Layer.Function.CONTACT1, 65536, graph, (char)(65 + cifNumber++), this.contact_size, false, false);
        graph = new EGraphics(false, false, null, 2, 0, 0, 0, 1.0, true, nullPattern);
        Xml.Layer diffNLayer = this.makeXmlLayer(t.layers, layer_width, "N-Diff", Layer.Function.DIFFN, 0, graph, (char)(65 + cifNumber++), this.diff_width, true, true);
        Xml.Layer diffPLayer = this.makeXmlLayer(t.layers, layer_width, "P-Diff", Layer.Function.DIFFP, 0, graph, (char)(65 + cifNumber++), this.diff_width, true, true);
        int[] pattern = new int[]{4112, 8224, 16448, 32896, 257, 514, 1028, 2056, 4112, 8224, 16448, 32896, 257, 514, 1028, 2056};
        graph = new EGraphics(true, true, null, 0, nplus_colour.getRed(), nplus_colour.getGreen(), nplus_colour.getBlue(), 1.0, true, pattern);
        Xml.Layer nplusLayer = this.makeXmlLayer(t.layers, layer_width, "NPlus", Layer.Function.IMPLANTN, 0, graph, (char)(65 + cifNumber++), this.nplus_width, true, false);
        graph = new EGraphics(true, true, null, 0, pplus_colour.getRed(), pplus_colour.getGreen(), pplus_colour.getBlue(), 1.0, true, pattern);
        Xml.Layer pplusLayer = this.makeXmlLayer(t.layers, layer_width, "PPlus", Layer.Function.IMPLANTP, 0, graph, (char)(65 + cifNumber++), this.pplus_width, true, false);
        pattern = new int[]{514, 257, 32896, 16448, 8224, 4112, 2056, 1028, 514, 257, 32896, 16448, 8224, 4112, 2056, 1028};
        graph = new EGraphics(true, true, null, 0, nwell_colour.getRed(), nwell_colour.getGreen(), nwell_colour.getBlue(), 1.0, true, pattern);
        Xml.Layer nwellLayer = this.makeXmlLayer(t.layers, layer_width, "N-Well", Layer.Function.WELLN, 0, graph, (char)(65 + cifNumber++), this.nwell_width, true, false);
        graph = new EGraphics(false, false, null, 0, 255, 0, 0, 0.4, true, nullPattern);
        this.makeXmlLayer(t.layers, layer_width, "DeviceMark", Layer.Function.CONTROL, 0, graph, (char)(65 + cifNumber++), this.nplus_width, true, false);
        for (int i3 = 1; i3 <= this.num_metal_layers; ++i3) {
            double ant = (int)Math.round(this.metal_antenna_ratio[i3 - 1]) | 0xC8;
            this.makeXmlArc(t.arcs, "Metal-" + i3, ArcProto.Function.getContact(i3), ant, this.makeXmlArcLayer((Xml.Layer)metalLayers.get(i3 - 1), this.metal_width[i3 - 1]));
        }
        ArrayList<String> portNames = new ArrayList<String>();
        double ant = (int)Math.round(this.poly_antenna_ratio) | 0xC8;
        this.makeXmlArc(t.arcs, "Poly", ArcProto.Function.getPoly(1), ant, this.makeXmlArcLayer(polyLayer, this.poly_width));
        double hla = this.scaledValue(this.poly_width.v / 2.0);
        this.makeXmlPrimitivePin(t.nodes, polyLayer.name, hla, null, this.makeXmlNodeLayer(hla, hla, hla, hla, polyLayer, Poly.Type.CROSSED, true));
        portNames.clear();
        portNames.add(polyLayer.name);
        portNames.add(((Xml.Layer)metalLayers.get((int)0)).name);
        hla = this.scaledValue(this.contact_size.v / 2.0 + this.contact_poly_overhang.v);
        Xml.Layer m1Layer = (Xml.Layer)metalLayers.get(0);
        double contSize = this.scaledValue(this.contact_size.v);
        double contSpacing = this.scaledValue(this.contact_spacing.v);
        double contArraySpacing = this.scaledValue(this.contact_array_spacing.v);
        double metal1Over = this.scaledValue(this.contact_size.v / 2.0 + this.contact_metal_overhang_all_sides.v);
        this.makeXmlPrimitiveCon(t.nodes, polyLayer.name, hla, null, portNames, this.makeXmlNodeLayer(metal1Over, metal1Over, metal1Over, metal1Over, m1Layer, Poly.Type.FILLED, true), this.makeXmlNodeLayer(hla, hla, hla, hla, polyLayer, Poly.Type.FILLED, true), this.makeXmlMulticut(diffCon, contSize, contSpacing, contArraySpacing));
        this.makeXmlArc(t.arcs, "N-Diff", ArcProto.Function.DIFFN, 0.0, this.makeXmlArcLayer(diffNLayer, this.diff_width), this.makeXmlArcLayer(nplusLayer, this.diff_width, this.nplus_overhang_diff));
        this.makeXmlArc(t.arcs, "P-Diff", ArcProto.Function.DIFFP, 0.0, this.makeXmlArcLayer(diffPLayer, this.diff_width), this.makeXmlArcLayer(pplusLayer, this.diff_width, this.pplus_overhang_diff), this.makeXmlArcLayer(nwellLayer, this.diff_width, this.nwell_overhang_diff_p));
        hla = this.scaledValue(this.contact_size.v / 2.0 + this.diff_contact_overhang.v);
        double nsel = this.scaledValue(this.contact_size.v / 2.0 + this.diff_contact_overhang.v + this.nplus_overhang_diff.v);
        double psel = this.scaledValue(this.contact_size.v / 2.0 + this.diff_contact_overhang.v + this.pplus_overhang_diff.v);
        double nwell = this.scaledValue(this.contact_size.v / 2.0 + this.diff_contact_overhang.v + this.nwell_overhang_diff_p.v);
        double nso = this.scaledValue(this.nwell_overhang_diff_p.v);
        double pso = this.scaledValue(this.nplus_overhang_diff.v);
        this.makeXmlPrimitivePin(t.nodes, "N-Diff", hla, new SizeOffset(pso, pso, pso, pso), this.makeXmlNodeLayer(hla, hla, hla, hla, diffNLayer, Poly.Type.CROSSED, true), this.makeXmlNodeLayer(nsel, nsel, nsel, nsel, nplusLayer, Poly.Type.CROSSED, true));
        this.makeXmlPrimitivePin(t.nodes, "P-Diff", hla, new SizeOffset(nso, nso, nso, nso), this.makeXmlNodeLayer(hla, hla, hla, hla, diffPLayer, Poly.Type.CROSSED, true), this.makeXmlNodeLayer(psel, psel, psel, psel, pplusLayer, Poly.Type.CROSSED, true), this.makeXmlNodeLayer(nwell, nwell, nwell, nwell, nwellLayer, Poly.Type.CROSSED, true));
        hla = this.scaledValue(this.contact_size.v / 2.0 + this.diff_contact_overhang.v);
        portNames.clear();
        portNames.add(diffNLayer.name);
        portNames.add(m1Layer.name);
        this.makeXmlPrimitiveCon(t.nodes, "N-Diff", hla, new SizeOffset(pso, pso, pso, pso), portNames, this.makeXmlNodeLayer(metal1Over, metal1Over, metal1Over, metal1Over, m1Layer, Poly.Type.FILLED, true), this.makeXmlNodeLayer(hla, hla, hla, hla, diffNLayer, Poly.Type.FILLED, true), this.makeXmlNodeLayer(nsel, nsel, nsel, nsel, nplusLayer, Poly.Type.FILLED, true), this.makeXmlMulticut(diffCon, contSize, contSpacing, contArraySpacing));
        portNames.clear();
        portNames.add(diffPLayer.name);
        portNames.add(m1Layer.name);
        this.makeXmlPrimitiveCon(t.nodes, "P-Diff", hla, new SizeOffset(nso, nso, nso, nso), portNames, this.makeXmlNodeLayer(metal1Over, metal1Over, metal1Over, metal1Over, m1Layer, Poly.Type.FILLED, true), this.makeXmlNodeLayer(hla, hla, hla, hla, diffPLayer, Poly.Type.FILLED, true), this.makeXmlNodeLayer(psel, psel, psel, psel, pplusLayer, Poly.Type.FILLED, true), this.makeXmlNodeLayer(nwell, nwell, nwell, nwell, nwellLayer, Poly.Type.FILLED, true), this.makeXmlMulticut(diffCon, contSize, contSpacing, contArraySpacing));
        nwell = this.scaledValue(this.contact_size.v / 2.0 + this.diff_contact_overhang.v + this.nwell_overhang_diff_n.v);
        nso = this.scaledValue(this.nwell_overhang_diff_n.v);
        portNames.clear();
        portNames.add(diffNLayer.name);
        portNames.add(m1Layer.name);
        this.makeXmlPrimitiveCon(t.nodes, "P-Well", hla, new SizeOffset(pso, pso, pso, pso), portNames, this.makeXmlNodeLayer(metal1Over, metal1Over, metal1Over, metal1Over, m1Layer, Poly.Type.FILLED, true), this.makeXmlNodeLayer(hla, hla, hla, hla, diffPLayer, Poly.Type.FILLED, true), this.makeXmlNodeLayer(nsel, psel, psel, psel, pplusLayer, Poly.Type.FILLED, true), this.makeXmlMulticut(diffCon, contSize, contSpacing, contArraySpacing));
        portNames.clear();
        portNames.add(diffPLayer.name);
        portNames.add(m1Layer.name);
        this.makeXmlPrimitiveCon(t.nodes, "N-Well", hla, new SizeOffset(nso, nso, nso, nso), portNames, this.makeXmlNodeLayer(metal1Over, metal1Over, metal1Over, metal1Over, m1Layer, Poly.Type.FILLED, true), this.makeXmlNodeLayer(hla, hla, hla, hla, diffNLayer, Poly.Type.FILLED, true), this.makeXmlNodeLayer(nsel, nsel, nsel, nsel, nplusLayer, Poly.Type.FILLED, true), this.makeXmlNodeLayer(nwell, nwell, nwell, nwell, nwellLayer, Poly.Type.FILLED, true), this.makeXmlMulticut(diffCon, contSize, contSpacing, contArraySpacing));
        for (int i4 = 1; i4 < this.num_metal_layers; ++i4) {
            hla = this.scaledValue(this.metal_width[i4 - 1].v / 2.0);
            Xml.Layer lb = (Xml.Layer)metalLayers.get(i4 - 1);
            this.makeXmlPrimitivePin(t.nodes, lb.name, hla, null, this.makeXmlNodeLayer(hla, hla, hla, hla, lb, Poly.Type.CROSSED, true));
            double metalW = this.via_size[i4 - 1].v / 2.0 + this.contact_metal_overhang_all_sides.v;
            hla = this.scaledValue(metalW);
            Xml.Layer lt = (Xml.Layer)metalLayers.get(i4);
            Xml.Layer via = (Xml.Layer)viaLayers.get(i4 - 1);
            double viaSize = this.scaledValue(this.via_size[i4 - 1].v);
            double viaSpacing = this.scaledValue(this.via_spacing[i4 - 1].v);
            double viaArraySpacing = this.scaledValue(this.via_array_spacing[i4 - 1].v);
            String name = lb.name + "-" + lt.name;
            portNames.clear();
            portNames.add(lt.name);
            portNames.add(lb.name);
            this.makeXmlPrimitiveCon(t.nodes, name, hla, null, portNames, this.makeXmlNodeLayer(hla, hla, hla, hla, lb, Poly.Type.FILLED, true), this.makeXmlNodeLayer(hla, hla, hla, hla, lt, Poly.Type.FILLED, true), this.makeXmlMulticut(via, viaSize, viaSpacing, viaArraySpacing));
        }
        ArrayList<Xml.NodeLayer> nodesList = new ArrayList<Xml.NodeLayer>();
        ArrayList<Xml.PrimitivePort> nodePorts = new ArrayList<Xml.PrimitivePort>();
        EPoint minFullSize = null;
        for (int i5 = 0; i5 < 2; ++i5) {
            Xml.Layer selectLayer;
            Xml.Layer activeLayer;
            String name;
            double selecty = 0.0;
            double selectx = 0.0;
            Xml.Layer wellLayer = null;
            double sox = 0.0;
            double soy = 0.0;
            double width = this.scaledValue(this.gate_width.v);
            double length = this.scaledValue(this.gate_length.v);
            double impx = this.scaledValue(this.gate_width.v / 2.0);
            double impy = this.scaledValue((this.gate_length.v + this.diff_poly_overhang.v * 2.0) / 2.0);
            double wellx = this.scaledValue(this.gate_width.v / 2.0 + this.nwell_overhang_diff_p.v);
            double welly = this.scaledValue(this.gate_length.v / 2.0 + this.diff_poly_overhang.v + this.nwell_overhang_diff_p.v);
            if (i5 == 0) {
                name = "P";
                wellLayer = nwellLayer;
                activeLayer = diffPLayer;
                selectLayer = pplusLayer;
                sox = this.scaledValue(this.nwell_overhang_diff_p.v);
                soy = this.scaledValue(this.diff_poly_overhang.v + this.nwell_overhang_diff_p.v);
                selectx = this.scaledValue(this.gate_width.v / 2.0 + (this.poly_endcap.v + this.pplus_overhang_poly.v));
                selecty = this.scaledValue(this.gate_length.v / 2.0 + this.diff_poly_overhang.v + this.pplus_overhang_diff.v);
            } else {
                name = "N";
                activeLayer = diffNLayer;
                selectLayer = nplusLayer;
                sox = this.scaledValue(this.poly_endcap.v + this.pplus_overhang_poly.v);
                soy = this.scaledValue(this.diff_poly_overhang.v + this.pplus_overhang_diff.v);
                selectx = this.scaledValue(this.gate_width.v / 2.0 + (this.poly_endcap.v + this.nplus_overhang_poly.v));
                selecty = this.scaledValue(this.gate_length.v / 2.0 + this.diff_poly_overhang.v + this.nplus_overhang_diff.v);
            }
            nodesList.clear();
            nodePorts.clear();
            portNames.clear();
            if (wellLayer != null) {
                nodesList.add(this.makeXmlNodeLayer(wellx, wellx, welly, welly, wellLayer, Poly.Type.FILLED, true));
            }
            nodesList.add(this.makeXmlNodeLayer(impx, impx, impy, impy, activeLayer, Poly.Type.FILLED, true));
            portNames.clear();
            portNames.add(activeLayer.name);
            nodePorts.add(this.makeXmlPrimitivePort("trans-diff-top", 90, 90, 0, minFullSize, 0.0, 0.0, impy, impy, portNames));
            nodePorts.add(this.makeXmlPrimitivePort("trans-diff-bottom", 270, 90, 0, minFullSize, 0.0, 0.0, -impy, -impy, portNames));
            double gatey = this.scaledValue(this.gate_length.v / 2.0);
            nodesList.add(this.makeXmlNodeLayer(impx, impx, gatey, gatey, polyGateLayer, Poly.Type.FILLED, true));
            double endPoly = this.scaledValue((this.gate_width.v + this.poly_endcap.v * 2.0) / 2.0);
            nodesList.add(this.makeXmlNodeLayer(endPoly, -impx, gatey, gatey, polyLayer, Poly.Type.FILLED, true));
            nodesList.add(this.makeXmlNodeLayer(-impx, endPoly, gatey, gatey, polyLayer, Poly.Type.FILLED, true));
            nodesList.add(this.makeXmlNodeLayer(endPoly, endPoly, gatey, gatey, polyLayer, Poly.Type.FILLED, false));
            portNames.clear();
            portNames.add(polyLayer.name);
            nodePorts.add(this.makeXmlPrimitivePort("trans-poly-left", 180, 90, 0, minFullSize, -endPoly, -endPoly, 0.0, 0.0, portNames));
            nodePorts.add(this.makeXmlPrimitivePort("trans-poly-right", 0, 180, 0, minFullSize, endPoly, endPoly, 0.0, 0.0, portNames));
            nodesList.add(this.makeXmlNodeLayer(selectx, selectx, selecty, selecty, selectLayer, Poly.Type.FILLED, true));
            this.makeXmlPrimitive(t.nodes, name + "-Transistor", PrimitiveNode.Function.TRANMOS, 0.0, 0.0, 0.0, 0.0, new SizeOffset(sox, sox, soy, soy), nodesList, nodePorts, null, false);
        }
        Xml.Foundry f = new Xml.Foundry();
        f.name = Foundry.Type.NONE.name();
        t.foundries.add(f);
        this.makeLayerRuleMinWid(t, diffPLayer, this.diff_width);
        this.makeLayerRuleMinWid(t, diffNLayer, this.diff_width);
        this.makeLayerRuleMinWid(t, pplusLayer, this.pplus_width);
        this.makeLayersRuleSurround(t, pplusLayer, diffPLayer, this.pplus_overhang_diff);
        this.makeLayerRuleMinWid(t, nplusLayer, this.nplus_width);
        this.makeLayersRuleSurround(t, nplusLayer, diffNLayer, this.nplus_overhang_diff);
        this.makeLayerRuleMinWid(t, nwellLayer, this.nwell_width);
        this.makeLayersRuleSurround(t, nwellLayer, diffPLayer, this.nwell_overhang_diff_p);
        this.makeLayersRuleSurround(t, nwellLayer, diffNLayer, this.nwell_overhang_diff_n);
        this.makeLayerRuleMinWid(t, polyLayer, this.poly_width);
        for (int i6 = 0; i6 < this.num_metal_layers; ++i6) {
            Xml.Layer met = (Xml.Layer)metalLayers.get(i6);
            this.makeLayerRuleMinWid(t, met, this.metal_width[i6]);
            if (i6 >= this.num_metal_layers - 1) continue;
            Xml.Layer via = (Xml.Layer)viaLayers.get(i6);
            this.makeLayerRuleMinWid(t, via, this.via_size[i6]);
            this.makeLayersRule(t, via, DRCTemplate.DRCRuleType.CONSPA, this.via_spacing[i6]);
            this.makeLayersRule(t, via, DRCTemplate.DRCRuleType.UCONSPA2D, this.via_array_spacing[i6]);
        }
        t.writeXml(fileName);
    }

    private Xml.ArcLayer makeXmlArcLayer(Xml.Layer layer, WizardField ... flds) {
        Xml.ArcLayer al = new Xml.ArcLayer();
        al.layer = layer.name;
        al.style = Poly.Type.FILLED;
        for (int i = 0; i < flds.length; ++i) {
            al.extend.addLambda(this.scaledValue(flds[i].v / 2.0));
        }
        return al;
    }

    private void makeLayerRuleMinWid(Xml.Technology t, Xml.Layer l, WizardField fld) {
        for (Xml.Foundry f : t.foundries) {
            f.rules.add(new DRCTemplate(fld.rule, DRCTemplate.DRCMode.ALL.mode(), DRCTemplate.DRCRuleType.MINWID, l.name, null, new double[]{this.scaledValue(fld.v)}, null, null));
        }
    }

    private void makeLayersRule(Xml.Technology t, Xml.Layer l, DRCTemplate.DRCRuleType ruleType, WizardField fld) {
        for (Xml.Foundry f : t.foundries) {
            f.rules.add(new DRCTemplate(fld.rule, DRCTemplate.DRCMode.ALL.mode(), ruleType, l.name, l.name, new double[]{this.scaledValue(fld.v)}, null, null));
        }
    }

    private void makeLayersRuleSurround(Xml.Technology t, Xml.Layer l1, Xml.Layer l2, WizardField fld) {
        double value = this.scaledValue(fld.v);
        for (Xml.Foundry f : t.foundries) {
            f.rules.add(new DRCTemplate(fld.rule, DRCTemplate.DRCMode.ALL.mode(), DRCTemplate.DRCRuleType.SURROUND, l1.name, l2.name, new double[]{value, value}, null, null));
        }
    }

    private double scaledValue(double val) {
        return DBMath.round(val / (double)this.stepsize);
    }
}

