/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.options;

import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.user.Resources;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.ColorPatternPanel;
import com.sun.electric.tool.user.dialogs.options.PreferencePanel;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class LayersTab
extends PreferencePanel {
    private Map<Layer, ColorPatternPanel.Info> layerMap;
    private Map<String, ColorPatternPanel.Info> transAndSpecialMap;
    private Map<User.ColorPrefType, String> nameTypeSpecialMap;
    private Map<Technology, Color[]> colorMapMap;
    private ColorPatternPanel colorAndPatternPanel;
    private JComboBox layerName;
    private JLabel layerTechName;
    private JLabel layerTechName1;
    private JPanel layers;
    private JComboBox technology;

    private void resetColorPanelInfo(ColorPatternPanel.Info cpi) {
        int factoryColor = -1;
        if (cpi.graphics != null) {
            cpi.useStippleDisplay = cpi.graphics.isFactoryPatternedOnDisplay();
            cpi.useStipplePrinter = cpi.graphics.isFactoryPatternedOnPrinter();
            cpi.outlinePatternDisplay = cpi.graphics.getFactoryOutlined();
            cpi.transparentLayer = cpi.graphics.getFactoryTransparentLayer();
            cpi.pattern = cpi.graphics.getFactoryPattern();
            cpi.opacity = cpi.graphics.getFactoryOpacity();
            factoryColor = cpi.graphics.getFactoryColor();
        } else {
            factoryColor = cpi.theColor.getIntFactoryValue();
        }
        cpi.red = factoryColor >> 16 & 0xFF;
        cpi.green = factoryColor >> 8 & 0xFF;
        cpi.blue = factoryColor & 0xFF;
    }

    public LayersTab(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.colorAndPatternPanel = new ColorPatternPanel(true);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridwidth = 4;
        gbc.gridheight = 1;
        gbc.insets = new Insets(4, 4, 4, 4);
        this.layers.add((Component)this.colorAndPatternPanel, gbc);
        this.layerMap = new HashMap<Layer, ColorPatternPanel.Info>();
        this.transAndSpecialMap = new HashMap<String, ColorPatternPanel.Info>();
        this.nameTypeSpecialMap = new HashMap<User.ColorPrefType, String>();
        this.colorMapMap = new HashMap<Technology, Color[]>();
        this.layerName.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LayersTab.this.layerSelected();
            }
        });
        Iterator<Technology> it = Technology.getTechnologies();
        while (it.hasNext()) {
            Technology tech = it.next();
            this.technology.addItem(tech.getTechName());
        }
        this.technology.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LayersTab.this.setTechnology();
            }
        });
    }

    public JPanel getPanel() {
        return this.layers;
    }

    public String getName() {
        return "Layers";
    }

    public void init() {
        Iterator<Technology> it = Technology.getTechnologies();
        while (it.hasNext()) {
            Technology tech = it.next();
            Iterator<Layer> lIt = tech.getLayers();
            while (lIt.hasNext()) {
                Layer layer = lIt.next();
                if (layer.isPseudoLayer() && layer.getNonPseudoLayer() != layer) continue;
                this.layerName.addItem(layer.getName());
                ColorPatternPanel.Info li = new ColorPatternPanel.Info(layer.getGraphics());
                this.layerMap.put(layer, li);
            }
            Color[] map = new Color[tech.getNumTransparentLayers()];
            Color[] fullMap = tech.getColorMap();
            for (int i = 0; i < map.length; ++i) {
                map[i] = fullMap[1 << i];
            }
            this.colorMapMap.put(tech, map);
        }
        this.nameTypeSpecialMap.put(User.ColorPrefType.BACKGROUND, "Special: BACKGROUND");
        this.nameTypeSpecialMap.put(User.ColorPrefType.GRID, "Special: GRID");
        this.nameTypeSpecialMap.put(User.ColorPrefType.HIGHLIGHT, "Special: HIGHLIGHT");
        this.nameTypeSpecialMap.put(User.ColorPrefType.NODE_HIGHLIGHT, "Special: NODE HIGHLIGHT");
        this.nameTypeSpecialMap.put(User.ColorPrefType.MOUSEOVER_HIGHLIGHT, "Special: MOUSE-OVER HIGHLIGHT");
        this.nameTypeSpecialMap.put(User.ColorPrefType.PORT_HIGHLIGHT, "Special: PORT HIGHLIGHT");
        this.nameTypeSpecialMap.put(User.ColorPrefType.TEXT, "Special: TEXT");
        this.nameTypeSpecialMap.put(User.ColorPrefType.INSTANCE, "Special: INSTANCE OUTLINES");
        this.nameTypeSpecialMap.put(User.ColorPrefType.ARTWORK, "Special: DEFAULT ARTWORK");
        this.nameTypeSpecialMap.put(User.ColorPrefType.DOWNINPLACEBORDER, "Special: DOWN-IN-PLACE BORDER");
        this.nameTypeSpecialMap.put(User.ColorPrefType.WAVE_BACKGROUND, "Special: WAVEFORM BACKGROUND");
        this.nameTypeSpecialMap.put(User.ColorPrefType.WAVE_FOREGROUND, "Special: WAVEFORM FOREGROUND");
        this.nameTypeSpecialMap.put(User.ColorPrefType.WAVE_STIMULI, "Special: WAVEFORM STIMULI");
        this.nameTypeSpecialMap.put(User.ColorPrefType.WAVE_OFF_STRENGTH, "Special: WAVEFORM OFF STRENGTH");
        this.nameTypeSpecialMap.put(User.ColorPrefType.WAVE_NODE_STRENGTH, "Special: WAVEFORM NODE (WEAK) STRENGTH");
        this.nameTypeSpecialMap.put(User.ColorPrefType.WAVE_GATE_STRENGTH, "Special: WAVEFORM GATE STRENGTH");
        this.nameTypeSpecialMap.put(User.ColorPrefType.WAVE_POWER_STRENGTH, "Special: WAVEFORM POWER STRENGTH");
        this.nameTypeSpecialMap.put(User.ColorPrefType.WAVE_CROSS_LOW, "Special: WAVEFORM CROSSPROBE LOW");
        this.nameTypeSpecialMap.put(User.ColorPrefType.WAVE_CROSS_HIGH, "Special: WAVEFORM CROSSPROBE HIGH");
        this.nameTypeSpecialMap.put(User.ColorPrefType.WAVE_CROSS_UNDEF, "Special: WAVEFORM CROSSPROBE UNDEFINED");
        this.nameTypeSpecialMap.put(User.ColorPrefType.WAVE_CROSS_FLOAT, "Special: WAVEFORM CROSSPROBE FLOATING");
        for (User.ColorPrefType type : User.ColorPrefType.values()) {
            this.transAndSpecialMap.put(this.nameTypeSpecialMap.get((Object)type), new ColorPatternPanel.Info(User.getColorPref(type)));
        }
        try {
            Class j3DUtilsClass = Resources.get3DClass("utils.J3DUtils");
            if (j3DUtilsClass != null) {
                Method setMethod = j3DUtilsClass.getDeclaredMethod("get3DColorsInTab", Map.class);
                setMethod.invoke((Object)j3DUtilsClass, this.transAndSpecialMap);
            } else {
                System.out.println("Cannot call 3D plugin method get3DColorsInTab");
            }
        }
        catch (Exception e) {
            System.out.println("Cannot call 3D plugin method get3DColorsInTab");
            e.printStackTrace();
        }
        this.technology.setSelectedItem(Technology.getCurrent().getTechName());
    }

    private void setTechnology() {
        String techName = (String)this.technology.getSelectedItem();
        Technology tech = Technology.findTechnology(techName);
        if (tech == null) {
            return;
        }
        Color[] map = this.colorMapMap.get(tech);
        this.colorAndPatternPanel.setColorMap(map);
        this.layerName.removeAllItems();
        Iterator<Layer> lIt = tech.getLayers();
        while (lIt.hasNext()) {
            Layer layer = lIt.next();
            if (layer.isPseudoLayer() && layer.getNonPseudoLayer() != layer) continue;
            this.layerName.addItem(layer.getName());
        }
        ArrayList<String> specialList = new ArrayList<String>();
        for (String name : this.transAndSpecialMap.keySet()) {
            specialList.add(name);
        }
        Collections.sort(specialList, TextUtils.STRING_NUMBER_ORDER);
        for (String name : specialList) {
            this.layerName.addItem(name);
        }
        this.layerSelected();
    }

    private void layerSelected() {
        String techName = (String)this.technology.getSelectedItem();
        Technology tech = Technology.findTechnology(techName);
        if (tech == null) {
            return;
        }
        String name = (String)this.layerName.getSelectedItem();
        ColorPatternPanel.Info li = this.transAndSpecialMap.get(name);
        Layer layer = null;
        if (li == null) {
            layer = tech.findLayer(name);
            li = this.layerMap.get(layer);
        }
        if (li == null) {
            return;
        }
        this.colorAndPatternPanel.setColorPattern(li);
        String otherLayers = null;
        if (li.transparentLayer > 0 && layer != null) {
            Iterator<Layer> it = tech.getLayers();
            while (it.hasNext()) {
                ColorPatternPanel.Info oLi;
                Layer oLayer = it.next();
                if (oLayer == layer || (oLi = this.layerMap.get(oLayer)) == null || oLi.transparentLayer != li.transparentLayer) continue;
                if (otherLayers == null) {
                    otherLayers = oLayer.getName();
                    continue;
                }
                otherLayers = otherLayers + ", " + oLayer.getName();
            }
        }
        this.colorAndPatternPanel.setOtherTransparentLayerNames(otherLayers);
    }

    public void term() {
        boolean changed = false;
        Iterator<Technology> it = Technology.getTechnologies();
        while (it.hasNext()) {
            Technology tech = it.next();
            Iterator<Layer> lIt = tech.getLayers();
            while (lIt.hasNext()) {
                ColorPatternPanel.Info altLI;
                Layer layer = lIt.next();
                ColorPatternPanel.Info li = this.layerMap.get(layer);
                EGraphics graphics = layer.getGraphics();
                if (layer.isPseudoLayer() && (altLI = this.layerMap.get(layer.getNonPseudoLayer())) != null) {
                    li = altLI;
                }
                if (!li.updateGraphics(graphics)) continue;
                changed = true;
            }
            Color[] fullOrigMap = tech.getColorMap();
            Color[] origMap = new Color[tech.getNumTransparentLayers()];
            for (int i = 0; i < origMap.length; ++i) {
                origMap[i] = fullOrigMap[1 << i];
            }
            boolean mapChanged = false;
            Color[] map = this.colorMapMap.get(tech);
            for (int i = 0; i < map.length; ++i) {
                if (map[i].getRGB() == origMap[i].getRGB()) continue;
                mapChanged = true;
            }
            if (!mapChanged) continue;
            tech.setColorMapFromLayers(map);
        }
        for (User.ColorPrefType type : User.ColorPrefType.values()) {
            int c = this.specialMapColor(this.nameTypeSpecialMap.get((Object)type), User.getColor(type));
            if (c < 0) continue;
            User.setColor(type, c);
            changed = true;
        }
        try {
            Class j3DUtilsClass = Resources.get3DClass("utils.J3DUtils");
            Method setMethod = j3DUtilsClass.getDeclaredMethod("set3DColorsInTab", LayersTab.class);
            Object color3DChanged = setMethod.invoke((Object)j3DUtilsClass, this);
            if (!changed && color3DChanged != null) {
                changed = (Boolean)color3DChanged;
            }
        }
        catch (Exception e) {
            System.out.println("Cannot call 3D plugin method set3DColorsInTab: " + e.getMessage());
            e.printStackTrace();
        }
        if (changed) {
            WindowFrame.repaintAllWindows();
        }
    }

    public boolean resetThis() {
        for (Layer layer : this.layerMap.keySet()) {
            ColorPatternPanel.Info cpi = this.layerMap.get(layer);
            this.resetColorPanelInfo(cpi);
        }
        for (ColorPatternPanel.Info cpi : this.transAndSpecialMap.values()) {
            this.resetColorPanelInfo(cpi);
        }
        Iterator<Technology> it = Technology.getTechnologies();
        while (it.hasNext()) {
            Technology tech = it.next();
            Color[] map = new Color[tech.getNumTransparentLayers()];
            Color[] fullMap = tech.getFactoryColorMap();
            for (int i = 0; i < map.length; ++i) {
                map[i] = fullMap[1 << i];
            }
            this.colorMapMap.put(tech, map);
        }
        this.colorAndPatternPanel.setColorPattern(null);
        this.setTechnology();
        return true;
    }

    public void reset() {
        Iterator<Technology> it = Technology.getTechnologies();
        while (it.hasNext()) {
            Color[] transColors;
            boolean reload;
            Technology tech = it.next();
            Color[] transColorsFactory = tech.getFactoryTransparentLayerColors();
            boolean bl = reload = transColorsFactory.length != (transColors = tech.getTransparentLayerColors()).length;
            if (!reload) {
                for (int i = 0; i < transColors.length; ++i) {
                    if (transColorsFactory[i].getRGB() == transColors[i].getRGB()) continue;
                    reload = true;
                }
            }
            if (reload) {
                tech.setColorMapFromLayers(transColorsFactory);
            }
            Iterator<Layer> lIt = tech.getLayers();
            while (lIt.hasNext()) {
                Layer layer = lIt.next();
                if (layer.isPseudoLayer() && layer.getNonPseudoLayer() != layer) continue;
                layer.factoryResetGraphics();
            }
        }
        for (User.ColorPrefType type : this.nameTypeSpecialMap.keySet()) {
            String name = this.nameTypeSpecialMap.get((Object)type);
            ColorPatternPanel.Info cpi = this.transAndSpecialMap.get(name);
            int factory = cpi.theColor.getIntFactoryValue();
            if (factory == cpi.theColor.getInt()) continue;
            cpi.theColor.setInt(factory);
            User.setColor(type, factory);
        }
    }

    public int specialMapColor(String title, int curColor) {
        ColorPatternPanel.Info li = this.transAndSpecialMap.get(title);
        if (li == null) {
            return -1;
        }
        int newColor = li.red << 16 | li.green << 8 | li.blue;
        if (newColor != curColor) {
            return newColor;
        }
        return -1;
    }

    private void initComponents() {
        this.layers = new JPanel();
        this.layerName = new JComboBox();
        this.layerTechName = new JLabel();
        this.technology = new JComboBox();
        this.layerTechName1 = new JLabel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Edit Options");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                LayersTab.this.closeDialog(evt);
            }
        });
        this.layers.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.layers.add((Component)this.layerName, gridBagConstraints);
        this.layerTechName.setText("Layer:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.layers.add((Component)this.layerTechName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.layers.add((Component)this.technology, gridBagConstraints);
        this.layerTechName1.setText("Technology:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.layers.add((Component)this.layerTechName1, gridBagConstraints);
        this.getContentPane().add((Component)this.layers, new GridBagConstraints());
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }
}

