/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import com.sun.electric.database.geometry.GenMath;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.tool.simulation.AnalogAnalysis;
import com.sun.electric.tool.simulation.AnalogSignal;
import com.sun.electric.tool.simulation.Signal;
import com.sun.electric.tool.simulation.Stimuli;
import com.sun.electric.tool.simulation.Waveform;
import com.sun.electric.tool.simulation.WaveformImpl;
import com.sun.electric.tool.user.ActivityLogger;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EpicAnalysis
extends AnalogAnalysis {
    static final char separator = '.';
    static final byte VOLTAGE_TYPE = 1;
    static final byte CURRENT_TYPE = 2;
    static final Context VOLTAGE_CONTEXT = new Context(1);
    static final Context CURRENT_CONTEXT = new Context(2);
    private File waveFileName;
    private RandomAccessFile waveFile;
    int[] waveStarts;
    int[] waveLengths;
    private double timeResolution;
    private double voltageResolution;
    private double currentResolution;
    private double maxTime;
    private List<AnalogSignal> signalsUnmodifiable;
    private BitSet voltageSignals = new BitSet();
    private Context rootContext;
    private Context[] contextHash = new Context[1];
    private int numContexts = 0;
    private static Comparator<EpicTreeNode> TREE_NODE_ORDER = new Comparator<EpicTreeNode>(){

        @Override
        public int compare(EpicTreeNode tn1, EpicTreeNode tn2) {
            int cmp = tn1.context.type - tn2.context.type;
            if (cmp != 0) {
                return cmp;
            }
            return TextUtils.STRING_NUMBER_ORDER.compare(tn1.name, tn2.name);
        }
    };

    EpicAnalysis(Stimuli sd) {
        super(sd, AnalogAnalysis.ANALYSIS_TRANS, false);
        this.signalsUnmodifiable = Collections.unmodifiableList(super.getSignals());
    }

    void setTimeResolution(double timeResolution) {
        this.timeResolution = timeResolution;
    }

    void setVoltageResolution(double voltageResolution) {
        this.voltageResolution = voltageResolution;
    }

    void setCurrentResolution(double currentResolution) {
        this.currentResolution = currentResolution;
    }

    double getValueResolution(int signalIndex) {
        return this.voltageSignals.get(signalIndex) ? this.voltageResolution : this.currentResolution;
    }

    void setMaxTime(double maxTime) {
        this.maxTime = maxTime;
    }

    void setRootContext(Context context) {
        this.rootContext = context;
    }

    void setWaveFile(File waveFileName) throws FileNotFoundException {
        this.waveFileName = waveFileName;
        waveFileName.deleteOnExit();
        this.waveFile = new RandomAccessFile(waveFileName, "r");
    }

    @Override
    public void finished() {
        try {
            this.waveFile.close();
            this.waveFileName.delete();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public AnalogSignal findSignalForNetworkQuickly(String netName) {
        AnalogSignal old = (AnalogSignal)super.findSignalForNetworkQuickly(netName);
        String lookupName = TextUtils.canonicString(netName);
        int index = this.searchName(lookupName);
        if (index < 0) {
            assert (old == null);
            return null;
        }
        AnalogSignal sig = this.signalsUnmodifiable.get(index);
        return sig;
    }

    @Override
    public List<AnalogSignal> getSignalsFromExtractedNet(Signal ws) {
        ArrayList<AnalogSignal> ret = new ArrayList<AnalogSignal>();
        ret.add((AnalogSignal)ws);
        return ret;
    }

    public DefaultMutableTreeNode getSignalsForExplorer(String analysis) {
        EpicRootTreeNode signalsExplorerTree = new EpicRootTreeNode(this, analysis);
        return signalsExplorerTree;
    }

    public static EpicSignal getSignal(TreePath treePath) {
        int i;
        Object[] path = treePath.getPath();
        for (i = 0; i < path.length && !(path[i] instanceof EpicRootTreeNode); ++i) {
        }
        if (i >= path.length) {
            return null;
        }
        EpicAnalysis an = ((EpicRootTreeNode)path[i]).an;
        ++i;
        int index = 0;
        while (i < path.length) {
            EpicTreeNode tn = (EpicTreeNode)path[i];
            index += tn.nodeOffset;
            if (tn.isLeaf()) {
                return (EpicSignal)an.signalsUnmodifiable.get(index);
            }
            ++i;
        }
        return null;
    }

    @Override
    public List<AnalogSignal> getSignals() {
        return this.signalsUnmodifiable;
    }

    @Override
    public void nameSignal(AnalogSignal ws, String sigName) {
    }

    int searchName(String name) {
        Context context = this.rootContext;
        int pos = 0;
        int index = 0;
        while (true) {
            int indexOfSep;
            if ((indexOfSep = name.indexOf(46, pos)) < 0) {
                EpicTreeNode sig = (EpicTreeNode)context.sigs.get(name.substring(pos));
                return sig != null ? index + sig.nodeOffset : -1;
            }
            EpicTreeNode sub = (EpicTreeNode)context.subs.get(name.substring(pos, indexOfSep));
            if (sub == null) {
                return -1;
            }
            context = sub.context;
            pos = indexOfSep + 1;
            index += sub.nodeOffset;
        }
    }

    String makeName(int index, boolean full) {
        StringBuilder sb = new StringBuilder();
        Context context = this.rootContext;
        if (context == null) {
            return null;
        }
        if (index < 0 || index >= context.treeSize) {
            throw new IndexOutOfBoundsException();
        }
        while (true) {
            int localIndex = context.localSearch(index);
            EpicTreeNode tn = context.nodes[localIndex];
            Context subContext = tn.context;
            if (subContext.isLeaf()) {
                if (full) {
                    sb.append(tn.name);
                } else {
                    if (sb.length() == 0) {
                        return null;
                    }
                    sb.setLength(sb.length() - 1);
                }
                return sb.toString();
            }
            sb.append(tn.name);
            sb.append('.');
            index -= tn.nodeOffset;
            context = subContext;
        }
    }

    static Context getContext(byte type) {
        switch (type) {
            case 1: {
                return VOLTAGE_CONTEXT;
            }
            case 2: {
                return CURRENT_CONTEXT;
            }
        }
        throw new IllegalArgumentException();
    }

    Context getContext(List<String> strings, List<Context> contexts) {
        assert (strings.size() == contexts.size());
        int hashCode = Context.hashValue(strings, contexts);
        int i = hashCode & Integer.MAX_VALUE;
        i %= this.contextHash.length;
        int j = 1;
        while (this.contextHash[i] != null) {
            Context c = this.contextHash[i];
            if (c.hashCode == hashCode && c.equals(strings, contexts)) {
                return c;
            }
            if ((i += j) >= this.contextHash.length) {
                i -= this.contextHash.length;
            }
            j += 2;
        }
        if (this.numContexts * 2 <= this.contextHash.length - 3) {
            Context c;
            this.contextHash[i] = c = new Context(strings, contexts, hashCode);
            ++this.numContexts;
            return c;
        }
        this.rehash();
        return this.getContext(strings, contexts);
    }

    private void rehash() {
        int newSize = this.numContexts * 2 + 3;
        if (newSize < 0) {
            throw new IndexOutOfBoundsException();
        }
        Context[] newHash = new Context[GenMath.primeSince(newSize)];
        for (int k = 0; k < this.contextHash.length; ++k) {
            Context c = this.contextHash[k];
            if (c == null) continue;
            int i = c.hashCode & Integer.MAX_VALUE;
            i %= newHash.length;
            int j = 1;
            while (newHash[i] != null) {
                if ((i += j) >= newHash.length) {
                    i -= newHash.length;
                }
                j += 2;
            }
            newHash[i] = c;
        }
        this.contextHash = newHash;
    }

    @Override
    protected Waveform[] loadWaveforms(AnalogSignal signal) {
        int index = signal.getIndexInAnalysis();
        double valueResolution = this.getValueResolution(index);
        int start = this.waveStarts[index];
        int len = this.waveLengths[index];
        byte[] packedWaveform = new byte[len];
        try {
            this.waveFile.seek(start);
            this.waveFile.readFully(packedWaveform);
        }
        catch (IOException e) {
            ActivityLogger.logException(e);
            return new Waveform[]{new WaveformImpl(new double[0], new double[0])};
        }
        int count = 0;
        int i = 0;
        while (i < len) {
            int b;
            int l = (b = packedWaveform[i++] & 0xFF) < 192 ? 0 : (b < 255 ? 1 : 4);
            i += l;
            b = packedWaveform[i++] & 0xFF;
            l = b < 192 ? 0 : (b < 255 ? 1 : 4);
            i += l;
            ++count;
        }
        double[] time = new double[count];
        double[] value = new double[count];
        count = 0;
        int t = 0;
        int v = 0;
        int i2 = 0;
        while (i2 < len) {
            int l;
            int b;
            if ((b = packedWaveform[i2++] & 0xFF) < 192) {
                l = 0;
            } else if (b < 255) {
                l = 1;
                b -= 192;
            } else {
                l = 4;
            }
            while (l > 0) {
                b = b << 8 | packedWaveform[i2++] & 0xFF;
                --l;
            }
            time[count] = (double)(t += b) * this.timeResolution;
            if ((b = packedWaveform[i2++] & 0xFF) < 192) {
                l = 0;
                b -= 96;
            } else if (b < 255) {
                l = 1;
                b -= 223;
            } else {
                l = 4;
            }
            while (l > 0) {
                b = b << 8 | packedWaveform[i2++] & 0xFF;
                --l;
            }
            value[count] = (double)(v += b) * valueResolution;
            ++count;
        }
        assert (count == time.length);
        return new Waveform[]{new WaveformImpl(time, value)};
    }

    static class EpicSignal
    extends AnalogSignal {
        int sigNum;

        EpicSignal(EpicAnalysis an, byte type, int index, int sigNum) {
            super(an);
            assert (this.getIndexInAnalysis() == index);
            if (type == 1) {
                an.voltageSignals.set(index);
            } else assert (type == 2);
            this.sigNum = sigNum;
        }

        public void setSignalContext(String signalContext) {
            throw new UnsupportedOperationException();
        }

        public String getSignalContext() {
            return ((EpicAnalysis)this.getAnalysis()).makeName(this.getIndexInAnalysis(), false);
        }

        public String getFullName() {
            return ((EpicAnalysis)this.getAnalysis()).makeName(this.getIndexInAnalysis(), true);
        }

        void setBounds(int minV, int maxV) {
            EpicAnalysis an = (EpicAnalysis)this.getAnalysis();
            double resolution = an.getValueResolution(this.getIndexInAnalysis());
            this.bounds = new Rectangle2D.Double(0.0, (double)minV * resolution, an.maxTime, (double)(maxV - minV) * resolution);
            this.leftEdge = 0.0;
            this.rightEdge = an.maxTime;
        }
    }

    public static class EpicTreeNode
    implements TreeNode {
        private final String name;
        private final Context context;
        private final int nodeOffset;
        private int sortedIndex;

        private EpicTreeNode(int chronIndex, String name, Context context, int nodeOffset) {
            this.name = name;
            this.context = context;
            this.nodeOffset = nodeOffset;
        }

        public TreeNode getChildAt(int childIndex) {
            try {
                return this.context.sortedNodes[childIndex];
            }
            catch (NullPointerException e) {
                throw new ArrayIndexOutOfBoundsException("node has no children");
            }
        }

        public int getChildCount() {
            return this.isLeaf() ? 0 : this.context.sortedNodes.length;
        }

        public TreeNode getParent() {
            throw new UnsupportedOperationException();
        }

        public int getIndex(TreeNode node) {
            block3: {
                try {
                    EpicTreeNode tn = (EpicTreeNode)node;
                    if (this.context.nodes[tn.sortedIndex] == tn) {
                        return tn.sortedIndex;
                    }
                }
                catch (Exception e) {
                    if (node != null) break block3;
                    throw new IllegalArgumentException("argument is null");
                }
            }
            return -1;
        }

        public boolean getAllowsChildren() {
            return !this.isLeaf();
        }

        public boolean isLeaf() {
            return this.context.type != 0;
        }

        public Enumeration children() {
            if (this.isLeaf()) {
                return DefaultMutableTreeNode.EMPTY_ENUMERATION;
            }
            return new Enumeration<EpicTreeNode>(){
                int count = 0;

                @Override
                public boolean hasMoreElements() {
                    return this.count < EpicTreeNode.this.context.nodes.length;
                }

                @Override
                public EpicTreeNode nextElement() {
                    if (this.count < EpicTreeNode.this.context.nodes.length) {
                        return EpicTreeNode.this.context.nodes[this.count++];
                    }
                    throw new NoSuchElementException("Vector Enumeration");
                }
            };
        }

        public String toString() {
            return this.name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Context {
        private final byte type;
        private final int hashCode;
        private final EpicTreeNode[] nodes;
        private final EpicTreeNode[] sortedNodes;
        private final int treeSize;
        private final Map<String, EpicTreeNode> subs = new HashMap<String, EpicTreeNode>();
        private final Map<String, EpicTreeNode> sigs = new HashMap<String, EpicTreeNode>();

        private Context(byte type) {
            assert (type != 0);
            this.type = type;
            assert (this.isLeaf());
            this.hashCode = type;
            this.nodes = null;
            this.sortedNodes = null;
            this.treeSize = 1;
        }

        private Context(List<String> names, List<Context> contexts, int hashCode) {
            int i;
            assert (names.size() == contexts.size());
            this.type = 0;
            this.hashCode = hashCode;
            this.nodes = new EpicTreeNode[names.size()];
            int treeSize = 0;
            for (i = 0; i < this.nodes.length; ++i) {
                EpicTreeNode tn;
                String name = names.get(i);
                Context subContext = contexts.get(i);
                this.nodes[i] = tn = new EpicTreeNode(i, name, subContext, treeSize);
                String canonicName = TextUtils.canonicString(name);
                if (subContext.isLeaf()) {
                    this.sigs.put(canonicName, tn);
                } else {
                    this.subs.put(canonicName, tn);
                }
                treeSize += subContext.treeSize;
            }
            this.sortedNodes = (EpicTreeNode[])this.nodes.clone();
            Arrays.sort(this.sortedNodes, TREE_NODE_ORDER);
            for (i = 0; i < this.sortedNodes.length; ++i) {
                this.sortedNodes[i].sortedIndex = i;
            }
            this.treeSize = treeSize;
        }

        boolean isLeaf() {
            return this.type != 0;
        }

        private boolean equals(List<String> names, List<Context> contexts) {
            int len = this.nodes.length;
            if (names.size() != len || contexts.size() != len) {
                return false;
            }
            for (int i = 0; i < len; ++i) {
                EpicTreeNode tn = this.nodes[i];
                if (names.get(i) == tn.name && contexts.get(i) == tn.context) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return this.hashCode;
        }

        private static int hashValue(List<String> names, List<Context> contexts) {
            assert (names.size() == contexts.size());
            int hash = 0;
            for (int i = 0; i < names.size(); ++i) {
                hash = hash * 19 + names.get(i).hashCode() ^ contexts.get(i).hashCode();
            }
            return hash;
        }

        private int localSearch(int offset) {
            assert (offset >= 0 && offset < this.treeSize);
            assert (this.nodes.length > 0);
            int l = 1;
            int h = this.nodes.length - 1;
            while (l <= h) {
                int m = l + h >> 1;
                if (this.nodes[m].nodeOffset <= offset) {
                    l = m + 1;
                    continue;
                }
                h = m - 1;
            }
            return h;
        }
    }

    private static class EpicRootTreeNode
    extends DefaultMutableTreeNode {
        private EpicAnalysis an;

        private EpicRootTreeNode(EpicAnalysis an, String name) {
            super(name);
            this.an = an;
            Vector<EpicTreeNode> children = new Vector<EpicTreeNode>();
            for (EpicTreeNode tn : an.rootContext.sortedNodes) {
                children.add(tn);
            }
            this.children = children;
        }

        public int getIndex(TreeNode aChild) {
            block3: {
                try {
                    EpicTreeNode tn = (EpicTreeNode)aChild;
                    if (this.getChildAt(tn.sortedIndex) == tn) {
                        return tn.sortedIndex;
                    }
                }
                catch (Exception e) {
                    if (aChild != null) break block3;
                    throw new IllegalArgumentException("argument is null");
                }
            }
            return -1;
        }
    }
}

