/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.variable.EditWindow_;
import com.sun.electric.database.variable.UserInterface;
import com.sun.electric.tool.Client;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.Highlight;
import java.awt.geom.Point2D;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.SecureRandom;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivityLogger {
    private static final boolean TEST_VERSION = Version.getVersion().getDetail() != 999;
    private static boolean logMenuActivations;
    private static boolean logJobs;
    private static boolean logTimeStamps;
    private static boolean exceptionLogged;
    private static PrintWriter out;
    private static String outputFile;
    private static int loggedCount;
    private static final SecureRandom random;

    public static synchronized void initialize(String fileName, boolean logMenuActivations, boolean logJobs, boolean useTimeStamps, boolean enableLog, boolean multipleLog) {
        ActivityLogger.logMenuActivations = logMenuActivations;
        ActivityLogger.logJobs = logJobs;
        logTimeStamps = useTimeStamps;
        if (!enableLog) {
            return;
        }
        String dirName = Client.isOSMac() ? System.getProperty("user.home") : System.getProperty("user.dir");
        outputFile = dirName + File.separator + fileName;
        File dir = new File(dirName);
        try {
            if (multipleLog) {
                long n = random.nextLong();
                n = n == Long.MIN_VALUE ? 0L : Math.abs(n);
                outputFile = outputFile + "-" + n + ".log";
            } else {
                outputFile = outputFile + ".log";
            }
            File file = new File(outputFile);
            FileOutputStream fos = new FileOutputStream(file);
            BufferedOutputStream bout = new BufferedOutputStream(fos);
            out = new PrintWriter(bout);
        }
        catch (IOException e) {
            System.out.println("Warning: Activity Log disabled: " + e.getMessage());
            System.out.println("Activity logs are sent to the standard output once you close Electric.");
            out = new PrintWriter(System.out);
        }
        if (out != null) {
            out.println("Electric " + Version.getVersionInformation());
        }
    }

    public static String getLoggingInformation() {
        if (outputFile != null) {
            return "Electric's log file is " + outputFile + ".\n";
        }
        return "Logging is disable. Electric must be restarted to resume logging.\n";
    }

    public static synchronized void finished() {
        if (out != null) {
            out.close();
        }
        if (exceptionLogged && TEST_VERSION) {
            Job.getUserInterface().showInformationMessage("Exception logged.  Please send \n   \"" + outputFile + "\"\n to the developers", "Exception Logged");
        }
    }

    public static synchronized void logMenuActivated(String menuDescription) {
        List<Highlight> savedContents;
        if (out == null) {
            return;
        }
        if (!logMenuActivations) {
            return;
        }
        ActivityLogger.printDelimeter(true);
        out.println("Menu Activated: " + menuDescription);
        UserInterface ui = Job.getUserInterface();
        EditWindow_ wnd = ui.getCurrentEditWindow_();
        if (wnd != null && (savedContents = wnd.saveHighlightList()) != null) {
            ActivityLogger.logHighlights(savedContents, wnd.getHighlightOffset());
        }
    }

    public static synchronized void logToolBarButtonActivated(String buttonName) {
        if (out == null) {
            return;
        }
        if (!logMenuActivations) {
            return;
        }
        ActivityLogger.printDelimeter(true);
        out.println("ToolBarButton Activated: " + buttonName);
    }

    public static synchronized void logJobStarted(String jobName, Job.Type jobType, Cell cell, List<Highlight> savedHighlights, Point2D savedHighlightsOffset) {
        if (out == null) {
            return;
        }
        if (!logJobs) {
            return;
        }
        ActivityLogger.printDelimeter(true);
        String cellName = cell == null ? "none" : cell.libDescribe();
        new Exception("stack trace");
        out.println("Job Started [Current Cell: " + cellName + "] " + jobName + ", " + (Object)((Object)jobType));
        ActivityLogger.logHighlights(savedHighlights, savedHighlightsOffset);
    }

    public static synchronized void logHighlights(List<Highlight> highlights, Point2D offset) {
        if (out == null) {
            return;
        }
        if (highlights.size() == 0) {
            return;
        }
        out.println("Currently highlighted: ");
        for (Highlight h : highlights) {
            out.println("    " + h.describe());
        }
    }

    public static synchronized void logTime(long time) {
        if (out == null) {
            return;
        }
        if (!logTimeStamps) {
            return;
        }
        Date date = new Date(time);
        out.println("Time: " + date);
    }

    public static synchronized void logException(Throwable e) {
        if (out != null) {
            ActivityLogger.printDelimeter(true);
            e.printStackTrace(out);
            out.flush();
        }
        e.printStackTrace(System.out);
        String msg1 = "Exception Caught!!!";
        String msg2 = "The exception below has been logged in '" + outputFile + "'.";
        String msg3 = "Please help us and report error to developers using 'Bugzilla'. In case of no access, send logfile to the developers.";
        String msg4 = e.toString();
        String msg = TEST_VERSION ? msg1 + "\n" + msg2 + "\n" + msg3 + "\n" + msg4 : msg1 + "\n" + msg2 + "\n" + msg4;
        if (Job.getUserInterface() != null) {
            Job.getUserInterface().showErrorMessage(msg, "Exception Caught");
        } else {
            System.out.println(msg);
        }
        exceptionLogged = true;
    }

    public static synchronized void logMessage(String msg) {
        if (out == null) {
            return;
        }
        ActivityLogger.printDelimeter(true);
        out.println(msg);
    }

    public static synchronized void logThreadMessage(String msg) {
        if (out == null) {
            return;
        }
        ActivityLogger.printDelimeter(false);
        out.println(msg);
    }

    private static synchronized void printDelimeter(boolean printThreadInfo) {
        if (out == null) {
            return;
        }
        out.println("--------------- " + loggedCount + " --------------");
        new Exception("stack trace");
        if (logTimeStamps) {
            Date date = new Date(System.currentTimeMillis());
            out.println("  " + date);
        }
        ++loggedCount;
    }

    static {
        out = null;
        loggedCount = 0;
        random = new SecureRandom();
    }
}

