/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.test;

import com.sun.electric.tool.simulation.test.BitVector;
import com.sun.electric.tool.simulation.test.ChainNode;
import com.sun.electric.tool.simulation.test.JtagTester;
import com.sun.electric.tool.simulation.test.MyTreeNode;
import com.sun.electric.tool.simulation.test.Name;
import com.sun.electric.tool.simulation.test.SimulationModel;
import com.sun.electric.tool.simulation.test.SubchainNode;
import java.util.ArrayList;
import java.util.List;

public abstract class BypassJtagTester
extends JtagTester {
    protected final SimulationModel model;
    protected float tapVolt;
    protected double delay;
    private static final boolean DEBUG = false;

    BypassJtagTester(SimulationModel nm) {
        this.model = nm;
    }

    void configure(float tapVolt, long kiloHerz) {
        this.tapVolt = tapVolt;
        this.delay = 1.0 / (double)kiloHerz * 1000000.0 / 2.0;
    }

    void disconnect() {
    }

    void setLogicOutput(int index2, boolean newLevel) {
        System.out.println("Nanosim JtagTester does not support 'setLogicOutput(" + index2 + ", " + newLevel + "). Use LogicSettable instead.");
    }

    public boolean isBypassScanning() {
        return this.model.isBypassScanning();
    }

    protected void doBypassScanning(ChainNode chain2, boolean readEnable, boolean writeEnable) {
        if (readEnable) {
            chain2.getOutBits().put(0, this.readDirect(chain2));
        } else {
            chain2.getOutBits().putIndiscriminate(0, chain2.getOutBitsExpected());
        }
        if (writeEnable) {
            BitVector bitsToCheck = this.writeDirect(chain2);
            this.checkDataNets(chain2, 0, bitsToCheck);
            this.checkDataNets(chain2, 1, bitsToCheck);
        }
    }

    protected static List getDataNets(SubchainNode chain2, int set) {
        MyTreeNode system = chain2.getParent().getParent();
        MyTreeNode scanchainnets = MyTreeNode.getNode(system, "scanChainDataNets");
        if (scanchainnets == null) {
            return BypassJtagTester.getDataNetsOld(chain2, set);
        }
        SubchainNode datachain = (SubchainNode)MyTreeNode.getNode(scanchainnets, chain2.getName());
        if (datachain == null) {
            MyTreeNode chip = chain2.getParent();
            datachain = (SubchainNode)MyTreeNode.getNode(scanchainnets, chip.getName() + "_" + chain2.getName());
        }
        if (datachain == null) {
            return BypassJtagTester.getDataNetsOld(chain2, set);
        }
        ArrayList<SubchainNode.DataNet> datanets = new ArrayList<SubchainNode.DataNet>();
        for (int i = 0; i < datachain.getChildCount(); ++i) {
            SubchainNode subnode = (SubchainNode)datachain.getChildAt(i);
            if (set == 0) {
                datanets.add(subnode.getDataNet());
                continue;
            }
            datanets.add(subnode.getDataNet2());
        }
        return datanets;
    }

    protected static List getDataNetsOld(SubchainNode chain2, int set) {
        if (chain2.getChildCount() == 0) {
            ArrayList<SubchainNode.DataNet> list2 = new ArrayList<SubchainNode.DataNet>();
            SubchainNode.DataNet dataNet = set == 0 ? chain2.getDataNet() : chain2.getDataNet2();
            if (dataNet == null || dataNet.getName().equals("")) {
                for (int i = 0; i < chain2.getLength(); ++i) {
                    list2.add(null);
                }
                return list2;
            }
            MyTreeNode[] hier = chain2.getParent().getHierarchy();
            StringBuffer newPath = new StringBuffer();
            for (int j = 0; j < hier.length; ++j) {
                if (j < 3) continue;
                newPath.append("X" + hier[j].getName() + ".");
            }
            boolean fakeChain = false;
            if (chain2.getParentChain().getOpcode().equals("fakeChain")) {
                fakeChain = true;
            }
            Name netName = Name.findName(dataNet.getName());
            if (fakeChain) {
                for (int j = 0; j < netName.busWidth(); ++j) {
                    String net = netName.subname(j).toString();
                    SubchainNode.DataNet singleNet = new SubchainNode.DataNet(newPath.toString() + net, dataNet.isReadable(), dataNet.isWriteable(), dataNet.isInverted());
                    list2.add(singleNet);
                }
            } else {
                Name dataName = Name.findName(chain2.getName());
                for (int i = 0; i < dataName.busWidth(); ++i) {
                    netName = Name.findName(dataNet.getName());
                    for (int j = 0; j < netName.busWidth(); ++j) {
                        String net = "x" + dataName.subname(i).toString() + "." + netName.subname(j).toString();
                        SubchainNode.DataNet singleNet = new SubchainNode.DataNet(newPath.toString() + net, dataNet.isReadable(), dataNet.isWriteable(), dataNet.isInverted());
                        list2.add(singleNet);
                    }
                }
            }
            if (list2.size() != chain2.getLength()) {
                System.out.println("Error: data net list of size " + list2.size() + " does not match length of chain " + chain2.getName() + " of length " + chain2.getLength());
                list2.clear();
                for (int i = 0; i < chain2.getLength(); ++i) {
                    list2.add(null);
                }
                return list2;
            }
            return list2;
        }
        ArrayList list3 = new ArrayList();
        for (int i = 0; i < chain2.getChildCount(); ++i) {
            SubchainNode subnode = (SubchainNode)chain2.getChildAt(i);
            list3.addAll(BypassJtagTester.getDataNets(subnode, set));
        }
        return list3;
    }

    protected boolean checkDataNets(ChainNode chain2, int set, BitVector bitsToCheck) {
        boolean foundDiscrepancy = false;
        List dataNets = BypassJtagTester.getDataNets(chain2, set);
        if (bitsToCheck.getNumBits() != dataNets.size()) {
            System.out.println("Can't check dataNets, bitsToCheck size does not match chain length");
            return false;
        }
        for (int i = 0; i < dataNets.size(); ++i) {
            int setState;
            SubchainNode.DataNet dataNet = (SubchainNode.DataNet)dataNets.get(i);
            if (dataNet == null || !dataNet.isWriteable() || !bitsToCheck.get(i)) continue;
            int simState = this.model.getNodeState(this.formatDataNetName(dataNet.getName()));
            int n = setState = chain2.getInBits().get(i) ? 1 : 0;
            if (dataNet.isInverted()) {
                int n2 = setState = setState == 1 ? 0 : 1;
            }
            if (simState == setState) continue;
            System.out.println("Error! Attempted to set bit '" + this.formatDataNetName(dataNet.getName()) + "' to " + setState + " via the scan chain at time " + this.model.getSimulationTime() + ", but its state is " + simState);
            foundDiscrepancy = true;
        }
        return foundDiscrepancy;
    }

    protected BitVector readDirect(ChainNode chain2) {
        List dataNets = BypassJtagTester.getDataNets(chain2, 0);
        List dataNets2 = BypassJtagTester.getDataNets(chain2, 1);
        BitVector outBits = new BitVector(chain2.getOutBits().getNumBits(), "outBits");
        int bitsRead = 0;
        int numOptimizedReads = 0;
        for (int i = 0; i < outBits.getNumBits(); ++i) {
            SubchainNode node = chain2.findNodeAtIndex(i);
            if (!node.isReadable()) continue;
            if (this.model.getOptimizedDirectReadsWrites() && node.usesShadow() && !node.usesDualPortedShadow() && chain2.getShadowState().isValid(i)) {
                outBits.set(i, chain2.getShadowState().get(i));
                ++numOptimizedReads;
                continue;
            }
            SubchainNode.DataNet dataNet = (SubchainNode.DataNet)dataNets.get(i);
            SubchainNode.DataNet dataNet2 = (SubchainNode.DataNet)dataNets2.get(i);
            int state = this.readDirect(dataNet);
            int state2 = this.readDirect(dataNet2);
            if (state >= 0 && state2 >= 0 && state != state2) {
                System.out.println("Error! Inconsistency reading directly from scan chain data bit " + i + " of chain '" + chain2.getName() + "', " + this.formatDataNetName(dataNet.getName()) + " is " + state + " and " + dataNet2.getName() + " is " + state2);
            }
            if (state < 0) {
                state = state2;
            }
            if (state < 0) {
                if (chain2.getInBits().isValid(i)) {
                    int n = state = chain2.getInBits().get(i) ? 1 : 0;
                }
                if (state == -2) {
                    ++bitsRead;
                }
            } else {
                ++bitsRead;
            }
            outBits.set(i, state == 1);
        }
        String optReadsInfo = "";
        if (numOptimizedReads > 0) {
            optReadsInfo = " " + numOptimizedReads + " optimized reads.";
        }
        if (this.printInfo) {
            System.out.println("Info: Read directly " + bitsRead + " bits from chain '" + chain2.getName() + "' of length " + chain2.getOutBits().getNumBits() + " bits (others unchanged)." + optReadsInfo);
        }
        return outBits;
    }

    private int readDirect(SubchainNode.DataNet dataNet) {
        if (dataNet == null) {
            return -1;
        }
        if (!dataNet.isReadable()) {
            return -1;
        }
        int state = this.model.getNodeState(this.formatDataNetName(dataNet.getName()));
        if (state == -2) {
            System.out.println("Warning, read intermediate (undefined) voltage state from net " + this.formatDataNetName(dataNet.getName()) + " at time " + this.model.getSimulationTime());
        }
        if (state < 0) {
            return state;
        }
        if (dataNet.isInverted()) {
            state = state == 1 ? 0 : 1;
        }
        return state;
    }

    protected BitVector writeDirect(ChainNode chain2) {
        List dataNets = BypassJtagTester.getDataNets(chain2, 0);
        List dataNets2 = BypassJtagTester.getDataNets(chain2, 1);
        int dataNetsWritten = 0;
        int dataNet2sWritten = 0;
        int numOptimizedWrites = 0;
        ArrayList<SubchainNode.DataNet> writtenDataNets = new ArrayList<SubchainNode.DataNet>();
        BitVector bitsWritten = new BitVector(chain2.getInBits().getNumBits(), "bitsWritten");
        for (int i = 0; i < chain2.getInBits().getNumBits(); ++i) {
            SubchainNode node = chain2.findNodeAtIndex(i);
            bitsWritten.set(i, false);
            if (!node.isWriteable()) continue;
            if (this.model.getOptimizedDirectReadsWrites() && (node.usesShadow() || node.usesDualPortedShadow()) && chain2.getShadowState().isValid(i) && chain2.getShadowState().get(i) == chain2.getInBits().get(i)) {
                ++numOptimizedWrites;
                continue;
            }
            if (chain2.getInBits().isValid(i)) {
                int state = chain2.getInBits().get(i) ? 1 : 0;
                SubchainNode.DataNet dataNet = (SubchainNode.DataNet)dataNets.get(i);
                SubchainNode.DataNet dataNet2 = (SubchainNode.DataNet)dataNets2.get(i);
                if (this.writeDirect(dataNet, state)) {
                    writtenDataNets.add(dataNet);
                    bitsWritten.set(i, true);
                    ++dataNetsWritten;
                }
                if (!this.writeDirect(dataNet2, state)) continue;
                writtenDataNets.add(dataNet);
                bitsWritten.set(i, true);
                ++dataNet2sWritten;
                continue;
            }
            System.out.println("Could not write bit " + i + " of chain " + chain2.getName() + " because it is not in a valid state");
        }
        this.model.waitNS(this.delay * 3.0);
        if (!chain2.getOpcode().equals("fakeChain")) {
            this.model.releaseNodes(this.getNames(writtenDataNets));
        }
        String optWritesInfo = "";
        if (numOptimizedWrites > 0) {
            optWritesInfo = " " + numOptimizedWrites + " optimized writes.";
        }
        this.model.waitNS(this.delay * 1.0);
        if (this.printInfo) {
            System.out.println("Info: Wrote directly " + dataNetsWritten + " bits and " + dataNet2sWritten + " secondary bits from scan chain '" + chain2.getName() + "' of length " + chain2.getInBits().getNumBits() + " bits." + optWritesInfo);
        }
        return bitsWritten;
    }

    private boolean writeDirect(SubchainNode.DataNet dataNet, int state) {
        if (dataNet == null) {
            return false;
        }
        if (!dataNet.isWriteable()) {
            return false;
        }
        if (dataNet.isInverted()) {
            state = state == 1 ? 0 : 1;
        }
        this.model.setNodeState(this.formatDataNetName(dataNet.getName()), state);
        return true;
    }

    String formatDataNetName(String dataNetName) {
        return dataNetName;
    }

    private List getNames(List dataNets) {
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < dataNets.size(); ++i) {
            SubchainNode.DataNet dataNet = (SubchainNode.DataNet)dataNets.get(i);
            if (dataNet == null) continue;
            names.add(this.formatDataNetName(dataNet.getName()));
        }
        return names;
    }
}

