/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.test;

import com.sun.electric.tool.simulation.test.Infrastructure;
import com.sun.electric.tool.simulation.test.MyTreeNode;

class TestNode
extends MyTreeNode {
    public static final int CLEARS_NOT = 0;
    public static final int CLEARS_LO = 1;
    public static final int CLEARS_HI = 2;
    public static final int CLEARS_UNKNOWN = 3;
    public static final String[] CLEARS_STRINGS = new String[]{"-", "L", "H", "?"};
    private boolean unpredictable = false;
    private boolean readable = true;
    private boolean writeable = true;
    private boolean usesShadow = false;
    private boolean usesDualPortedShadow = false;
    private int clearBehavior = 3;

    public TestNode(String name, String comment2) {
        super(name, comment2);
    }

    public String toString() {
        return super.toString() + " " + this.getState();
    }

    String getState() {
        StringBuffer buffer = new StringBuffer("[");
        if (this.unpredictable) {
            buffer.append("U");
        }
        if (this.readable) {
            buffer.append("R");
        }
        if (this.writeable) {
            buffer.append("W");
        }
        if (this.usesShadow) {
            buffer.append("S");
        }
        if (this.usesDualPortedShadow) {
            buffer.append("D");
        }
        buffer.append("/" + CLEARS_STRINGS[this.clearBehavior] + "]");
        return buffer.toString();
    }

    public int getClearBehavior() {
        return this.clearBehavior;
    }

    public boolean isUnpredictable() {
        return this.unpredictable;
    }

    public boolean isReadable() {
        return this.readable;
    }

    public boolean isWriteable() {
        return this.writeable;
    }

    public boolean usesShadow() {
        return this.usesShadow;
    }

    public boolean usesDualPortedShadow() {
        return this.usesDualPortedShadow;
    }

    void setClearBehavior(int clearBehavior) {
        this.clearBehavior = clearBehavior;
    }

    void setUnpredictable(boolean unpredictable) {
        this.unpredictable = unpredictable;
    }

    void setWriteable(boolean writeable) {
        this.writeable = writeable;
    }

    void setReadable(boolean readable) {
        this.readable = readable;
    }

    void setUsesDualPortedShadow(boolean usesDualPortedShadow) {
        this.usesDualPortedShadow = usesDualPortedShadow;
    }

    public void setUsesShadow(boolean usesShadow) {
        this.usesShadow = usesShadow;
        if (usesShadow && !this.isWriteable()) {
            Infrastructure.nonfatal("WARNING: non-writeable shadow register");
        }
    }

    void compareAccessAndClears(TestNode that, String thisFile, String thatFile) {
        if (this.getClearBehavior() != that.getClearBehavior()) {
            System.out.println("**** Node " + thisFile + ":" + this.getPathString(1) + " has clears '" + CLEARS_STRINGS[this.getClearBehavior()] + "', but " + thatFile + ":" + that.getPathString(1) + " has clears '" + CLEARS_STRINGS[that.getClearBehavior()] + "'");
        }
    }

    void compare(TestNode that, String thisFile, String thatFile) {
        super.compare(that, thisFile, thatFile);
    }

    public static void main(String[] args) {
        TestNode node = new TestNode("sys1", "com1");
        System.out.println(node);
        node = new TestNode("sys2", "com2");
        System.out.println("Should complain about non-writeable shadow reg");
        node.setReadable(true);
        node.setWriteable(false);
        node.setUsesShadow(true);
        node.setClearBehavior(1);
        System.out.println(node);
    }
}

