/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.options;

import com.sun.electric.database.text.Setting;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.logicaleffort.LETool;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.dialogs.PreferencesFrame;
import com.sun.electric.tool.user.dialogs.options.PreferencePanel;
import com.sun.electric.util.TextUtils;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class LogicalEffortTab
extends PreferencePanel {
    private boolean changingLE;
    private Setting useLocalSettingsSetting = LETool.getUseLocalSettingsSetting();
    private Setting globalFanoutSetting = LETool.getGlobalFanoutSetting();
    private Setting convergenceEpsilonSetting = LETool.getConvergenceEpsilonSetting();
    private Setting maxIterationsSetting = LETool.getMaxIterationsSetting();
    private Setting keeperRatioSetting = LETool.getKeeperRatioSetting();
    private JLabel jLabel1;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel2;
    private JLabel jLabel20;
    private JLabel jLabel22;
    private JLabel jLabel23;
    private JLabel jLabel25;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JTextField leConvergence;
    private JTextField leDefaultWireCapRatio;
    private JTextField leDiffToGateCapRatio;
    private JTextField leGateCapacitance;
    private JTextField leGlobalFanOut;
    private JTextField leKeeperSizeRatio;
    private JTextField leMaxIterations;
    private JComboBox leTechnology;
    private JCheckBox leUseLocalSettings;
    private JPanel logicalEffort;

    public LogicalEffortTab(PreferencesFrame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        EDialog.makeTextFieldSelectAllOnTab(this.leGlobalFanOut);
        EDialog.makeTextFieldSelectAllOnTab(this.leConvergence);
        EDialog.makeTextFieldSelectAllOnTab(this.leMaxIterations);
        EDialog.makeTextFieldSelectAllOnTab(this.leKeeperSizeRatio);
        EDialog.makeTextFieldSelectAllOnTab(this.leGateCapacitance);
        EDialog.makeTextFieldSelectAllOnTab(this.leDefaultWireCapRatio);
        EDialog.makeTextFieldSelectAllOnTab(this.leDiffToGateCapRatio);
    }

    public JPanel getUserPreferencesPanel() {
        return null;
    }

    public JPanel getProjectPreferencesPanel() {
        return this.logicalEffort;
    }

    public String getName() {
        return "Logical Effort";
    }

    public void init() {
        this.leUseLocalSettings.setSelected(this.getBoolean(this.useLocalSettingsSetting));
        this.leGlobalFanOut.setText(this.getFormattedDouble(this.globalFanoutSetting));
        this.leConvergence.setText(this.getFormattedDouble(this.convergenceEpsilonSetting));
        this.leMaxIterations.setText(String.valueOf(this.getInt(this.maxIterationsSetting)));
        this.leKeeperSizeRatio.setText(this.getFormattedDouble(this.keeperRatioSetting));
        Iterator<Technology> it = Technology.getTechnologies();
        while (it.hasNext()) {
            Technology tech = it.next();
            if (!tech.isLayout()) continue;
            this.leTechnology.addItem(tech.getTechName());
        }
        this.leTechnology.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LogicalEffortTab.this.showArcsInTechnology();
            }
        });
        this.leTechnology.setSelectedItem(Technology.getCurrent().getTechName());
        this.changingLE = false;
        this.leGateCapacitance.getDocument().addDocumentListener(new LEDocumentListener(this));
        this.leDefaultWireCapRatio.getDocument().addDocumentListener(new LEDocumentListener(this));
        this.leDiffToGateCapRatio.getDocument().addDocumentListener(new LEDocumentListener(this));
    }

    public void term() {
        this.setBoolean(this.useLocalSettingsSetting, this.leUseLocalSettings.isSelected());
        this.setDouble(this.globalFanoutSetting, TextUtils.atof(this.leGlobalFanOut.getText()));
        this.setDouble(this.convergenceEpsilonSetting, TextUtils.atof(this.leConvergence.getText()));
        this.setInt(this.maxIterationsSetting, Integer.parseInt(this.leMaxIterations.getText()));
        this.setDouble(this.keeperRatioSetting, TextUtils.atof(this.leKeeperSizeRatio.getText()));
    }

    public void reset() {
    }

    private void leInfoChanged() {
        if (this.changingLE) {
            return;
        }
        String techName = (String)this.leTechnology.getSelectedItem();
        Technology tech = Technology.findTechnology(techName);
        if (tech == null) {
            return;
        }
        this.setDouble(tech.getGateCapacitanceSetting(), TextUtils.atof(this.leGateCapacitance.getText()));
        this.setDouble(tech.getWireRatioSetting(), TextUtils.atof(this.leDefaultWireCapRatio.getText()));
        this.setDouble(tech.getDiffAlphaSetting(), TextUtils.atof(this.leDiffToGateCapRatio.getText()));
    }

    private void showArcsInTechnology() {
        String techName = (String)this.leTechnology.getSelectedItem();
        Technology tech = Technology.findTechnology(techName);
        if (tech == null) {
            return;
        }
        this.changingLE = true;
        this.leGateCapacitance.setText(this.getFormattedDouble(tech.getGateCapacitanceSetting()));
        this.leDefaultWireCapRatio.setText(this.getFormattedDouble(tech.getWireRatioSetting()));
        this.leDiffToGateCapRatio.setText(this.getFormattedDouble(tech.getDiffAlphaSetting()));
        this.changingLE = false;
    }

    private void initComponents() {
        this.logicalEffort = new JPanel();
        this.jLabel4 = new JLabel();
        this.jLabel14 = new JLabel();
        this.jLabel15 = new JLabel();
        this.jLabel25 = new JLabel();
        this.leUseLocalSettings = new JCheckBox();
        this.leGlobalFanOut = new JTextField();
        this.leConvergence = new JTextField();
        this.leMaxIterations = new JTextField();
        this.leKeeperSizeRatio = new JTextField();
        this.jPanel1 = new JPanel();
        this.jLabel23 = new JLabel();
        this.leDiffToGateCapRatio = new JTextField();
        this.jLabel22 = new JLabel();
        this.leDefaultWireCapRatio = new JTextField();
        this.jLabel20 = new JLabel();
        this.leGateCapacitance = new JTextField();
        this.jLabel1 = new JLabel();
        this.leTechnology = new JComboBox();
        this.jLabel2 = new JLabel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Tool Options");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                LogicalEffortTab.this.closeDialog(evt);
            }
        });
        this.logicalEffort.setLayout(new GridBagLayout());
        this.jLabel4.setText("Global Fan-Out (step-up):");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.logicalEffort.add((Component)this.jLabel4, gridBagConstraints);
        this.jLabel14.setText("Convergence epsilon:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.logicalEffort.add((Component)this.jLabel14, gridBagConstraints);
        this.jLabel15.setText("Maximum number of iterations:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.logicalEffort.add((Component)this.jLabel15, gridBagConstraints);
        this.jLabel25.setText("Keeper size ratio (keeper size / driver size):");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.logicalEffort.add((Component)this.jLabel25, gridBagConstraints);
        this.leUseLocalSettings.setText("Use Local (cell) LE Settings");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 6, 4, 4);
        this.logicalEffort.add((Component)this.leUseLocalSettings, gridBagConstraints);
        this.leGlobalFanOut.setColumns(12);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.logicalEffort.add((Component)this.leGlobalFanOut, gridBagConstraints);
        this.leConvergence.setColumns(12);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.logicalEffort.add((Component)this.leConvergence, gridBagConstraints);
        this.leMaxIterations.setColumns(12);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.logicalEffort.add((Component)this.leMaxIterations, gridBagConstraints);
        this.leKeeperSizeRatio.setColumns(12);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.logicalEffort.add((Component)this.leKeeperSizeRatio, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Tech-specific"));
        this.jLabel23.setText("Diffusion to gate cap ratio (alpha) :");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.jLabel23, gridBagConstraints);
        this.leDiffToGateCapRatio.setColumns(12);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.leDiffToGateCapRatio, gridBagConstraints);
        this.jLabel22.setText("Default wire cap ratio (Cwire / Cgate):");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.jLabel22, gridBagConstraints);
        this.leDefaultWireCapRatio.setColumns(12);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.leDefaultWireCapRatio, gridBagConstraints);
        this.jLabel20.setText("Gate capacitance (fF/Lambda):");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.jLabel20, gridBagConstraints);
        this.leGateCapacitance.setColumns(12);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.leGateCapacitance, gridBagConstraints);
        this.jLabel1.setText("For Technology:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.leTechnology, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.logicalEffort.add((Component)this.jPanel1, gridBagConstraints);
        this.getContentPane().add((Component)this.logicalEffort, new GridBagConstraints());
        this.jLabel2.setFont(new Font("Tahoma", 1, 11));
        this.jLabel2.setText("All values here are Project Preferences");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.getContentPane().add((Component)this.jLabel2, gridBagConstraints);
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private static class LEDocumentListener
    implements DocumentListener {
        private LogicalEffortTab dialog;

        LEDocumentListener(LogicalEffortTab dialog) {
            this.dialog = dialog;
        }

        public void changedUpdate(DocumentEvent e) {
            this.dialog.leInfoChanged();
        }

        public void insertUpdate(DocumentEvent e) {
            this.dialog.leInfoChanged();
        }

        public void removeUpdate(DocumentEvent e) {
            this.dialog.leInfoChanged();
        }
    }
}

