/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.erc.wellcheck;

import com.sun.electric.tool.erc.ERCWellCheck;
import com.sun.electric.tool.erc.wellcheck.WellCheckAnalysisStrategy;
import com.sun.electric.tool.erc.wellcheck.WellCon;
import java.util.HashMap;
import java.util.HashSet;

public class ShortCircuitCheck
implements WellCheckAnalysisStrategy {
    private ERCWellCheck.StrategyParameter parameter;

    public ShortCircuitCheck(ERCWellCheck.StrategyParameter parameter) {
        this.parameter = parameter;
    }

    @Override
    public void execute() {
        HashMap<Integer, WellCon> wellContacts = new HashMap<Integer, WellCon>();
        HashMap wellShorts = new HashMap();
        System.out.println("Number of well contacts: " + this.parameter.getWellCons().size());
        for (WellCon wc : this.parameter.getWellCons()) {
            Integer otherNetNum;
            HashSet<Integer> shortsInOther;
            Integer wellIndex = new Integer(wc.getWellNum().getIndex());
            WellCon other = (WellCon)wellContacts.get(wellIndex);
            if (other == null) {
                wellContacts.put(wellIndex, wc);
                continue;
            }
            if (wc.getNetNum() == other.getNetNum() || wc.getNi() == other.getNi()) continue;
            Integer wcNetNum = new Integer(wc.getNetNum());
            HashSet<Integer> shortsInWC = (HashSet<Integer>)wellShorts.get(wcNetNum);
            if (shortsInWC == null) {
                shortsInWC = new HashSet<Integer>();
                wellShorts.put(wcNetNum, shortsInWC);
            }
            if ((shortsInOther = (HashSet<Integer>)wellShorts.get(otherNetNum = new Integer(other.getNetNum()))) == null) {
                shortsInOther = new HashSet<Integer>();
                wellShorts.put(otherNetNum, shortsInOther);
            }
            if (shortsInWC.contains(otherNetNum)) continue;
            this.parameter.logError("Short circuit between well contacts", wc, other);
            shortsInWC.add(otherNetNum);
            shortsInOther.add(wcNetNum);
        }
    }
}

