/*
 * Decompiled with CFR 0.152.
 */
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class ColorFormatter
extends SimpleFormatter {
    private static final int SEVERE = Level.SEVERE.intValue();
    private static final int WARNING = Level.WARNING.intValue();

    @Override
    public String format(LogRecord record) {
        String body = super.format(record);
        int v = record.getLevel().intValue();
        if (v >= SEVERE) {
            return "\u001b[31m" + body + "\u001b[0m";
        }
        if (v >= WARNING) {
            return "\u001b[33m" + body + "\u001b[0m";
        }
        return body;
    }

    public static void install() {
        Handler[] handlers;
        if (System.console() == null) {
            return;
        }
        for (Handler h : handlers = Logger.getLogger("").getHandlers()) {
            if (h.getClass() != ConsoleHandler.class || h.getFormatter().getClass() != SimpleFormatter.class) continue;
            h.setFormatter(new ColorFormatter());
        }
    }
}

